/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Kerning
implements SWFEncodeable {
    private static final String FORMAT = "Kerning: { leftGlyph=%d; rightGlyph=%d; adjustment=%d}";
    private final transient int leftGlyph;
    private final transient int rightGlyph;
    private final transient int adjustment;

    public Kerning(SWFDecoder coder, Context context) throws IOException {
        if (context.contains(4)) {
            this.leftGlyph = coder.readSignedShort();
            this.rightGlyph = coder.readSignedShort();
        } else {
            this.leftGlyph = coder.readByte();
            this.rightGlyph = coder.readByte();
        }
        this.adjustment = coder.readSignedShort();
    }

    public Kerning(int leftIndex, int rightIndex, int adjust) {
        if (leftIndex < 0 || leftIndex >= 65535) {
            throw new IllegalArgumentRangeException(0, 65534, leftIndex);
        }
        this.leftGlyph = leftIndex;
        if (rightIndex < 0 || rightIndex >= 65535) {
            throw new IllegalArgumentRangeException(0, 65534, rightIndex);
        }
        this.rightGlyph = rightIndex;
        if (adjust < Short.MIN_VALUE || adjust > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, adjust);
        }
        this.adjustment = adjust;
    }

    public int getLeftGlyph() {
        return this.leftGlyph;
    }

    public int getRightGlyph() {
        return this.rightGlyph;
    }

    public int getAdjustment() {
        return this.adjustment;
    }

    public String toString() {
        return String.format(FORMAT, this.leftGlyph, this.rightGlyph, this.adjustment);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof Kerning) {
            Kerning kerning = (Kerning)object;
            result = this.leftGlyph == kerning.leftGlyph && this.rightGlyph == kerning.rightGlyph && this.adjustment == kerning.adjustment;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return (this.leftGlyph * 31 + this.rightGlyph) * 31 + this.adjustment;
    }

    @Override
    public int prepareToEncode(Context context) {
        return context.contains(4) ? 6 : 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (context.contains(4)) {
            coder.writeShort(this.leftGlyph);
            coder.writeShort(this.rightGlyph);
        } else {
            coder.writeByte(this.leftGlyph);
            coder.writeByte(this.rightGlyph);
        }
        coder.writeShort(this.adjustment);
    }
}

