/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.MorphLineStyle2;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.shape.ShapeTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineMorphShape2
implements ShapeTag {
    private static final int EXTENDED = 255;
    private static final int EXTENDED_LENGTH = 3;
    private static final String FORMAT = "DefineMorphShape2: { identifier=%d; startShapeBounds=%s; endShapeBounds=%s; startEdgeBounds=%s; endEdgeBounds=%s; fillStyles=%s; lineStyles=%s; startShape=%s; endShape=%s}";
    private int identifier;
    private Bounds bounds;
    private Bounds endBounds;
    private Bounds edgeBounds;
    private Bounds endEdgeBounds;
    private List<FillStyle> fillStyles;
    private List<LineStyle> lineStyles;
    private Shape shape;
    private Shape endShape;
    private transient int length;
    private transient int fillBits;
    private transient int lineBits;
    private transient boolean scaling;
    private transient int offset;

    public DefineMorphShape2(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        context.put(3, 1);
        context.put(8, 1);
        context.put(2, 46);
        this.bounds = new Bounds(coder);
        this.endBounds = new Bounds(coder);
        this.edgeBounds = new Bounds(coder);
        this.endEdgeBounds = new Bounds(coder);
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle>();
        coder.readByte();
        int offsetToEnd = coder.readInt();
        coder.mark();
        int fillStyleCount = coder.readByte();
        if (context.contains(8) && fillStyleCount == 255) {
            fillStyleCount = coder.readUnsignedShort();
        }
        SWFFactory<FillStyle> decoder = context.getRegistry().getMorphFillStyleDecoder();
        for (int i = 0; i < fillStyleCount; ++i) {
            decoder.getObject(this.fillStyles, coder, context);
        }
        int lineStyleCount = coder.readByte();
        if (context.contains(8) && lineStyleCount == 255) {
            lineStyleCount = coder.readUnsignedShort();
        }
        for (int i = 0; i < lineStyleCount; ++i) {
            this.lineStyles.add(new MorphLineStyle2(coder, context));
        }
        if (context.getRegistry().getShapeDecoder() == null) {
            int size = offsetToEnd - coder.bytesRead();
            coder.unmark();
            this.shape = new Shape();
            this.shape.add(new ShapeData(size, coder));
            size = this.length - coder.bytesRead();
            coder.unmark();
            this.endShape = new Shape();
            this.endShape.add(new ShapeData(size, coder));
        } else {
            this.shape = new Shape(coder, context);
            this.endShape = new Shape(coder, context);
            coder.unmark();
            coder.unmark();
        }
        context.remove(3);
        context.remove(8);
        context.remove(2);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineMorphShape2(int uid, Bounds startRect, Bounds endRect, List<FillStyle> fills, List<LineStyle> lines, Shape initialShape, Shape finalShape) {
        this.setIdentifier(uid);
        this.setBounds(startRect);
        this.setEndBounds(endRect);
        this.setFillStyles(fills);
        this.setLineStyles(lines);
        this.setShape(initialShape);
        this.setEndShape(finalShape);
    }

    public DefineMorphShape2(DefineMorphShape2 object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.endBounds = object.endBounds;
        this.edgeBounds = object.edgeBounds;
        this.endEdgeBounds = object.endEdgeBounds;
        this.fillStyles = new ArrayList<FillStyle>(object.fillStyles.size());
        for (FillStyle fillStyle : object.fillStyles) {
            this.fillStyles.add((FillStyle)fillStyle.copy());
        }
        this.lineStyles = new ArrayList<LineStyle>(object.lineStyles.size());
        for (LineStyle lineStyle : object.lineStyles) {
            this.lineStyles.add((LineStyle)lineStyle.copy());
        }
        this.shape = object.shape.copy();
        this.endShape = object.endShape.copy();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public DefineMorphShape2 add(LineStyle style) {
        if (!(style instanceof MorphLineStyle2)) {
            throw new IllegalArgumentException();
        }
        this.lineStyles.add(style);
        return this;
    }

    @Override
    public DefineMorphShape2 add(FillStyle aFillStyle) {
        this.fillStyles.add(aFillStyle);
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    public Bounds getEndBounds() {
        return this.endBounds;
    }

    public Bounds getEdgeBounds() {
        return this.edgeBounds;
    }

    public Bounds getEndEdgeBounds() {
        return this.endEdgeBounds;
    }

    @Override
    public List<FillStyle> getFillStyles() {
        return this.fillStyles;
    }

    @Override
    public List<LineStyle> getLineStyles() {
        return this.lineStyles;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public Shape getEndShape() {
        return this.endShape;
    }

    @Override
    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    public void setEndBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.endBounds = rect;
    }

    public void setEdgeBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.edgeBounds = rect;
    }

    public void setEndEdgeBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.endEdgeBounds = rect;
    }

    @Override
    public void setFillStyles(List<FillStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles = list;
    }

    @Override
    public void setLineStyles(List<LineStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles = list;
    }

    @Override
    public void setShape(Shape aShape) {
        if (aShape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = aShape;
    }

    public void setEndShape(Shape aShape) {
        if (aShape == null) {
            throw new IllegalArgumentException();
        }
        this.endShape = aShape;
    }

    @Override
    public DefineMorphShape2 copy() {
        return new DefineMorphShape2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds, this.endBounds, this.edgeBounds, this.endEdgeBounds, this.fillStyles, this.lineStyles, this.shape, this.endShape);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.fillBits = Coder.unsignedSize(this.fillStyles.size());
        this.lineBits = Coder.unsignedSize(this.lineStyles.size());
        if (context.contains(9)) {
            if (this.fillBits == 0) {
                this.fillBits = 1;
            }
            if (this.lineBits == 0) {
                this.lineBits = 1;
            }
        }
        context.put(3, 1);
        this.length = 7;
        this.length += this.bounds.prepareToEncode(context);
        this.length += this.endBounds.prepareToEncode(context);
        this.length += this.edgeBounds.prepareToEncode(context);
        this.length += this.endEdgeBounds.prepareToEncode(context);
        this.offset = this.length;
        this.length += this.fillStyles.size() >= 255 ? 3 : 1;
        for (FillStyle fillStyle : this.fillStyles) {
            this.length += fillStyle.prepareToEncode(context);
        }
        context.put(10, 0);
        this.length += this.lineStyles.size() >= 255 ? 3 : 1;
        for (LineStyle lineStyle : this.lineStyles) {
            this.length += lineStyle.prepareToEncode(context);
        }
        this.scaling = context.contains(10);
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.length += this.shape.prepareToEncode(context);
        this.offset = this.length - this.offset;
        context.put(11, 0);
        context.put(12, 0);
        this.length += this.endShape.prepareToEncode(context);
        context.remove(8);
        context.remove(3);
        context.remove(10);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5439);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1500 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        context.put(3, 1);
        this.bounds.encode(coder, context);
        this.endBounds.encode(coder, context);
        this.edgeBounds.encode(coder, context);
        this.endEdgeBounds.encode(coder, context);
        coder.writeByte(this.scaling ? 1 : 2);
        coder.writeInt(this.offset);
        if (this.fillStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.fillStyles.size());
        } else {
            coder.writeByte(this.fillStyles.size());
        }
        for (FillStyle fillStyle : this.fillStyles) {
            fillStyle.encode(coder, context);
        }
        if (this.lineStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.lineStyles.size());
        } else {
            coder.writeByte(this.lineStyles.size());
        }
        for (LineStyle lineStyle : this.lineStyles) {
            lineStyle.encode(coder, context);
        }
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.shape.encode(coder, context);
        context.put(11, 0);
        context.put(12, 0);
        this.endShape.encode(coder, context);
        context.remove(8);
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }
}

