/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle2;
import com.flagstone.transform.shape.ShapeRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ShapeStyle2
implements ShapeRecord {
    private static final String FORMAT = "ShapeStyle2: { move=(%d, %d); fill=%d; alt=%d; line=%d; fillStyles=%s; lineStyles=%s}";
    private static final int EXTENDED = 255;
    private Integer moveX;
    private Integer moveY;
    private Integer fillStyle;
    private Integer altFillStyle;
    private Integer lineStyle;
    private List<FillStyle> fillStyles;
    private List<LineStyle2> lineStyles;
    private transient boolean hasStyles;
    private transient boolean hasLine;
    private transient boolean hasAlt;
    private transient boolean hasFill;
    private transient boolean hasMove;

    public ShapeStyle2(int flags, SWFDecoder coder, Context context) throws IOException {
        int numberOfFillBits = context.get(11);
        int numberOfLineBits = context.get(12);
        this.hasStyles = (flags & 0x10) != 0;
        this.hasLine = (flags & 8) != 0;
        this.hasAlt = (flags & 4) != 0;
        this.hasFill = (flags & 2) != 0;
        boolean bl = this.hasMove = (flags & 1) != 0;
        if (this.hasMove) {
            int moveFieldSize = coder.readBits(5, false);
            this.moveX = coder.readBits(moveFieldSize, true);
            this.moveY = coder.readBits(moveFieldSize, true);
        }
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle2>();
        if (this.hasFill) {
            this.fillStyle = coder.readBits(numberOfFillBits, false);
        }
        if (this.hasAlt) {
            this.altFillStyle = coder.readBits(numberOfFillBits, false);
        }
        if (this.hasLine) {
            this.lineStyle = coder.readBits(numberOfLineBits, false);
        }
        if (this.hasStyles) {
            coder.alignToByte();
            int fillStyleCount = coder.readByte();
            if (context.contains(8) && fillStyleCount == 255) {
                fillStyleCount = coder.readUnsignedShort();
            }
            SWFFactory<FillStyle> decoder = context.getRegistry().getFillStyleDecoder();
            for (int i = 0; i < fillStyleCount; ++i) {
                decoder.getObject(this.fillStyles, coder, context);
            }
            int lineStyleCount = coder.readByte();
            if (context.contains(8) && lineStyleCount == 255) {
                lineStyleCount = coder.readUnsignedShort();
            }
            for (int i = 0; i < lineStyleCount; ++i) {
                this.lineStyles.add(new LineStyle2(coder, context));
            }
            int sizes = coder.readByte();
            numberOfFillBits = (sizes & 0xF0) >> 4;
            numberOfLineBits = sizes & 0xF;
            context.put(11, numberOfFillBits);
            context.put(12, numberOfLineBits);
        }
    }

    public ShapeStyle2() {
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle2>();
    }

    public ShapeStyle2(ShapeStyle2 object) {
        this.moveX = object.moveX;
        this.moveY = object.moveY;
        this.lineStyle = object.lineStyle;
        this.fillStyle = object.fillStyle;
        this.altFillStyle = object.altFillStyle;
        this.lineStyles = new ArrayList<LineStyle2>(object.lineStyles.size());
        for (LineStyle2 lineStyle2 : object.lineStyles) {
            this.lineStyles.add(lineStyle2.copy());
        }
        this.fillStyles = new ArrayList<FillStyle>(object.fillStyles.size());
        for (FillStyle fillStyle : object.fillStyles) {
            this.fillStyles.add((FillStyle)fillStyle.copy());
        }
    }

    public ShapeStyle2 add(LineStyle2 style) {
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles.add(style);
        return this;
    }

    public ShapeStyle2 add(FillStyle style) {
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles.add(style);
        return this;
    }

    public Integer getMoveX() {
        return this.moveX;
    }

    public Integer getMoveY() {
        return this.moveY;
    }

    public Integer getLineStyle() {
        return this.lineStyle;
    }

    public Integer getFillStyle() {
        return this.fillStyle;
    }

    public Integer getAltFillStyle() {
        return this.altFillStyle;
    }

    public List<LineStyle2> getLineStyles() {
        return this.lineStyles;
    }

    public List<FillStyle> getFillStyles() {
        return this.fillStyles;
    }

    public ShapeStyle2 setMoveX(Integer coord) {
        if (coord != null && (coord < -65536 || coord > 65535)) {
            throw new IllegalArgumentRangeException(-65536, 65535, coord);
        }
        this.moveX = coord;
        return this;
    }

    public ShapeStyle2 setMoveY(Integer coord) {
        if (coord != null && (coord < -65536 || coord > 65535)) {
            throw new IllegalArgumentRangeException(-65536, 65535, coord);
        }
        this.moveY = coord;
        return this;
    }

    public ShapeStyle2 setMove(Integer xCoord, Integer yCoord) {
        if (xCoord == null && yCoord != null || xCoord != null && yCoord == null) {
            throw new IllegalArgumentException();
        }
        if (xCoord != null && (xCoord < -65536 || xCoord > 65535)) {
            throw new IllegalArgumentRangeException(-65536, 65535, xCoord);
        }
        if (yCoord != null && (yCoord < -65536 || yCoord > 65535)) {
            throw new IllegalArgumentRangeException(-65536, 65535, yCoord);
        }
        this.moveX = xCoord;
        this.moveY = yCoord;
        return this;
    }

    public ShapeStyle2 setFillStyle(Integer anIndex) {
        this.fillStyle = anIndex;
        return this;
    }

    public ShapeStyle2 setAltFillStyle(Integer anIndex) {
        this.altFillStyle = anIndex;
        return this;
    }

    public ShapeStyle2 setLineStyle(Integer anIndex) {
        this.lineStyle = anIndex;
        return this;
    }

    public ShapeStyle2 setLineStyles(List<LineStyle2> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles = list;
        return this;
    }

    public ShapeStyle2 setFillStyles(List<FillStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles = list;
        return this;
    }

    @Override
    public ShapeStyle2 copy() {
        return new ShapeStyle2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.moveX, this.moveY, this.fillStyle, this.altFillStyle, this.lineStyle, this.fillStyles, this.lineStyles);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.hasLine = this.lineStyle != null;
        this.hasFill = this.fillStyle != null;
        this.hasAlt = this.altFillStyle != null;
        this.hasMove = this.moveX != null && this.moveY != null;
        this.hasStyles = !this.lineStyles.isEmpty() || !this.fillStyles.isEmpty();
        int numberOfBits = 6;
        if (this.hasMove) {
            int fieldSize = Math.max(Coder.size(this.moveX), Coder.size(this.moveY));
            numberOfBits += 5 + fieldSize * 2;
        }
        numberOfBits += this.hasFill ? context.get(11) : 0;
        numberOfBits += this.hasAlt ? context.get(11) : 0;
        context.put(15, context.get(15) + (numberOfBits += this.hasLine ? context.get(12) : 0));
        if (this.hasStyles) {
            int numberOfFillBits = Coder.unsignedSize(this.fillStyles.size());
            int numberOfLineBits = Coder.unsignedSize(this.lineStyles.size());
            if (numberOfFillBits == 0 && context.contains(9)) {
                numberOfFillBits = 1;
            }
            if (numberOfLineBits == 0 && context.contains(9)) {
                numberOfLineBits = 1;
            }
            boolean countExtended = context.contains(8);
            int numberOfStyleBits = 0;
            int flushBits = context.get(15);
            numberOfStyleBits += flushBits % 8 > 0 ? 8 - flushBits % 8 : 0;
            numberOfStyleBits += countExtended && this.fillStyles.size() >= 255 ? 24 : 8;
            for (FillStyle fillStyle : this.fillStyles) {
                numberOfStyleBits += fillStyle.prepareToEncode(context) * 8;
            }
            numberOfStyleBits += countExtended && this.lineStyles.size() >= 255 ? 24 : 8;
            for (LineStyle2 lineStyle2 : this.lineStyles) {
                numberOfStyleBits += lineStyle2.prepareToEncode(context) * 8;
            }
            context.put(11, numberOfFillBits);
            context.put(12, numberOfLineBits);
            context.put(15, context.get(15) + (numberOfStyleBits += 8));
            numberOfBits += numberOfStyleBits;
        }
        return numberOfBits;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(0, 1);
        coder.writeBits(this.hasStyles ? 1 : 0, 1);
        coder.writeBits(this.hasLine ? 1 : 0, 1);
        coder.writeBits(this.hasAlt ? 1 : 0, 1);
        coder.writeBits(this.hasFill ? 1 : 0, 1);
        coder.writeBits(this.hasMove ? 1 : 0, 1);
        if (this.hasMove) {
            int fieldSize = Math.max(Coder.size(this.moveX), Coder.size(this.moveY));
            coder.writeBits(fieldSize, 5);
            coder.writeBits(this.moveX, fieldSize);
            coder.writeBits(this.moveY, fieldSize);
        }
        if (this.hasFill) {
            coder.writeBits(this.fillStyle, context.get(11));
        }
        if (this.hasAlt) {
            coder.writeBits(this.altFillStyle, context.get(11));
        }
        if (this.hasLine) {
            coder.writeBits(this.lineStyle, context.get(12));
        }
        if (this.hasStyles) {
            int n;
            boolean countExtended = context.contains(8);
            coder.alignToByte();
            if (countExtended && this.fillStyles.size() >= 255) {
                coder.writeByte(255);
                coder.writeShort(this.fillStyles.size());
            } else {
                coder.writeByte(this.fillStyles.size());
            }
            for (FillStyle fillStyle : this.fillStyles) {
                fillStyle.encode(coder, context);
            }
            if (countExtended && this.lineStyles.size() >= 255) {
                coder.writeByte(255);
                coder.writeShort(this.lineStyles.size());
            } else {
                coder.writeByte(this.lineStyles.size());
            }
            for (LineStyle2 lineStyle2 : this.lineStyles) {
                lineStyle2.encode(coder, context);
            }
            int numberOfFillBits = Coder.unsignedSize(this.fillStyles.size());
            int n2 = Coder.unsignedSize(this.lineStyles.size());
            if (context.contains(9)) {
                if (numberOfFillBits == 0) {
                    numberOfFillBits = 1;
                }
                if (n2 == 0) {
                    n = 1;
                }
            }
            coder.writeByte(numberOfFillBits << 4 | n);
            context.put(11, numberOfFillBits);
            context.put(12, n);
        }
    }
}

