/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import java.util.LinkedHashMap;
import java.util.Map;

public enum SoundFormat {
    NATIVE_PCM(0),
    ADPCM(1),
    MP3(2),
    PCM(3),
    NELLYMOSER_8K(5),
    NELLYMOSER(6),
    SPEEX(11);

    private static final Map<Integer, SoundFormat> TABLE;
    private int value;

    public static SoundFormat fromInt(int value) {
        return TABLE.get(value);
    }

    private SoundFormat(int format) {
        this.value = format;
    }

    public int getValue() {
        return this.value;
    }

    static {
        TABLE = new LinkedHashMap<Integer, SoundFormat>();
        for (SoundFormat type : SoundFormat.values()) {
            TABLE.put(type.value, type);
        }
    }
}

