/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.coder.LittleDecoder;
import com.flagstone.transform.image.DefineImage;
import com.flagstone.transform.image.DefineImage2;
import com.flagstone.transform.image.ImageFormat;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageFilter;
import com.flagstone.transform.util.image.ImageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;

public final class BMPDecoder
implements ImageProvider,
ImageDecoder {
    private static final int OPAQUE = 255;
    private static final String BAD_FORMAT = "Unsupported Format";
    private static final int[] SIGNATURE = new int[]{66, 77};
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    private static final int UNZIPPED_LENGTH = 12;
    private static final int ZIPPED_LENGTH = 40;
    private static final int COLOUR_CHANNELS = 4;
    private static final int IDX_1 = 1;
    private static final int IDX_2 = 2;
    private static final int IDX_4 = 4;
    private static final int IDX_8 = 8;
    private static final int RGB5_SIZE = 16;
    private static final int RGB8_SIZE = 24;
    private static final int RGBA_SIZE = 32;
    private static final int RGB5_DEPTH = 5;
    private static final int RGB8_DEPTH = 8;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int R5_MASK = 31744;
    private static final int G5_MASK = 992;
    private static final int B5_MASK = 31;
    private static final int R5_SHIFT = 7;
    private static final int G5_SHIFT = 2;
    private static final int B5_SHIFT = 3;
    private static final int R6_MASK = 31744;
    private static final int G6_MASK = 992;
    private static final int B6_MASK = 31;
    private static final int R6_SHIFT = 8;
    private static final int G6_SHIFT = 3;
    private static final int B6_SHIFT = 3;
    private transient ImageFormat format;
    private transient int width;
    private transient int height;
    private transient byte[] table;
    private transient byte[] image;
    private transient int bitDepth;
    private transient int compressionMethod;
    private transient int redMask;
    private transient int redShift;
    private transient int greenMask;
    private transient int greenShift;
    private transient int blueMask;
    private transient int blueShift;
    private transient int bitsPerPixel;
    private transient int coloursUsed;

    @Override
    public void read(File file) throws IOException, DataFormatException {
        this.read(new FileInputStream(file));
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        if (!connection.getContentType().equals("image/bmp")) {
            throw new DataFormatException(BAD_FORMAT);
        }
        int length = connection.getContentLength();
        if (length < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.read(url.openStream());
    }

    @Override
    public ImageTag defineImage(int identifier) {
        ImageTag object = null;
        ImageFilter filter = new ImageFilter();
        switch (this.format) {
            case IDX8: {
                object = new DefineImage(identifier, this.width, this.height, this.table.length / 4, this.zip(filter.merge(filter.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case IDXA: {
                object = new DefineImage2(identifier, this.width, this.height, this.table.length / 4, this.zip(filter.mergeAlpha(filter.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case RGB5: {
                object = new DefineImage(identifier, this.width, this.height, this.zip(filter.packColors(this.width, this.height, this.image)), 16);
                break;
            }
            case RGB8: {
                filter.orderAlpha(this.image);
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.image), 24);
                break;
            }
            case RGBA: {
                filter.applyAlpha(this.image);
                object = new DefineImage2(identifier, this.width, this.height, this.zip(this.image));
                break;
            }
            default: {
                throw new AssertionError((Object)BAD_FORMAT);
            }
        }
        return object;
    }

    @Override
    public ImageDecoder newDecoder() {
        return new BMPDecoder();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public byte[] getImage() {
        byte[] copy;
        switch (this.format) {
            case IDX8: 
            case IDXA: {
                copy = new byte[this.image.length * 4];
                int index = 0;
                for (int i = 0; i < this.image.length; ++i) {
                    int tableIndex = this.image[i] * 4;
                    copy[index++] = this.table[tableIndex + 0];
                    copy[index++] = this.table[tableIndex + 1];
                    copy[index++] = this.table[tableIndex + 2];
                    copy[index++] = this.table[tableIndex + 3];
                }
                break;
            }
            case RGB5: 
            case RGB8: 
            case RGBA: {
                copy = Arrays.copyOf(this.image, this.image.length);
                break;
            }
            default: {
                throw new AssertionError((Object)BAD_FORMAT);
            }
        }
        return copy;
    }

    @Override
    public void read(InputStream stream) throws DataFormatException, IOException {
        LittleDecoder coder = new LittleDecoder(stream);
        coder.mark();
        for (int i = 0; i < 2; ++i) {
            if (coder.readByte() == SIGNATURE[i]) continue;
            throw new DataFormatException(BAD_FORMAT);
        }
        coder.readInt();
        coder.readInt();
        int offset = coder.readInt();
        int headerSize = coder.readInt();
        if (headerSize == 40) {
            this.decodeCompressedHeader(coder);
        } else {
            this.decodeHeader(coder);
        }
        this.decodeFormat(this.bitsPerPixel);
        if (this.format == ImageFormat.IDX8) {
            this.coloursUsed = 1 << this.bitsPerPixel;
            if (headerSize == 12) {
                this.decodeTable(this.coloursUsed, coder);
            } else {
                this.decodeTableWithAlpha(this.coloursUsed, coder);
            }
            coder.skip(offset - coder.bytesRead());
            this.decodeIndexedImage(coder);
        } else {
            coder.skip(offset - coder.bytesRead());
            this.decodeColourImage(coder);
        }
    }

    private void decodeHeader(LittleDecoder coder) throws IOException {
        this.width = coder.readUnsignedShort();
        this.height = coder.readUnsignedShort();
        coder.readUnsignedShort();
        this.bitsPerPixel = coder.readUnsignedShort();
        this.coloursUsed = 0;
    }

    private void decodeCompressedHeader(LittleDecoder coder) throws IOException {
        this.width = coder.readInt();
        this.height = coder.readInt();
        coder.readUnsignedShort();
        this.bitsPerPixel = coder.readUnsignedShort();
        this.compressionMethod = coder.readInt();
        coder.readInt();
        coder.readInt();
        coder.readInt();
        this.coloursUsed = coder.readInt();
        coder.readInt();
        if (this.compressionMethod == 3) {
            this.decodeMasks(coder);
        }
    }

    private void decodeMasks(LittleDecoder coder) throws IOException {
        this.redMask = coder.readInt();
        this.greenMask = coder.readInt();
        this.blueMask = coder.readInt();
        if (this.redMask == 31744) {
            this.redShift = 7;
        } else if (this.redMask == 31744) {
            this.redShift = 8;
        }
        if (this.greenMask == 992) {
            this.greenShift = 2;
        } else if (this.greenMask == 992) {
            this.greenShift = 3;
        }
        if (this.blueMask == 31) {
            this.blueShift = 3;
        } else if (this.blueMask == 31) {
            this.blueShift = 3;
        }
    }

    private void decodeFormat(int pixelSize) throws DataFormatException {
        switch (pixelSize) {
            case 1: {
                this.format = ImageFormat.IDX8;
                this.bitDepth = pixelSize;
                break;
            }
            case 2: {
                this.format = ImageFormat.IDX8;
                this.bitDepth = pixelSize;
                break;
            }
            case 4: {
                this.format = ImageFormat.IDX8;
                this.bitDepth = pixelSize;
                break;
            }
            case 8: {
                this.format = ImageFormat.IDX8;
                this.bitDepth = pixelSize;
                break;
            }
            case 16: {
                this.format = ImageFormat.RGB5;
                this.bitDepth = 5;
                break;
            }
            case 24: {
                this.format = ImageFormat.RGB8;
                this.bitDepth = 8;
                break;
            }
            case 32: {
                this.format = ImageFormat.RGBA;
                this.bitDepth = 8;
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeTable(int numColours, LittleDecoder coder) throws IOException {
        int index = 0;
        this.table = new byte[numColours * 4];
        for (int i = 0; i < numColours; ++i) {
            this.table[index + 3] = -1;
            this.table[index + 2] = (byte)coder.readByte();
            this.table[index + 1] = (byte)coder.readByte();
            this.table[index + 0] = (byte)coder.readByte();
            index += 4;
        }
    }

    private void decodeTableWithAlpha(int numColours, LittleDecoder coder) throws IOException {
        int index = 0;
        this.table = new byte[numColours * 4];
        for (int i = 0; i < numColours; ++i) {
            this.table[index + 0] = (byte)coder.readByte();
            this.table[index + 1] = (byte)coder.readByte();
            this.table[index + 2] = (byte)coder.readByte();
            this.table[index + 3] = (byte)coder.readByte();
            index += 4;
        }
    }

    private void decodeIndexedImage(LittleDecoder coder) throws IOException, DataFormatException {
        this.image = new byte[this.height * this.width];
        switch (this.compressionMethod) {
            case 0: {
                this.decodeIDX8(coder);
                break;
            }
            case 1: {
                this.decodeRLE8(coder);
                break;
            }
            case 2: {
                this.decodeRLE4(coder);
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeColourImage(LittleDecoder coder) throws IOException, DataFormatException {
        this.image = new byte[this.height * this.width * 4];
        switch (this.format) {
            case RGB5: {
                this.decodeRGB5(coder);
                break;
            }
            case RGB8: {
                this.decodeRGB8(coder);
                break;
            }
            case RGBA: {
                this.decodeRGBA(coder);
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeIDX8(LittleDecoder coder) throws IOException {
        int index = 0;
        for (int row = this.height - 1; row > 0; --row) {
            int bitsRead = 0;
            index = row * this.width;
            for (int col = 0; col < this.width; ++col) {
                this.image[index++] = (byte)coder.readBits(this.bitDepth, false);
                bitsRead += this.bitDepth;
            }
            if (bitsRead % 32 <= 0) continue;
            coder.readBits(32 - bitsRead % 32, false);
        }
    }

    private void decodeRLE4(LittleDecoder coder) throws IOException {
        int row = this.height - 1;
        int col = 0;
        int index = 0;
        boolean hasMore = true;
        block5: while (hasMore) {
            int count = coder.readByte();
            if (count == 0) {
                int code = coder.readByte();
                switch (code) {
                    case 0: {
                        col = 0;
                        --row;
                        continue block5;
                    }
                    case 1: {
                        hasMore = false;
                        continue block5;
                    }
                    case 2: {
                        this.decodeRLE4Pixels(code, coder, row -= coder.readUnsignedShort(), col += coder.readUnsignedShort());
                        continue block5;
                    }
                }
                this.decodeRLE4Pixels(code, coder, row, col);
                continue;
            }
            int value = coder.readByte();
            byte indexA = (byte)(value >>> 4);
            byte indexB = (byte)(value & 0xF);
            index = row * this.width + col;
            for (int i = 0; i < count && col < this.width; ++i, ++col) {
                this.image[index++] = i % 2 > 0 ? indexB : indexA;
            }
        }
    }

    private void decodeRLE4Pixels(int code, LittleDecoder coder, int row, int col) throws IOException {
        int index = row * this.width + col;
        for (int i = 0; i < code; i += 2) {
            int value = coder.readByte();
            this.image[index++] = (byte)(value >>> 4);
            this.image[index++] = (byte)(value & 0xF);
        }
        if ((code & 2) == 2) {
            coder.readByte();
        }
    }

    private void decodeRLE8(LittleDecoder coder) throws IOException {
        int row = this.height - 1;
        int col = 0;
        boolean hasMore = true;
        block5: while (hasMore) {
            int count = coder.readByte();
            if (count == 0) {
                int code = coder.readByte();
                switch (code) {
                    case 0: {
                        col = 0;
                        --row;
                        continue block5;
                    }
                    case 1: {
                        hasMore = false;
                        continue block5;
                    }
                    case 2: {
                        this.decodeRLE8Pixels(code, coder, row -= coder.readUnsignedShort(), col += coder.readUnsignedShort());
                        continue block5;
                    }
                }
                this.decodeRLE8Pixels(code, coder, row, col);
                continue;
            }
            this.decodeRLE8Run(count, row, col, (byte)coder.readByte());
        }
    }

    private void decodeRLE8Pixels(int code, LittleDecoder coder, int row, int col) throws IOException {
        int index = row * this.width + col;
        for (int i = 0; i < code; ++i) {
            this.image[index++] = (byte)coder.readByte();
        }
        if ((code & 1) == 1) {
            coder.readByte();
        }
    }

    private void decodeRLE8Run(int count, int row, int col, byte value) {
        int index = row * this.width + col;
        for (int i = 0; i < count; ++i) {
            this.image[index++] = value;
        }
    }

    private void decodeRGB5(LittleDecoder coder) throws IOException {
        int index = 0;
        for (int row = this.height - 1; row > 0; --row) {
            coder.mark();
            for (int col = 0; col < this.width; ++col) {
                int colour = coder.readUnsignedShort();
                this.image[index + 0] = (byte)((colour & this.redMask) >> this.redShift);
                this.image[index + 1] = (byte)((colour & this.greenMask) >> this.greenShift);
                this.image[index + 2] = (byte)((colour & this.blueMask) << this.blueShift);
                this.image[index + 3] = -1;
                index += 4;
            }
            coder.alignToWord();
            coder.unmark();
        }
    }

    private void decodeRGB8(LittleDecoder coder) throws IOException {
        int index = 0;
        for (int row = this.height - 1; row > 0; --row) {
            int bytesRead = 0;
            for (int col = 0; col < this.width; ++col) {
                this.image[index + 0] = (byte)coder.readByte();
                this.image[index + 1] = (byte)coder.readByte();
                this.image[index + 2] = (byte)coder.readByte();
                this.image[index + 3] = -1;
                index += 4;
                bytesRead += 3;
            }
            if (bytesRead % 4 <= 0) continue;
            coder.readBytes(new byte[4 - bytesRead % 4]);
        }
    }

    private void decodeRGBA(LittleDecoder coder) throws IOException {
        int index = 0;
        for (int row = this.height - 1; row > 0; --row) {
            for (int col = 0; col < this.width; ++col) {
                this.image[index + 2] = (byte)coder.readByte();
                this.image[index + 1] = (byte)coder.readByte();
                this.image[index + 0] = (byte)coder.readByte();
                this.image[index + 3] = (byte)coder.readByte();
                this.image[index + 3] = -1;
                index += 4;
            }
        }
    }

    private byte[] zip(byte[] img) {
        Deflater deflater = new Deflater();
        deflater.setInput(img);
        deflater.finish();
        byte[] compressedData = new byte[img.length * 2];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = Arrays.copyOf(compressedData, bytesCompressed);
        return newData;
    }
}

