/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.coder.LittleDecoder;
import com.flagstone.transform.image.DefineImage;
import com.flagstone.transform.image.DefineImage2;
import com.flagstone.transform.image.ImageFormat;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageProvider;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import javax.imageio.ImageIO;

public final class BufferedImageDecoder
implements ImageProvider,
ImageDecoder {
    private static final String BAD_FORMAT = "Unsupported format";
    private static final int BYTES_PER_PIXEL = 4;
    private static final int OPAQUE = -1;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int MASK_8BIT = 255;
    private static final int ALIGN_BYTE2 = 8;
    private static final int ALIGN_BYTE3 = 16;
    private static final int ALIGN_BYTE4 = 24;
    private static final int WORD_ALIGN = 3;
    private static final int COLOUR_CHANNELS = 4;
    private static final int RGB_CHANNELS = 3;
    private static final int RGB5_SIZE = 16;
    private static final int RGB8_SIZE = 24;
    private static final int RGB5_MSB_MASK = 248;
    private static final int RGB5_RED_SHIFT = 7;
    private static final int RGB5_GREEN_SHIFT = 2;
    private static final int RGB5_BLUE_SHIFT = 3;
    private transient ImageFormat format;
    private transient int width;
    private transient int height;
    private transient byte[] table;
    private transient byte[] image;

    @Override
    public ImageDecoder newDecoder() {
        return new BufferedImageDecoder();
    }

    @Override
    public void read(File file) throws IOException, DataFormatException {
        this.read(new FileInputStream(file));
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.read(url.openStream());
    }

    @Override
    public void read(InputStream stream) throws IOException, DataFormatException {
        this.read(ImageIO.read(stream));
    }

    @Override
    public ImageTag defineImage(int identifier) {
        ImageTag object = null;
        switch (this.format) {
            case IDX8: {
                object = new DefineImage(identifier, this.width, this.height, this.table.length / 4, this.zip(this.merge(this.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case IDXA: {
                object = new DefineImage2(identifier, this.width, this.height, this.table.length / 4, this.zip(this.mergeAlpha(this.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case RGB5: {
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.packColours(this.width, this.height, this.image)), 16);
                break;
            }
            case RGB8: {
                this.orderAlpha(this.image);
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.image), 24);
                break;
            }
            case RGBA: {
                this.applyAlpha(this.image);
                object = new DefineImage2(identifier, this.width, this.height, this.zip(this.image));
                break;
            }
            default: {
                throw new AssertionError((Object)BAD_FORMAT);
            }
        }
        return object;
    }

    public ImageTag defineImage(int identifier, BufferedImage obj) throws IOException, DataFormatException {
        ImageTag object = null;
        BufferedImageDecoder decoder = new BufferedImageDecoder();
        decoder.read(obj);
        switch (this.format) {
            case IDX8: {
                object = new DefineImage(identifier, this.width, this.height, this.table.length, this.zip(this.merge(this.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case IDXA: {
                object = new DefineImage2(identifier, this.width, this.height, this.table.length, this.zip(this.mergeAlpha(this.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case RGB5: {
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.packColours(this.width, this.height, this.image)), 16);
                break;
            }
            case RGB8: {
                this.orderAlpha(this.image);
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.image), 24);
                break;
            }
            case RGBA: {
                this.applyAlpha(this.image);
                object = new DefineImage2(identifier, this.width, this.height, this.zip(this.image));
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
        return object;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }

    public void read(BufferedImage obj) throws IOException, DataFormatException {
        DataBuffer buffer = obj.getData().getDataBuffer();
        this.width = obj.getWidth();
        this.height = obj.getHeight();
        if (buffer.getDataType() == 3) {
            this.decodeIntImage(obj);
        } else if (buffer.getDataType() == 0) {
            this.decodeByteImage(obj);
        } else if (buffer.getDataType() == 1) {
            this.decodeShortImage(obj);
        } else {
            throw new DataFormatException(BAD_FORMAT);
        }
    }

    private void decodeIntImage(BufferedImage obj) throws DataFormatException {
        DataBuffer buffer = obj.getData().getDataBuffer();
        switch (obj.getType()) {
            case 2: {
                this.decodeARGB(buffer);
                break;
            }
            case 3: {
                this.decodeARGBPre(buffer);
                break;
            }
            case 4: {
                this.decodeBGR(buffer);
                break;
            }
            case 1: {
                this.decodeRGB(buffer);
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeARGB(DataBuffer buffer) {
        int[] pixels = ((DataBufferInt)buffer).getData();
        this.format = ImageFormat.RGBA;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int pixel = pixels[y * this.width + x];
                this.image[index + 3] = (byte)(pixel >> 24);
                this.image[index + 2] = (byte)(pixel >> 16);
                this.image[index + 1] = (byte)(pixel >> 8);
                this.image[index] = (byte)pixel;
                ++x;
                index += 4;
            }
        }
    }

    private void decodeARGBPre(DataBuffer buffer) {
        int[] pixels = ((DataBufferInt)buffer).getData();
        this.format = ImageFormat.RGBA;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int pixel = pixels[y * this.width + x];
                this.image[index + 3] = (byte)(pixel >> 24);
                this.image[index + 2] = (byte)(pixel >> 16);
                this.image[index + 1] = (byte)(pixel >> 8);
                this.image[index] = (byte)pixel;
                ++x;
                index += 4;
            }
        }
    }

    private void decodeBGR(DataBuffer buffer) {
        int[] pixels = ((DataBufferInt)buffer).getData();
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int pixel = pixels[y * this.width + x];
                this.image[index + 3] = -1;
                this.image[index + 2] = (byte)(pixel >> 16);
                this.image[index + 1] = (byte)(pixel >> 8);
                this.image[index] = (byte)pixel;
                ++x;
                index += 4;
            }
        }
    }

    private void decodeRGB(DataBuffer buffer) {
        int[] pixels = ((DataBufferInt)buffer).getData();
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int pixel = pixels[y * this.width + x];
                this.image[index + 3] = -1;
                this.image[index] = (byte)(pixel >> 16);
                this.image[index + 1] = (byte)(pixel >> 8);
                this.image[index + 2] = (byte)pixel;
                ++x;
                index += 4;
            }
        }
    }

    private void decodeByteImage(BufferedImage obj) throws IOException, DataFormatException {
        DataBuffer buffer = obj.getData().getDataBuffer();
        switch (obj.getType()) {
            case 5: {
                this.decodeByteBGR(buffer);
                break;
            }
            case 0: {
                this.decodeByteCustom(buffer);
                break;
            }
            case 6: {
                this.decodeByteABGR(buffer);
                break;
            }
            case 7: {
                this.decodeByteABGRPre(buffer);
                break;
            }
            case 12: {
                this.decodeByteBinary(buffer, obj.getColorModel());
                break;
            }
            case 10: {
                this.decodeByteGray(buffer);
                break;
            }
            case 13: {
                this.decodeByteIndexed(buffer, obj.getColorModel());
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeByteBGR(DataBuffer buffer) {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int offset = 3 * (y * this.width + x);
                this.image[index + 3] = -1;
                this.image[index + 2] = pixels[offset];
                this.image[index + 1] = pixels[offset + 1];
                this.image[index] = pixels[offset + 2];
                ++x;
                index += 4;
            }
        }
    }

    private void decodeByteCustom(DataBuffer buffer) throws DataFormatException {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        if (this.width * this.height * 3 == pixels.length) {
            this.format = ImageFormat.RGBA;
            this.image = new byte[this.height * this.width * 4];
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int offset = 3 * (y * this.width + x);
                    this.image[index] = pixels[offset];
                    this.image[index + 1] = pixels[offset + 1];
                    this.image[index + 2] = pixels[offset + 2];
                    this.image[index + 3] = -1;
                    index += 4;
                }
            }
        } else if (this.width * this.height * 4 == pixels.length) {
            this.format = ImageFormat.RGBA;
            this.image = new byte[this.height * this.width * 4];
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int offset = 4 * (y * this.width + x);
                    this.image[index] = pixels[offset];
                    this.image[index + 1] = pixels[offset + 1];
                    this.image[index + 2] = pixels[offset + 2];
                    this.image[index + 3] = pixels[offset + 3];
                    index += 4;
                }
            }
        } else {
            throw new DataFormatException(BAD_FORMAT);
        }
    }

    private void decodeByteABGR(DataBuffer buffer) {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.RGBA;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int offset = 4 * (y * this.width + x);
                this.image[index + 3] = pixels[offset];
                this.image[index + 2] = pixels[offset + 1];
                this.image[index + 1] = pixels[offset + 2];
                this.image[index] = pixels[offset + 3];
                ++x;
                index += 4;
            }
        }
    }

    private void decodeByteABGRPre(DataBuffer buffer) {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.RGBA;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int offset = 4 * (y * this.width + x);
                this.image[index + 3] = pixels[offset];
                this.image[index + 2] = pixels[offset + 1];
                this.image[index + 1] = pixels[offset + 2];
                this.image[index] = pixels[offset + 3];
                ++x;
                index += 4;
            }
        }
    }

    private void decodeByteBinary(DataBuffer buffer, ColorModel model) throws IOException {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.IDX8;
        this.image = new byte[this.height * this.width];
        int depth = model.getPixelSize();
        this.decodeColorTable(model);
        int index = 0;
        ByteArrayInputStream stream = new ByteArrayInputStream(pixels);
        LittleDecoder coder = new LittleDecoder(stream);
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                this.image[index] = (byte)coder.readBits(depth, false);
                ++x;
                ++index;
            }
        }
    }

    private void decodeByteGray(DataBuffer buffer) {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int offset = y * this.width + x;
                this.image[index + 3] = -1;
                this.image[index + 2] = pixels[offset];
                this.image[index + 1] = pixels[offset];
                this.image[index] = pixels[offset];
                index += 4;
            }
        }
    }

    private void decodeByteIndexed(DataBuffer buffer, ColorModel model) {
        byte[] pixels = ((DataBufferByte)buffer).getData();
        this.format = ImageFormat.IDX8;
        this.image = new byte[this.height * this.width];
        this.decodeColorTable(model);
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(pixels, y * this.width, this.image, index, this.width);
            index += this.width;
        }
    }

    private void decodeShortImage(BufferedImage obj) throws DataFormatException {
        DataBuffer buffer = obj.getData().getDataBuffer();
        switch (obj.getType()) {
            case 9: {
                throw new DataFormatException(BAD_FORMAT);
            }
            case 8: {
                throw new DataFormatException(BAD_FORMAT);
            }
            case 11: {
                this.decodeShortGray(buffer);
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
    }

    private void decodeShortGray(DataBuffer buffer) {
        short[] pixels = ((DataBufferUShort)buffer).getData();
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int offset = y * this.width + x;
                this.image[index + 3] = -1;
                this.image[index + 2] = (byte)pixels[offset];
                this.image[index + 1] = (byte)pixels[offset];
                this.image[index] = (byte)pixels[offset];
                index += 4;
            }
        }
    }

    private void decodeColorTable(ColorModel model) {
        if (model instanceof IndexColorModel) {
            IndexColorModel indexModel = (IndexColorModel)model;
            this.table = new byte[indexModel.getMapSize() * 4];
            byte[] reds = new byte[indexModel.getMapSize()];
            byte[] blues = new byte[indexModel.getMapSize()];
            byte[] greens = new byte[indexModel.getMapSize()];
            indexModel.getReds(reds);
            indexModel.getGreens(greens);
            indexModel.getBlues(blues);
            int index = 0;
            for (int i = 0; i < this.table.length; i += 4) {
                this.table[i + 0] = reds[index];
                this.table[i + 1] = greens[index];
                this.table[i + 2] = blues[index];
                this.table[i + 3] = -1;
                ++index;
            }
        }
    }

    private void orderAlpha(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            byte alpha = img[i + 3];
            img[i + 3] = img[i + 2];
            img[i + 2] = img[i + 1];
            img[i + 1] = img[i];
            img[i] = alpha;
        }
    }

    private void applyAlpha(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            int alpha = img[i + 3] & 0xFF;
            img[i + 3] = (byte)((img[i + 2] & 0xFF) * alpha / -1);
            img[i + 2] = (byte)((img[i + 1] & 0xFF) * alpha / -1);
            img[i + 1] = (byte)((img[i + 0] & 0xFF) * alpha / -1);
            img[i + 0] = (byte)alpha;
        }
    }

    private byte[] merge(byte[] img, byte[] colors) {
        byte[] merged = new byte[colors.length / 4 * 3 + img.length];
        int dst = 0;
        for (int i = 0; i < colors.length; i += 4) {
            merged[dst++] = colors[i + 0];
            merged[dst++] = colors[i + 1];
            merged[dst++] = colors[i + 2];
        }
        for (byte element : img) {
            merged[dst++] = element;
        }
        return merged;
    }

    private byte[] mergeAlpha(byte[] img, byte[] colors) {
        byte[] merged = new byte[colors.length + img.length];
        int dst = 0;
        for (byte element : colors) {
            merged[dst++] = element;
        }
        for (byte element : img) {
            merged[dst++] = element;
        }
        return merged;
    }

    private byte[] zip(byte[] img) {
        Deflater deflater = new Deflater();
        deflater.setInput(img);
        deflater.finish();
        byte[] compressedData = new byte[img.length * 2];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = Arrays.copyOf(compressedData, bytesCompressed);
        return newData;
    }

    private byte[] adjustScan(int imgWidth, int imgHeight, byte[] img) {
        int src = 0;
        int dst = 0;
        int scan = 0;
        byte[] formattedImage = null;
        scan = imgWidth + 3 & 0xFFFFFFFC;
        formattedImage = new byte[scan * imgHeight];
        for (int row = 0; row < imgHeight; ++row) {
            int col;
            for (col = 0; col < imgWidth; ++col) {
                formattedImage[dst++] = img[src++];
            }
            while (col++ < scan) {
                formattedImage[dst++] = 0;
            }
        }
        return formattedImage;
    }

    private byte[] packColours(int imgWidth, int imgHeight, byte[] img) {
        int src = 0;
        int dst = 0;
        int scan = imgWidth + (imgWidth & 1);
        byte[] formattedImage = new byte[scan * imgHeight * 2];
        for (int row = 0; row < imgHeight; ++row) {
            int col = 0;
            while (col < imgWidth) {
                int red = (img[src++] & 0xF8) << 7;
                int green = (img[src++] & 0xF8) << 2;
                int blue = (img[src++] & 0xF8) >> 3;
                int colour = (red | green | blue) & Short.MAX_VALUE;
                formattedImage[dst++] = (byte)(colour >> 8);
                formattedImage[dst++] = (byte)colour;
                ++col;
                ++src;
            }
            while (col < scan) {
                formattedImage[dst++] = 0;
                formattedImage[dst++] = 0;
                ++col;
            }
        }
        return formattedImage;
    }
}

