/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.movie;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.DoAction;
import com.flagstone.transform.FrameLabel;
import com.flagstone.transform.Movie;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.ShowFrame;
import com.flagstone.transform.action.Action;
import java.util.ArrayList;
import java.util.List;

public final class Frame {
    private String label;
    private int number;
    private List<MovieTag> definitions;
    private List<MovieTag> commands;
    private List<Action> actions;

    public static List<Frame> split(Movie aMovie) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        int index = 1;
        Frame currentFrame = new Frame();
        for (MovieTag currentObject : aMovie.getObjects()) {
            if (currentObject instanceof DoAction) {
                currentFrame.actions = ((DoAction)currentObject).getActions();
                continue;
            }
            if (currentObject instanceof FrameLabel) {
                currentFrame.label = ((FrameLabel)currentObject).getLabel();
                continue;
            }
            if (currentObject instanceof DefineTag) {
                currentFrame.addDefinition(currentObject);
                continue;
            }
            if (currentObject instanceof ShowFrame) {
                currentFrame.setNumber(index++);
                frames.add(currentFrame);
                currentFrame = new Frame();
                continue;
            }
            currentFrame.addCommand(currentObject);
        }
        return frames;
    }

    public Frame() {
        this.definitions = new ArrayList<MovieTag>();
        this.commands = new ArrayList<MovieTag>();
        this.actions = new ArrayList<Action>();
    }

    public Frame(int frame) {
        this.setNumber(frame);
        this.definitions = new ArrayList<MovieTag>();
        this.commands = new ArrayList<MovieTag>();
        this.actions = new ArrayList<Action>();
    }

    public void addAction(Action anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.actions.add(anObject);
    }

    public void addDefinition(MovieTag anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.definitions.add(anObject);
    }

    public void addCommand(MovieTag anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.commands.add(anObject);
    }

    public int getNumber() {
        return this.number;
    }

    public String getLabel() {
        return this.label;
    }

    public List<MovieTag> getDefinitions() {
        return this.definitions;
    }

    public List<MovieTag> getCommands() {
        return this.commands;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setNumber(int frameNumber) {
        this.number = frameNumber;
    }

    public void setLabel(String aString) {
        this.label = aString;
    }

    public void setDefinitions(List<MovieTag> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.definitions = list;
    }

    public void setCommands(List<MovieTag> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.commands = list;
    }

    public void setActions(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    public void addToMovie(Movie aMovie) {
        if (!this.definitions.isEmpty()) {
            for (MovieTag object : this.definitions) {
                aMovie.add(object);
            }
        }
        if (this.label.length() > 0) {
            aMovie.add(new FrameLabel(this.label));
        }
        if (!this.actions.isEmpty()) {
            aMovie.add(new DoAction(this.actions));
        }
        for (MovieTag object : this.commands) {
            aMovie.add(object);
        }
        aMovie.add(ShowFrame.getInstance());
    }
}

