/*
 * Decompiled with CFR 0.152.
 */
package flarestar.junit.composite.runner;

import flarestar.junit.composite.annotations.Runners;
import flarestar.junit.composite.runner.chain.RunnerChainFactory;
import flarestar.junit.composite.runner.testobject.TestObjectInstanceContainer;
import flarestar.junit.composite.runner.testobject.TestObjectProxyClassFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRunner
extends Runner {
    private final RunnerChainFactory chainFactory = new RunnerChainFactory();
    private final TestObjectProxyClassFactory testObjectClassFactory = new TestObjectProxyClassFactory();
    private final List<Class<? extends ParentRunner<?>>> runnerClasses;
    private final List<ParentRunner<?>> composedRunners;
    private Class<?> testClassUnprocessed;
    private Class<?> testClass;

    public CompositeRunner(Class<?> testClassUnprocessed) throws InitializationError {
        this.testClassUnprocessed = testClassUnprocessed;
        Runners annotation = testClassUnprocessed.getAnnotation(Runners.class);
        if (annotation == null) {
            throw new IllegalArgumentException("The CompositeRunner runner must be used in conjunction with the @Runners annotation.");
        }
        this.testClass = this.testObjectClassFactory.makeProxy(testClassUnprocessed);
        this.runnerClasses = this.getComposedRunnerClasses(annotation);
        this.composedRunners = this.chainFactory.makeRunnerChain(this.testClass, this);
    }

    public Description getDescription() {
        return this.getStructureProvidingRunner().getDescription();
    }

    public void run(RunNotifier runNotifier) {
        try {
            this.getStructureProvidingRunner().run(runNotifier);
        }
        finally {
            TestObjectInstanceContainer.currentTestInstance.pop();
        }
    }

    public ParentRunner<?> getStructureProvidingRunner() {
        return this.composedRunners.get(0);
    }

    private List<Class<? extends ParentRunner<?>>> getComposedRunnerClasses(Runners annotation) {
        ArrayList result = new ArrayList();
        result.add(annotation.value());
        Collections.addAll(result, annotation.others());
        return result;
    }

    public List<Class<? extends ParentRunner<?>>> getRunnerClasses() {
        return this.runnerClasses;
    }
}

