/*
 * Decompiled with CFR 0.152.
 */
package flarestar.junit.composite.runner.chain;

import flarestar.junit.composite.runner.CompositeRunner;
import flarestar.junit.composite.runner.chain.RunnerChainLinkFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerChainFactory {
    private final RunnerChainLinkFactory factory = new RunnerChainLinkFactory();

    public List<ParentRunner<?>> makeRunnerChain(Class<?> testClass, CompositeRunner compositeRunner) throws InitializationError {
        List<Class<ParentRunner<?>>> runnerClasses = compositeRunner.getRunnerClasses();
        ArrayList runners = new ArrayList(runnerClasses.size());
        this.createRunnerChainLink(testClass, compositeRunner, runners, runnerClasses.iterator(), true);
        return runners;
    }

    private ParentRunner<?> createRunnerChainLink(Class<?> testClass, CompositeRunner compositeRunner, List<ParentRunner<?>> runners, Iterator<Class<? extends ParentRunner<?>>> iterator, boolean isTestStructureProvider) throws InitializationError {
        Class<? extends ParentRunner<?>> thisRunnerClass = iterator.next();
        ParentRunner<?> nextRunner = null;
        if (iterator.hasNext()) {
            nextRunner = this.createRunnerChainLink(testClass, compositeRunner, runners, iterator, false);
        }
        ParentRunner<?> runner = this.factory.makeLink(thisRunnerClass, testClass, compositeRunner, nextRunner, isTestStructureProvider);
        runners.add(0, runner);
        return runner;
    }

    public static ParentRunner<?> makeChain(Class<?> testCaseClass, CompositeRunner runner) {
        List<ParentRunner<?>> chain;
        RunnerChainFactory factory = new RunnerChainFactory();
        try {
            chain = factory.makeRunnerChain(testCaseClass, runner);
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException(initializationError);
        }
        return chain.get(0);
    }
}

