/*
 * Decompiled with CFR 0.152.
 */
package flarestar.junit.composite.runner.chain;

import flarestar.junit.composite.runner.CompositeRunner;
import flarestar.junit.composite.runner.javassist.BaseClassExtender;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnerChainLinkFactory
extends BaseClassExtender {
    public ParentRunner<?> makeLink(Class<? extends ParentRunner<?>> runnerClass, final Class<?> testClass, final CompositeRunner compositeRunner, final ParentRunner<?> nextRunner, boolean isTestStructureProvider) throws InitializationError {
        ClassPool pool = ClassPool.getDefault();
        String newClassName = runnerClass.getName() + (isTestStructureProvider ? "TestStructureProvider" : "ChainLink");
        final Class<?> newRunnerCtClass = this.makeLinkClass(pool, newClassName, runnerClass, isTestStructureProvider);
        try {
            return (ParentRunner)new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return newRunnerCtClass.getConstructor(Class.class, CompositeRunner.class, ParentRunner.class).newInstance(new Object[]{testClass, compositeRunner, nextRunner});
                }
            }.run();
        }
        catch (InitializationError e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private Class<?> makeLinkClass(ClassPool pool, String newClassName, Class<? extends ParentRunner<?>> runnerClass, boolean isTestStructureProvider) {
        try {
            return Class.forName(newClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CtClass runnerCtClass;
            try {
                runnerCtClass = pool.get(runnerClass.getName());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            CtClass newRunnerCtClass = pool.makeClass(newClassName, runnerCtClass);
            this.copyAnnotations(pool, runnerClass, newRunnerCtClass);
            try {
                newRunnerCtClass.addField(this.makeNextRunnerField(newRunnerCtClass));
                newRunnerCtClass.addField(this.makeFirstRunnerField(newRunnerCtClass));
                newRunnerCtClass.addConstructor(this.makeNewClassConstructor(newRunnerCtClass));
                newRunnerCtClass.addMethod(this.makeChildrenInvokerMethod(newRunnerCtClass));
                newRunnerCtClass.addMethod(this.makeRunChildMethod(newRunnerCtClass));
                if (!isTestStructureProvider) {
                    newRunnerCtClass.addMethod(this.makeGetChildrenMethod(newRunnerCtClass));
                    newRunnerCtClass.addMethod(this.makeDescribeChildMethod(runnerClass, newRunnerCtClass));
                    newRunnerCtClass.addMethod(this.makeNullCollectInitializationErrorsMethod(newRunnerCtClass));
                }
                return newRunnerCtClass.toClass();
            }
            catch (CannotCompileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private CtMethod makeNullCollectInitializationErrorsMethod(CtClass declaringClass) throws CannotCompileException {
        String collectInitializationErrors = "protected void collectInitializationErrors(java.util.List errors) { }";
        return CtNewMethod.make((String)collectInitializationErrors, (CtClass)declaringClass);
    }

    private CtMethod makeDescribeChildMethod(Class<? extends ParentRunner<?>> runnerClass, CtClass declaringClass) throws CannotCompileException {
        String parameterType = this.getDescribeChildParameterType(runnerClass).getName();
        String describeChild = "protected org.junit.runner.Description describeChild(" + parameterType + " child) {\n    return flarestar.junit.composite.runner.chain.RunnerChainLinkFactory.invokeDescribeChild(compositeRunner.getStructureProvidingRunner(), child);\n}";
        return CtNewMethod.make((String)describeChild, (CtClass)declaringClass);
    }

    private Class<?> getDescribeChildParameterType(Class<? extends ParentRunner<?>> runnerClass) {
        while (runnerClass.getSuperclass() != ParentRunner.class) {
            runnerClass = runnerClass.getSuperclass();
        }
        return (Class)((ParameterizedType)runnerClass.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private CtMethod makeGetChildrenMethod(CtClass declaringClass) throws CannotCompileException {
        String getChildren = "protected java.util.List getChildren() {\n    return flarestar.junit.composite.runner.chain.RunnerChainLinkFactory.invokeGetChildren(compositeRunner.getStructureProvidingRunner());\n}";
        return CtNewMethod.make((String)getChildren, (CtClass)declaringClass);
    }

    private CtField makeNextRunnerField(CtClass declaringClass) throws CannotCompileException {
        return CtField.make((String)"private org.junit.runners.ParentRunner nextRunner;", (CtClass)declaringClass);
    }

    private CtField makeFirstRunnerField(CtClass declaringClass) throws CannotCompileException {
        return CtField.make((String)"private flarestar.junit.composite.runner.CompositeRunner compositeRunner;", (CtClass)declaringClass);
    }

    private CtMethod makeChildrenInvokerMethod(CtClass declaringClass) throws CannotCompileException {
        String childrenInvoker = "    protected org.junit.runners.model.Statement childrenInvoker(org.junit.runner.notification.RunNotifier notifier) {\n        if (nextRunner == null) {\n            return new flarestar.junit.composite.runner.statement.RunChildren(\n                compositeRunner.getStructureProvidingRunner(), notifier);\n        } else {\n            return flarestar.junit.composite.runner.chain.RunnerChainLinkFactory.invokeClassBlock(nextRunner, notifier);\n        }\n    }";
        return CtNewMethod.make((String)childrenInvoker, (CtClass)declaringClass);
    }

    private CtConstructor makeNewClassConstructor(CtClass declaringClass) throws CannotCompileException {
        String constructor = "public CustomRunner(Class testClass, flarestar.junit.composite.runner.CompositeRunner compositeRunner, org.junit.runners.ParentRunner nextRunner) {\n    super(testClass);\n    this.compositeRunner = compositeRunner;\n    this.nextRunner = nextRunner;\n}";
        return CtNewConstructor.make((String)constructor, (CtClass)declaringClass);
    }

    private CtMethod makeRunChildMethod(CtClass newRunnerCtClass) throws CannotCompileException {
        String runChild = "    protected void runChild(Object child, org.junit.runner.notification.RunNotifier notifier) {\n        if (nextRunner != null) {\n            if (child.getClass() == org.junit.runners.model.FrameworkMethod.class) {\n                child = new flarestar.junit.composite.runner.chain.FrameworkMethodChainLink((org.junit.runners.model.FrameworkMethod)child, notifier, nextRunner);\n            }\n            notifier = new flarestar.junit.composite.runner.notifier.NullRunNotifier(notifier);\n        }\n\n        super.runChild(child, notifier);\n    }";
        return CtNewMethod.make((String)runChild, (CtClass)newRunnerCtClass);
    }

    public static Statement invokeClassBlock(final ParentRunner<?> nextRunner, final RunNotifier notifier) {
        try {
            return (Statement)new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    Method classBlockMethod = ParentRunner.class.getDeclaredMethod("classBlock", RunNotifier.class);
                    classBlockMethod.setAccessible(true);
                    return classBlockMethod.invoke((Object)nextRunner, notifier);
                }
            }.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static List invokeGetChildren(final ParentRunner<?> runner) {
        try {
            return (List)new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    Method getChildrenMethod = ParentRunner.class.getDeclaredMethod("getChildren", new Class[0]);
                    getChildrenMethod.setAccessible(true);
                    return getChildrenMethod.invoke((Object)runner, new Object[0]);
                }
            }.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static Description invokeDescribeChild(final ParentRunner<?> runner, final Object child) {
        try {
            return (Description)new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    Method describeChildMethod = ParentRunner.class.getDeclaredMethod("describeChild", Object.class);
                    describeChildMethod.setAccessible(true);
                    return describeChildMethod.invoke((Object)runner, child);
                }
            }.run();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

