/*
 * Decompiled with CFR 0.152.
 */
package flarestar.junit.composite.runner.javassist;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassExtender {
    protected void copyAnnotations(ClassPool pool, Class<?> runnerClass, CtClass newRunnerCtClass) {
        ClassFile classFile = newRunnerCtClass.getClassFile();
        classFile.addAttribute((AttributeInfo)this.makeAnnotationAttribute(pool, classFile.getConstPool(), runnerClass));
    }

    protected AnnotationsAttribute makeAnnotationAttribute(ClassPool classPool, ConstPool pool, Class<?> klass) {
        AnnotationsAttribute result = new AnnotationsAttribute(pool, "RuntimeVisibleAnnotations");
        for (Annotation annotation : klass.getAnnotations()) {
            result.addAnnotation(this.makeBytecodeAnnotation(classPool, pool, annotation));
        }
        return result;
    }

    protected javassist.bytecode.annotation.Annotation makeBytecodeAnnotation(ClassPool classPool, ConstPool pool, Annotation annotation) {
        javassist.bytecode.annotation.Annotation byteCodeAnnotation = new javassist.bytecode.annotation.Annotation(annotation.annotationType().getName(), pool);
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            Object value;
            try {
                value = method.invoke((Object)annotation, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            byteCodeAnnotation.addMemberValue(method.getName(), this.makeMemberValue(classPool, pool, value));
        }
        return byteCodeAnnotation;
    }

    protected MemberValue makeMemberValue(ClassPool classPool, ConstPool pool, Object value) {
        if (value instanceof Annotation) {
            return new AnnotationMemberValue(this.makeBytecodeAnnotation(classPool, pool, (Annotation)value), pool);
        }
        if (value.getClass().isArray()) {
            ArrayMemberValue result = new ArrayMemberValue(this.makeMemberValue(classPool, pool, value.getClass().getComponentType()), pool);
            MemberValue[] elements = new MemberValue[Array.getLength(value)];
            for (int i = 0; i != elements.length; ++i) {
                elements[i] = this.makeMemberValue(classPool, pool, Array.get(value, i));
            }
            result.setValue(elements);
            return result;
        }
        if (value instanceof Boolean) {
            return new BooleanMemberValue(((Boolean)value).booleanValue(), pool);
        }
        if (value instanceof Byte) {
            return new ByteMemberValue(((Byte)value).byteValue(), pool);
        }
        if (value instanceof Character) {
            return new CharMemberValue(((Character)value).charValue(), pool);
        }
        if (value instanceof Double) {
            return new DoubleMemberValue(((Double)value).doubleValue(), pool);
        }
        if (value instanceof Enum) {
            EnumMemberValue result = new EnumMemberValue(pool);
            result.setType(value.getClass().getName());
            result.setValue(((Enum)value).name());
            return result;
        }
        if (value instanceof Float) {
            return new FloatMemberValue(((Float)value).floatValue(), pool);
        }
        if (value instanceof Integer) {
            return new IntegerMemberValue(pool, ((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new LongMemberValue(((Long)value).longValue(), pool);
        }
        if (value instanceof Short) {
            return new ShortMemberValue(((Short)value).shortValue(), pool);
        }
        if (value instanceof String) {
            return new StringMemberValue((String)value, pool);
        }
        if (value instanceof Class) {
            return new ClassMemberValue(((Class)value).getName(), pool);
        }
        throw new IllegalArgumentException("Don't know how to convert " + value.getClass().getName() + " into an annotation MemberValue.");
    }
}

