/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper;

import com.flipkart.hbaseobjectmapper.HBObjectMapper;
import com.flipkart.hbaseobjectmapper.HBObjectMapperFactory;
import com.flipkart.hbaseobjectmapper.HBRecord;
import com.flipkart.hbaseobjectmapper.HBTable;
import com.flipkart.hbaseobjectmapper.WrappedHBColumn;
import com.flipkart.hbaseobjectmapper.WrappedHBTable;
import com.flipkart.hbaseobjectmapper.codec.Codec;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;

public abstract class AbstractHBDAO<R extends Serializable & Comparable<R>, T extends HBRecord<R>>
implements Closeable {
    protected final HBObjectMapper hbObjectMapper;
    protected final Table table;
    protected final Class<R> rowKeyClass;
    protected final Class<T> hbRecordClass;
    protected final WrappedHBTable<R, T> hbTable;
    private final Map<String, Field> fields;

    protected AbstractHBDAO(Connection connection, HBObjectMapper hbObjectMapper) throws IOException {
        this.hbObjectMapper = hbObjectMapper;
        this.hbRecordClass = new TypeToken<T>(this.getClass()){}.getRawType();
        this.hbObjectMapper.validateHBClass(this.hbRecordClass);
        this.rowKeyClass = new TypeToken<R>(this.getClass()){}.getRawType();
        if (this.hbRecordClass == null || this.rowKeyClass == null) {
            throw new IllegalStateException(String.format("Unable to resolve HBase record/rowkey type (record class is resolving to %s and rowkey class is resolving to %s)", this.hbRecordClass, this.rowKeyClass));
        }
        this.hbTable = new WrappedHBTable(this.hbRecordClass);
        this.table = connection.getTable(this.hbTable.getName());
        this.fields = hbObjectMapper.getHBColumnFields0(this.hbRecordClass);
    }

    protected AbstractHBDAO(Configuration configuration, HBObjectMapper hbObjectMapper) throws IOException {
        this(ConnectionFactory.createConnection((Configuration)configuration), hbObjectMapper);
    }

    protected AbstractHBDAO(Connection connection, Codec codec) throws IOException {
        this(connection, HBObjectMapperFactory.construct(codec));
    }

    protected AbstractHBDAO(Configuration configuration, Codec codec) throws IOException {
        this(ConnectionFactory.createConnection((Configuration)configuration), HBObjectMapperFactory.construct(codec));
    }

    protected AbstractHBDAO(Connection connection) throws IOException {
        this(connection, (Codec)null);
    }

    protected AbstractHBDAO(Configuration configuration) throws IOException {
        this(configuration, (Codec)null);
    }

    public T get(R rowKey, int numVersionsToFetch) throws IOException {
        Result result = this.table.get(new Get(this.toBytes(rowKey)).setMaxVersions(numVersionsToFetch));
        return this.hbObjectMapper.readValue(rowKey, result, this.hbRecordClass);
    }

    public T get(R rowKey) throws IOException {
        return this.get(rowKey, 1);
    }

    public Get getGet(R rowKey) {
        return new Get(this.toBytes(rowKey));
    }

    public T getOnGet(Get get) throws IOException {
        Result result = this.table.get(get);
        return this.hbObjectMapper.readValue(result, this.hbRecordClass);
    }

    public List<T> getOnGets(List<Get> gets) throws IOException {
        Result[] results = this.table.get(gets);
        ArrayList<T> records = new ArrayList<T>(results.length);
        for (Result result : results) {
            records.add(this.hbObjectMapper.readValue(result, this.hbRecordClass));
        }
        return records;
    }

    public T[] get(R[] rowKeys, int numVersionsToFetch) throws IOException {
        ArrayList<Get> gets = new ArrayList<Get>(rowKeys.length);
        for (R rowKey : rowKeys) {
            gets.add(new Get(this.toBytes(rowKey)).setMaxVersions(numVersionsToFetch));
        }
        Result[] results = this.table.get(gets);
        HBRecord[] records = (HBRecord[])Array.newInstance(this.hbRecordClass, rowKeys.length);
        for (int i = 0; i < records.length; ++i) {
            records[i] = this.hbObjectMapper.readValue(rowKeys[i], results[i], this.hbRecordClass);
        }
        return records;
    }

    public T[] get(R[] rowKeys) throws IOException {
        return this.get((R)rowKeys, 1);
    }

    public List<T> get(List<R> rowKeys, int numVersionsToFetch) throws IOException {
        ArrayList<Get> gets = new ArrayList<Get>(rowKeys.size());
        for (Serializable rowKey : rowKeys) {
            gets.add(new Get(this.toBytes(rowKey)).setMaxVersions(numVersionsToFetch));
        }
        Result[] results = this.table.get(gets);
        ArrayList<T> records = new ArrayList<T>(rowKeys.size());
        for (Result result : results) {
            records.add(this.hbObjectMapper.readValue(result, this.hbRecordClass));
        }
        return records;
    }

    public List<T> get(List<R> rowKeys) throws IOException {
        return this.get(rowKeys, true);
    }

    public List<T> get(R startRowKey, R endRowKey, int numVersionsToFetch) throws IOException {
        Scan scan = new Scan(this.toBytes(startRowKey), this.toBytes(endRowKey)).setMaxVersions(numVersionsToFetch);
        ResultScanner scanner = this.table.getScanner(scan);
        ArrayList<T> records = new ArrayList<T>();
        for (Result result : scanner) {
            records.add(this.hbObjectMapper.readValue(result, this.hbRecordClass));
        }
        return records;
    }

    private WrappedHBColumn validateAndGetLongColumn(String fieldName) {
        Field field = this.getField(fieldName);
        if (!Long.class.equals(field.getType())) {
            throw new IllegalArgumentException(String.format("Invalid attempt to increment a non-Long field (%s.%s)", this.hbRecordClass.getName(), fieldName));
        }
        return new WrappedHBColumn(field, true);
    }

    public long increment(R rowKey, String fieldName, long amount) throws IOException {
        WrappedHBColumn hbColumn = this.validateAndGetLongColumn(fieldName);
        return this.table.incrementColumnValue(this.toBytes(rowKey), hbColumn.familyBytes(), hbColumn.columnBytes(), amount);
    }

    public long increment(R rowKey, String fieldName, long amount, Durability durability) throws IOException {
        WrappedHBColumn hbColumn = this.validateAndGetLongColumn(fieldName);
        return this.table.incrementColumnValue(this.toBytes(rowKey), hbColumn.familyBytes(), hbColumn.columnBytes(), amount, durability);
    }

    public Increment getIncrement(R rowKey) {
        return new Increment(this.toBytes(rowKey));
    }

    public T increment(Increment increment) throws IOException {
        Result result = this.table.increment(increment);
        return this.hbObjectMapper.readValue(result, this.hbRecordClass);
    }

    public List<T> get(R startRowKey, R endRowKey) throws IOException {
        return this.get(startRowKey, endRowKey, 1);
    }

    public R persist(HBRecord<R> record) throws IOException {
        Put put = this.hbObjectMapper.writeValueAsPut(record);
        this.table.put(put);
        return record.composeRowKey();
    }

    public List<R> persist(List<T> records) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(records.size());
        ArrayList rowKeys = new ArrayList(records.size());
        for (HBRecord object : records) {
            puts.add(this.hbObjectMapper.writeValueAsPut(object));
            rowKeys.add(object.composeRowKey());
        }
        this.table.put(puts);
        return rowKeys;
    }

    public void delete(R rowKey) throws IOException {
        Delete delete = new Delete(this.toBytes(rowKey));
        this.table.delete(delete);
    }

    public void delete(HBRecord<R> record) throws IOException {
        this.delete(record.composeRowKey());
    }

    public void delete(R[] rowKeys) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(rowKeys.length);
        for (R rowKey : rowKeys) {
            deletes.add(new Delete(this.toBytes(rowKey)));
        }
        this.table.delete(deletes);
    }

    public void delete(List<T> records) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(records.size());
        for (HBRecord record : records) {
            deletes.add(new Delete(this.toBytes(record.composeRowKey())));
        }
        this.table.delete(deletes);
    }

    public String getTableName() {
        return this.hbRecordClass.getAnnotation(HBTable.class).name();
    }

    public Map<String, Integer> getColumnFamiliesAndVersions() {
        return this.hbObjectMapper.getColumnFamiliesAndVersions(this.hbRecordClass);
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public Table getHBaseTable() {
        return this.table;
    }

    private Field getField(String fieldName) {
        Field field = this.fields.get(fieldName);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Unrecognized field: '%s'. Choose one of %s", fieldName, this.fields.values().toString()));
        }
        return field;
    }

    private void populateFieldValuesToMap(Field field, Result result, Map<R, NavigableMap<Long, Object>> map) {
        if (result.isEmpty()) {
            return;
        }
        WrappedHBColumn hbColumn = new WrappedHBColumn(field, true);
        List cells = result.getColumnCells(hbColumn.familyBytes(), hbColumn.columnBytes());
        for (Cell cell : cells) {
            Type fieldType = this.hbObjectMapper.getFieldType(field, hbColumn.isMultiVersioned());
            Object rowKey = this.hbObjectMapper.bytesToRowKey(CellUtil.cloneRow((Cell)cell), this.hbTable.getCodecFlags(), field.getDeclaringClass());
            if (!map.containsKey(rowKey)) {
                map.put(rowKey, new TreeMap());
            }
            map.get(rowKey).put(cell.getTimestamp(), this.hbObjectMapper.byteArrayToValue(CellUtil.cloneValue((Cell)cell), fieldType, hbColumn.codecFlags()));
        }
    }

    public Object fetchFieldValue(R rowKey, String fieldName) throws IOException {
        NavigableMap<Long, Object> fieldValues = this.fetchFieldValue(rowKey, fieldName, 1);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        return fieldValues.lastEntry().getValue();
    }

    public NavigableMap<Long, Object> fetchFieldValue(R rowKey, String fieldName, int numVersionsToFetch) throws IOException {
        Serializable[] array = (Serializable[])Array.newInstance(this.rowKeyClass, 1);
        array[0] = rowKey;
        return (NavigableMap)this.fetchFieldValues(array, fieldName, numVersionsToFetch).get(rowKey);
    }

    public Map<R, Object> fetchFieldValues(R startRowKey, R endRowKey, String fieldName) throws IOException {
        NavigableMap<R, NavigableMap<Long, Object>> multiVersionedMap = this.fetchFieldValues(startRowKey, endRowKey, fieldName, 1);
        return this.toSingleVersioned(multiVersionedMap, 10);
    }

    private Map<R, Object> toSingleVersioned(Map<R, NavigableMap<Long, Object>> multiVersionedMap, int mapInitialCapacity) {
        HashMap<R, Object> map = new HashMap<R, Object>(mapInitialCapacity, 1.0f);
        for (Map.Entry<R, NavigableMap<Long, Object>> e : multiVersionedMap.entrySet()) {
            map.put(e.getKey(), e.getValue().lastEntry().getValue());
        }
        return map;
    }

    public NavigableMap<R, NavigableMap<Long, Object>> fetchFieldValues(R startRowKey, R endRowKey, String fieldName, int numVersionsToFetch) throws IOException {
        Field field = this.getField(fieldName);
        WrappedHBColumn hbColumn = new WrappedHBColumn(field, true);
        Scan scan = new Scan(this.toBytes(startRowKey), this.toBytes(endRowKey));
        scan.addColumn(hbColumn.familyBytes(), hbColumn.columnBytes());
        scan.setMaxVersions(numVersionsToFetch);
        ResultScanner scanner = this.table.getScanner(scan);
        TreeMap map = new TreeMap();
        for (Result result : scanner) {
            this.populateFieldValuesToMap(field, result, map);
        }
        return map;
    }

    public Map<R, Object> fetchFieldValues(R[] rowKeys, String fieldName) throws IOException {
        Map multiVersionedMap = this.fetchFieldValues((Serializable[])rowKeys, fieldName, 1);
        return this.toSingleVersioned(multiVersionedMap, rowKeys.length);
    }

    public Map<R, NavigableMap<Long, Object>> fetchFieldValues(R[] rowKeys, String fieldName, int numVersionsToFetch) throws IOException {
        Field field = this.getField(fieldName);
        WrappedHBColumn hbColumn = new WrappedHBColumn(field, true);
        ArrayList<Get> gets = new ArrayList<Get>(rowKeys.length);
        for (R rowKey : rowKeys) {
            Get get = new Get(this.toBytes(rowKey));
            get.setMaxVersions(numVersionsToFetch);
            get.addColumn(hbColumn.familyBytes(), hbColumn.columnBytes());
            gets.add(get);
        }
        Result[] results = this.table.get(gets);
        HashMap map = new HashMap(rowKeys.length, 1.0f);
        for (Result result : results) {
            this.populateFieldValuesToMap(field, result, map);
        }
        return map;
    }

    private byte[] toBytes(R rowKey) {
        return this.hbObjectMapper.rowKeyToBytes(rowKey, this.hbTable.getCodecFlags());
    }

    @Override
    public void close() throws IOException {
        this.table.close();
    }
}

