/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper;

import com.flipkart.hbaseobjectmapper.FamilyAndColumn;
import com.flipkart.hbaseobjectmapper.HBRecord;
import com.flipkart.hbaseobjectmapper.HBRowKey;
import com.flipkart.hbaseobjectmapper.HBTable;
import com.flipkart.hbaseobjectmapper.MappedSuperClass;
import com.flipkart.hbaseobjectmapper.WrappedHBColumn;
import com.flipkart.hbaseobjectmapper.WrappedHBTable;
import com.flipkart.hbaseobjectmapper.codec.BestSuitCodec;
import com.flipkart.hbaseobjectmapper.codec.Codec;
import com.flipkart.hbaseobjectmapper.codec.exceptions.DeserializationException;
import com.flipkart.hbaseobjectmapper.codec.exceptions.SerializationException;
import com.flipkart.hbaseobjectmapper.exceptions.AllHBColumnFieldsNullException;
import com.flipkart.hbaseobjectmapper.exceptions.BadHBaseLibStateException;
import com.flipkart.hbaseobjectmapper.exceptions.CodecException;
import com.flipkart.hbaseobjectmapper.exceptions.ConversionFailedException;
import com.flipkart.hbaseobjectmapper.exceptions.EmptyConstructorInaccessibleException;
import com.flipkart.hbaseobjectmapper.exceptions.FieldAnnotatedWithHBColumnMultiVersionCantBeEmpty;
import com.flipkart.hbaseobjectmapper.exceptions.FieldsMappedToSameColumnException;
import com.flipkart.hbaseobjectmapper.exceptions.IncompatibleFieldForHBColumnMultiVersionAnnotationException;
import com.flipkart.hbaseobjectmapper.exceptions.InternalError;
import com.flipkart.hbaseobjectmapper.exceptions.MappedColumnCantBePrimitiveException;
import com.flipkart.hbaseobjectmapper.exceptions.MappedColumnCantBeStaticException;
import com.flipkart.hbaseobjectmapper.exceptions.MappedColumnCantBeTransientException;
import com.flipkart.hbaseobjectmapper.exceptions.MissingHBColumnFieldsException;
import com.flipkart.hbaseobjectmapper.exceptions.MissingHBRowKeyFieldsException;
import com.flipkart.hbaseobjectmapper.exceptions.NoEmptyConstructorException;
import com.flipkart.hbaseobjectmapper.exceptions.ObjectNotInstantiatableException;
import com.flipkart.hbaseobjectmapper.exceptions.RowKeyCantBeComposedException;
import com.flipkart.hbaseobjectmapper.exceptions.RowKeyCantBeEmptyException;
import com.flipkart.hbaseobjectmapper.exceptions.RowKeyCouldNotBeParsedException;
import com.flipkart.hbaseobjectmapper.exceptions.UnsupportedFieldTypeException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class HBObjectMapper {
    private static final Codec DEFAULT_CODEC = new BestSuitCodec();
    private final Codec codec;

    public HBObjectMapper(Codec codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Parameter 'codec' cannot be null. If you want to use the default codec, use the no-arg constructor");
        }
        this.codec = codec;
    }

    public HBObjectMapper() {
        this(DEFAULT_CODEC);
    }

    <R extends Serializable & Comparable<R>> byte[] rowKeyToBytes(R rowKey, Map<String, String> codecFlags) {
        return this.valueToByteArray(rowKey, codecFlags);
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> R bytesToRowKey(byte[] rowKeyBytes, Map<String, String> codecFlags, Class<T> entityClass) {
        try {
            return (R)((Serializable)this.byteArrayToValue(rowKeyBytes, entityClass.getDeclaredMethod("composeRowKey", new Class[0]).getReturnType(), codecFlags));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e);
        }
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T convertMapToRecord(byte[] rowKeyBytes, NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> map, Class<T> clazz) {
        HBRecord record;
        Collection<Field> fields = this.getHBColumnFields0(clazz).values();
        WrappedHBTable hbTable = new WrappedHBTable(clazz);
        R rowKey = this.bytesToRowKey(rowKeyBytes, hbTable.getCodecFlags(), clazz);
        try {
            record = (HBRecord)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ObjectNotInstantiatableException("Error while instantiating empty constructor of " + clazz.getName(), ex);
        }
        try {
            record.parseRowKey(rowKey);
        }
        catch (Exception ex) {
            throw new RowKeyCouldNotBeParsedException(String.format("Supplied row key \"%s\" could not be parsed", rowKey), ex);
        }
        for (Field field : fields) {
            WrappedHBColumn hbColumn = new WrappedHBColumn(field);
            NavigableMap familyMap = (NavigableMap)map.get(hbColumn.familyBytes());
            if (familyMap == null || familyMap.isEmpty()) continue;
            NavigableMap columnVersionsMap = (NavigableMap)familyMap.get(hbColumn.columnBytes());
            if (hbColumn.isSingleVersioned()) {
                if (columnVersionsMap == null || columnVersionsMap.isEmpty()) continue;
                Map.Entry lastEntry = columnVersionsMap.lastEntry();
                this.objectSetFieldValue((Object)record, field, (byte[])lastEntry.getValue(), hbColumn.codecFlags());
                continue;
            }
            this.objectSetFieldValue((Object)record, field, columnVersionsMap, hbColumn.codecFlags());
        }
        return (T)record;
    }

    private byte[] valueToByteArray(Serializable value, Map<String, String> codecFlags) {
        try {
            return this.codec.serialize(value, codecFlags);
        }
        catch (SerializationException e) {
            throw new CodecException("Couldn't serialize", e);
        }
    }

    public ImmutableBytesWritable toIbw(Serializable value) {
        return new ImmutableBytesWritable(this.valueToByteArray(value, null));
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> WrappedHBTable<R, T> validateHBClass(Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoEmptyConstructorException(String.format("Class %s needs to specify an empty (public) constructor", clazz.getName()), e);
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new EmptyConstructorInaccessibleException(String.format("Empty constructor of class %s is inaccessible. It needs to be public.", clazz.getName()));
        }
        int numOfHBColumns = 0;
        int numOfHBRowKeys = 0;
        WrappedHBTable hbTable = new WrappedHBTable(clazz);
        HashSet<FamilyAndColumn> columns = new HashSet<FamilyAndColumn>(clazz.getDeclaredFields().length, 1.0f);
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(HBRowKey.class)) continue;
            ++numOfHBRowKeys;
        }
        if (numOfHBRowKeys == 0) {
            throw new MissingHBRowKeyFieldsException(clazz);
        }
        Map<String, Field> hbColumnFields = this.getHBColumnFields0(clazz);
        for (Field field : hbColumnFields.values()) {
            WrappedHBColumn hbColumn = new WrappedHBColumn(field);
            if (!hbColumn.isPresent()) continue;
            if (!hbTable.isColumnFamilyPresent(hbColumn.family())) {
                throw new IllegalArgumentException(String.format("Class %s has field '%s' mapped to HBase column '%s' - but column family '%s' isn't configured in @%s annotation", clazz.getName(), field.getName(), hbColumn, hbColumn.family(), HBTable.class.getSimpleName()));
            }
            if (hbColumn.isSingleVersioned()) {
                this.validateHBColumnSingleVersionField(field);
            } else if (hbColumn.isMultiVersioned()) {
                this.validateHBColumnMultiVersionField(field);
            }
            if (!columns.add(new FamilyAndColumn(hbColumn.family(), hbColumn.column()))) {
                throw new FieldsMappedToSameColumnException(String.format("Class %s has more than one field (e.g. '%s') mapped to same HBase column %s", clazz.getName(), field.getName(), hbColumn));
            }
            ++numOfHBColumns;
        }
        if (numOfHBColumns == 0) {
            throw new MissingHBColumnFieldsException(clazz);
        }
        return hbTable;
    }

    private void validateHBColumnMultiVersionField(Field field) {
        this.validateHBColumnField(field);
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            throw new IncompatibleFieldForHBColumnMultiVersionAnnotationException(String.format("Field %s is not even a parameterized type", field));
        }
        if (field.getType() != NavigableMap.class) {
            throw new IncompatibleFieldForHBColumnMultiVersionAnnotationException(String.format("Field %s is not a NavigableMap", field));
        }
        ParameterizedType pType = (ParameterizedType)field.getGenericType();
        Type[] typeArguments = pType.getActualTypeArguments();
        if (typeArguments.length != 2 || typeArguments[0] != Long.class) {
            throw new IncompatibleFieldForHBColumnMultiVersionAnnotationException(String.format("Field %s has unexpected type params (Key should be of %s type)", field, Long.class.getName()));
        }
        if (!this.codec.canDeserialize(this.getFieldType(field, true))) {
            throw new UnsupportedFieldTypeException(String.format("Field %s in class %s is of unsupported type Navigable<Long,%s> ", field.getName(), field.getDeclaringClass().getName(), field.getDeclaringClass().getName()));
        }
    }

    Type getFieldType(Field field, boolean isMultiVersioned) {
        if (isMultiVersioned) {
            return ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
        }
        return field.getGenericType();
    }

    private void validateHBColumnSingleVersionField(Field field) {
        Class fieldClazz;
        this.validateHBColumnField(field);
        Type fieldType = this.getFieldType(field, false);
        if (fieldType instanceof Class && (fieldClazz = (Class)fieldType).isPrimitive()) {
            throw new MappedColumnCantBePrimitiveException(String.format("Field %s in class %s is a primitive of type %s (Primitive data types are not supported as they're not nullable)", field.getName(), field.getDeclaringClass().getName(), fieldClazz.getName()));
        }
        if (!this.codec.canDeserialize(fieldType)) {
            throw new UnsupportedFieldTypeException(String.format("Field %s in class %s is of unsupported type (%s)", field.getName(), field.getDeclaringClass().getName(), fieldType));
        }
    }

    private void validateHBColumnField(Field field) {
        WrappedHBColumn hbColumn = new WrappedHBColumn(field);
        int modifiers = field.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            throw new MappedColumnCantBeTransientException(field, hbColumn.getName());
        }
        if (Modifier.isStatic(modifiers)) {
            throw new MappedColumnCantBeStaticException(field, hbColumn.getName());
        }
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> convertRecordToMap(HBRecord<R> record) {
        Class<?> clazz = record.getClass();
        Collection<Field> fields = this.getHBColumnFields0(clazz).values();
        TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> map = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        int numOfFieldsToWrite = 0;
        for (Field field : fields) {
            NavigableMap<Long, byte[]> fieldValueVersions;
            WrappedHBColumn hbColumn = new WrappedHBColumn(field);
            if (hbColumn.isSingleVersioned()) {
                byte[] familyName = hbColumn.familyBytes();
                byte[] columnName = hbColumn.columnBytes();
                if (!map.containsKey(familyName)) {
                    map.put(familyName, new TreeMap(Bytes.BYTES_COMPARATOR));
                }
                Map columns = (Map)map.get(familyName);
                byte[] fieldValueBytes = this.getFieldValueAsBytes(record, field, hbColumn.codecFlags());
                if (fieldValueBytes == null || fieldValueBytes.length == 0) continue;
                TreeMap<Long, byte[]> singleValue = new TreeMap<Long, byte[]>();
                singleValue.put(Long.MAX_VALUE, fieldValueBytes);
                columns.put(columnName, singleValue);
                ++numOfFieldsToWrite;
                continue;
            }
            if (!hbColumn.isMultiVersioned() || (fieldValueVersions = this.getFieldValuesAsNavigableMapOfBytes(record, field, hbColumn.codecFlags())) == null) continue;
            byte[] familyName = hbColumn.familyBytes();
            byte[] columnName = hbColumn.columnBytes();
            if (!map.containsKey(familyName)) {
                map.put(familyName, new TreeMap(Bytes.BYTES_COMPARATOR));
            }
            Map columns = (Map)map.get(familyName);
            columns.put(columnName, fieldValueVersions);
            ++numOfFieldsToWrite;
        }
        if (numOfFieldsToWrite == 0) {
            throw new AllHBColumnFieldsNullException();
        }
        return map;
    }

    private <R extends Serializable & Comparable<R>> byte[] getFieldValueAsBytes(HBRecord<R> record, Field field, Map<String, String> codecFlags) {
        Serializable fieldValue;
        try {
            field.setAccessible(true);
            fieldValue = (Serializable)field.get(record);
        }
        catch (IllegalAccessException e) {
            throw new BadHBaseLibStateException(e);
        }
        return this.valueToByteArray(fieldValue, codecFlags);
    }

    private <R extends Serializable & Comparable<R>> NavigableMap<Long, byte[]> getFieldValuesAsNavigableMapOfBytes(HBRecord<R> record, Field field, Map<String, String> codecFlags) {
        try {
            field.setAccessible(true);
            NavigableMap fieldValueVersions = (NavigableMap)field.get(record);
            if (fieldValueVersions == null) {
                return null;
            }
            if (fieldValueVersions.size() == 0) {
                throw new FieldAnnotatedWithHBColumnMultiVersionCantBeEmpty();
            }
            TreeMap<Long, byte[]> output = new TreeMap<Long, byte[]>();
            for (Map.Entry e : fieldValueVersions.entrySet()) {
                Long timestamp = (Long)e.getKey();
                Serializable fieldValue = (Serializable)e.getValue();
                if (fieldValue == null) continue;
                byte[] fieldValueBytes = this.valueToByteArray(fieldValue, codecFlags);
                output.put(timestamp, fieldValueBytes);
            }
            return output;
        }
        catch (IllegalAccessException e) {
            throw new BadHBaseLibStateException(e);
        }
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Put writeValueAsPut(HBRecord<R> record) {
        this.validateHBClass(record.getClass());
        Put put = new Put(this.composeRowKey(record));
        for (Map.Entry fe : this.convertRecordToMap(record).entrySet()) {
            byte[] family = (byte[])fe.getKey();
            for (Map.Entry e : ((NavigableMap)fe.getValue()).entrySet()) {
                byte[] columnName = (byte[])e.getKey();
                NavigableMap columnValuesVersioned = (NavigableMap)e.getValue();
                if (columnValuesVersioned == null) continue;
                for (Map.Entry versionAndValue : columnValuesVersioned.entrySet()) {
                    put.addColumn(family, columnName, ((Long)versionAndValue.getKey()).longValue(), (byte[])versionAndValue.getValue());
                }
            }
        }
        return put;
    }

    public <R extends Serializable & Comparable<R>> List<Put> writeValueAsPut(List<HBRecord<R>> records) {
        ArrayList<Put> puts = new ArrayList<Put>(records.size());
        for (HBRecord<R> record : records) {
            Put put = this.writeValueAsPut(record);
            puts.add(put);
        }
        return puts;
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Result writeValueAsResult(HBRecord<R> record) {
        this.validateHBClass(record.getClass());
        byte[] row = this.composeRowKey(record);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (Map.Entry fe : this.convertRecordToMap(record).entrySet()) {
            byte[] family = (byte[])fe.getKey();
            for (Map.Entry e : ((NavigableMap)fe.getValue()).entrySet()) {
                byte[] columnName = (byte[])e.getKey();
                NavigableMap valuesVersioned = (NavigableMap)e.getValue();
                if (valuesVersioned == null) continue;
                for (Map.Entry columnVersion : valuesVersioned.entrySet()) {
                    cellList.add(CellUtil.createCell((byte[])row, (byte[])family, (byte[])columnName, (long)((Long)columnVersion.getKey()), (byte)KeyValue.Type.Put.getCode(), (byte[])((byte[])columnVersion.getValue())));
                }
            }
        }
        return Result.create(cellList);
    }

    public <R extends Serializable & Comparable<R>> List<Result> writeValueAsResult(List<HBRecord<R>> records) {
        ArrayList<Result> results = new ArrayList<Result>(records.size());
        for (HBRecord<R> record : records) {
            Result result = this.writeValueAsResult(record);
            results.add(result);
        }
        return results;
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(ImmutableBytesWritable rowKey, Result result, Class<T> clazz) {
        this.validateHBClass(clazz);
        if (rowKey == null) {
            return this.readValueFromResult(result, clazz);
        }
        return this.readValueFromRowAndResult(rowKey.get(), result, clazz);
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(Result result, Class<T> clazz) {
        this.validateHBClass(clazz);
        return this.readValueFromResult(result, clazz);
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(R rowKey, Result result, Class<T> clazz) {
        if (rowKey == null) {
            return this.readValueFromResult(result, clazz);
        }
        return this.readValueFromRowAndResult(this.rowKeyToBytes(rowKey, WrappedHBTable.getCodecFlags(clazz)), result, clazz);
    }

    private boolean isResultEmpty(Result result) {
        return result == null || result.isEmpty() || result.getRow() == null || result.getRow().length == 0;
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValueFromResult(Result result, Class<T> clazz) {
        if (this.isResultEmpty(result)) {
            return null;
        }
        return this.convertMapToRecord(result.getRow(), result.getMap(), clazz);
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValueFromRowAndResult(byte[] rowKeyBytes, Result result, Class<T> clazz) {
        if (this.isResultEmpty(result)) {
            return null;
        }
        return this.convertMapToRecord(rowKeyBytes, result.getMap(), clazz);
    }

    private void objectSetFieldValue(Object obj, Field field, NavigableMap<Long, byte[]> columnValuesVersioned, Map<String, String> codecFlags) {
        if (columnValuesVersioned == null) {
            return;
        }
        try {
            field.setAccessible(true);
            TreeMap columnValuesVersionedBoxed = new TreeMap();
            for (Map.Entry versionAndValue : columnValuesVersioned.entrySet()) {
                columnValuesVersionedBoxed.put(versionAndValue.getKey(), this.byteArrayToValue((byte[])versionAndValue.getValue(), ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1], codecFlags));
            }
            field.set(obj, columnValuesVersionedBoxed);
        }
        catch (Exception ex) {
            throw new ConversionFailedException(String.format("Could not set value on field \"%s\" on instance of class %s", field.getName(), obj.getClass()), ex);
        }
    }

    private void objectSetFieldValue(Object obj, Field field, byte[] value, Map<String, String> codecFlags) {
        if (value == null || value.length == 0) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(obj, this.byteArrayToValue(value, field.getGenericType(), codecFlags));
        }
        catch (IllegalAccessException e) {
            throw new ConversionFailedException(String.format("Could not set value on field \"%s\" on instance of class %s", field.getName(), obj.getClass()), e);
        }
    }

    Object byteArrayToValue(byte[] value, Type type, Map<String, String> codecFlags) {
        try {
            if (value == null || value.length == 0) {
                return null;
            }
            return this.codec.deserialize(value, type, codecFlags);
        }
        catch (DeserializationException e) {
            throw new CodecException("Error while deserializing", e);
        }
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(ImmutableBytesWritable rowKey, Put put, Class<T> clazz) {
        this.validateHBClass(clazz);
        if (rowKey == null) {
            return this.readValueFromPut(put, clazz);
        }
        return this.readValueFromRowAndPut(rowKey.get(), put, clazz);
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(R rowKey, Put put, Class<T> clazz) {
        if (rowKey == null) {
            return this.readValueFromPut(put, clazz);
        }
        return this.readValueFromRowAndPut(this.rowKeyToBytes(rowKey, WrappedHBTable.getCodecFlags(clazz)), put, clazz);
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValueFromRowAndPut(byte[] rowKeyBytes, Put put, Class<T> clazz) {
        NavigableMap rawMap = put.getFamilyCellMap();
        TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> map = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyNameAndColumnValues : rawMap.entrySet()) {
            byte[] family = (byte[])familyNameAndColumnValues.getKey();
            if (!map.containsKey(family)) {
                map.put(family, new TreeMap(Bytes.BYTES_COMPARATOR));
            }
            List cellList = (List)familyNameAndColumnValues.getValue();
            for (Cell cell : cellList) {
                byte[] column = CellUtil.cloneQualifier((Cell)cell);
                if (!((NavigableMap)map.get(family)).containsKey(column)) {
                    ((NavigableMap)map.get(family)).put(column, new TreeMap());
                }
                ((NavigableMap)((NavigableMap)map.get(family)).get(column)).put(cell.getTimestamp(), CellUtil.cloneValue((Cell)cell));
            }
        }
        return this.convertMapToRecord(rowKeyBytes, map, clazz);
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValueFromPut(Put put, Class<T> clazz) {
        if (put == null || put.isEmpty() || put.getRow() == null || put.getRow().length == 0) {
            return null;
        }
        return this.readValueFromRowAndPut(put.getRow(), put, clazz);
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> T readValue(Put put, Class<T> clazz) {
        this.validateHBClass(clazz);
        return this.readValueFromPut(put, clazz);
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> ImmutableBytesWritable getRowKey(HBRecord<R> record) {
        if (record == null) {
            throw new NullPointerException("Cannot compose row key for null objects");
        }
        this.validateHBClass(record.getClass());
        return new ImmutableBytesWritable(this.composeRowKey(record));
    }

    private <R extends Serializable & Comparable<R>, T extends HBRecord<R>> byte[] composeRowKey(HBRecord<R> record) {
        R rowKey;
        try {
            rowKey = record.composeRowKey();
        }
        catch (Exception ex) {
            throw new RowKeyCantBeComposedException(ex);
        }
        if (rowKey == null || rowKey.toString().isEmpty()) {
            throw new RowKeyCantBeEmptyException();
        }
        WrappedHBTable hbTable = new WrappedHBTable(record.getClass());
        return this.valueToByteArray((Serializable)rowKey, hbTable.getCodecFlags());
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Map<String, Integer> getColumnFamiliesAndVersions(Class<T> clazz) {
        WrappedHBTable<R, T> hbTable = this.validateHBClass(clazz);
        return hbTable.getFamiliesAndVersions();
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> boolean isValid(Class<T> clazz) {
        try {
            this.validateHBClass(clazz);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Map<String, Field> getHBColumnFields(Class<T> clazz) {
        this.validateHBClass(clazz);
        return this.getHBColumnFields0(clazz);
    }

    <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Map<String, Field> getHBColumnFields0(Class<T> clazz) {
        HashMap<String, Field> mappings = new HashMap<String, Field>();
        Class<T> thisClass = clazz;
        while (thisClass != null && thisClass != Object.class) {
            for (Field field : thisClass.getDeclaredFields()) {
                if (!new WrappedHBColumn(field).isPresent()) continue;
                mappings.put(field.getName(), field);
            }
            Class<T> parentClass = thisClass.getSuperclass();
            thisClass = parentClass.isAnnotationPresent(MappedSuperClass.class) ? parentClass : null;
        }
        return mappings;
    }
}

