/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper;

import com.flipkart.hbaseobjectmapper.Flag;
import com.flipkart.hbaseobjectmapper.HBColumn;
import com.flipkart.hbaseobjectmapper.HBColumnMultiVersion;
import com.flipkart.hbaseobjectmapper.exceptions.BothHBColumnAnnotationsPresentException;
import com.flipkart.hbaseobjectmapper.exceptions.DuplicateCodecFlagForColumnException;
import com.flipkart.hbaseobjectmapper.exceptions.FieldNotMappedToHBaseColumnException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;

class WrappedHBColumn {
    private final String family;
    private final String column;
    private final boolean multiVersioned;
    private final boolean singleVersioned;
    private final Class annotationClass;
    private final Map<String, String> codecFlags;
    private final Field field;

    WrappedHBColumn(Field field) {
        this(field, false);
    }

    WrappedHBColumn(Field field, boolean throwExceptionIfNonHBColumn) {
        this.field = field;
        HBColumn hbColumn = field.getAnnotation(HBColumn.class);
        HBColumnMultiVersion hbColumnMultiVersion = field.getAnnotation(HBColumnMultiVersion.class);
        if (hbColumn != null && hbColumnMultiVersion != null) {
            throw new BothHBColumnAnnotationsPresentException(field);
        }
        if (hbColumn != null) {
            this.family = hbColumn.family();
            this.column = hbColumn.column();
            this.singleVersioned = true;
            this.multiVersioned = false;
            this.annotationClass = HBColumn.class;
            this.codecFlags = this.toMap(hbColumn.codecFlags());
        } else if (hbColumnMultiVersion != null) {
            this.family = hbColumnMultiVersion.family();
            this.column = hbColumnMultiVersion.column();
            this.singleVersioned = false;
            this.multiVersioned = true;
            this.annotationClass = HBColumnMultiVersion.class;
            this.codecFlags = this.toMap(hbColumnMultiVersion.codecFlags());
        } else {
            if (throwExceptionIfNonHBColumn) {
                throw new FieldNotMappedToHBaseColumnException(field.getDeclaringClass(), field.getName());
            }
            this.family = null;
            this.column = null;
            this.singleVersioned = false;
            this.multiVersioned = false;
            this.annotationClass = null;
            this.codecFlags = null;
        }
    }

    private Map<String, String> toMap(Flag[] codecFlags) {
        HashMap<String, String> flagsMap = new HashMap<String, String>(codecFlags.length, 1.0f);
        for (Flag flag : codecFlags) {
            String previousValue = flagsMap.put(flag.name(), flag.value());
            if (previousValue == null) continue;
            throw new DuplicateCodecFlagForColumnException(this.field.getDeclaringClass(), this.field.getName(), this.annotationClass, flag.name());
        }
        return flagsMap;
    }

    public String family() {
        return this.family;
    }

    public byte[] familyBytes() {
        return Bytes.toBytes((String)this.family);
    }

    public String column() {
        return this.column;
    }

    public byte[] columnBytes() {
        return Bytes.toBytes((String)this.column);
    }

    public Map<String, String> codecFlags() {
        return this.codecFlags;
    }

    public boolean isPresent() {
        return this.singleVersioned || this.multiVersioned;
    }

    public boolean isMultiVersioned() {
        return this.multiVersioned;
    }

    public boolean isSingleVersioned() {
        return this.singleVersioned;
    }

    public String getName() {
        return this.annotationClass.getName();
    }

    public String toString() {
        return String.format("%s:%s", this.family, this.column);
    }
}

