/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper;

import com.flipkart.hbaseobjectmapper.Family;
import com.flipkart.hbaseobjectmapper.Flag;
import com.flipkart.hbaseobjectmapper.HBRecord;
import com.flipkart.hbaseobjectmapper.HBTable;
import com.flipkart.hbaseobjectmapper.exceptions.DuplicateCodecFlagForRowKeyException;
import com.flipkart.hbaseobjectmapper.exceptions.ImproperHBTableAnnotationExceptions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;

class WrappedHBTable<R extends Serializable & Comparable<R>, T extends HBRecord<R>> {
    private final TableName tableName;
    private final Map<String, Integer> families;
    private final Map<String, String> codecFlags;
    private final Class<T> clazz;

    WrappedHBTable(Class<T> clazz) {
        this.clazz = clazz;
        HBTable hbTable = clazz.getAnnotation(HBTable.class);
        if (hbTable == null) {
            throw new ImproperHBTableAnnotationExceptions.MissingHBTableAnnotationException(String.format("Class %s is missing %s annotation", clazz.getName(), HBTable.class.getSimpleName()));
        }
        if (hbTable.name().isEmpty()) {
            throw new ImproperHBTableAnnotationExceptions.EmptyTableNameOnHBTableAnnotationException(String.format("Annotation %s on class %s has empty name", HBTable.class.getName(), clazz.getName()));
        }
        this.tableName = TableName.valueOf((byte[])hbTable.name().getBytes());
        this.codecFlags = this.toMap(hbTable.rowKeyCodecFlags());
        this.families = new HashMap<String, Integer>(hbTable.families().length, 1.0f);
        for (Family family : hbTable.families()) {
            if (family.name().isEmpty()) {
                throw new ImproperHBTableAnnotationExceptions.EmptyColumnFamilyOnHBTableAnnotationException(String.format("The %s annotation on class %s has a column family with empty name", HBTable.class.getSimpleName(), clazz.getName()));
            }
            if (family.versions() < 1) {
                throw new ImproperHBTableAnnotationExceptions.InvalidValueForVersionsOnHBTableAnnotationException(String.format("The %s annotation on class %s has a column family '%s' which has 'versions' less than 1", HBTable.class.getSimpleName(), clazz.getName(), family.name()));
            }
            Integer prevValue = this.families.put(family.name(), family.versions());
            if (prevValue == null) continue;
            throw new ImproperHBTableAnnotationExceptions.DuplicateColumnFamilyNamesOnHBTableAnnotationException(String.format("The %s annotation on class %s has two or more column families with same name '%s' (Note: column family names must be unique)", HBTable.class.getSimpleName(), clazz.getName(), family.name()));
        }
    }

    private Map<String, String> toMap(Flag[] codecFlags) {
        HashMap<String, String> flagsMap = new HashMap<String, String>(codecFlags.length, 1.0f);
        for (Flag flag : codecFlags) {
            String previousValue = flagsMap.put(flag.name(), flag.value());
            if (previousValue == null) continue;
            throw new DuplicateCodecFlagForRowKeyException(this.clazz, flag.name());
        }
        return flagsMap;
    }

    Map<String, Integer> getFamiliesAndVersions() {
        return this.families;
    }

    boolean isColumnFamilyPresent(String familyName) {
        return this.families.containsKey(familyName);
    }

    TableName getName() {
        return this.tableName;
    }

    public Map<String, String> getCodecFlags() {
        return this.codecFlags;
    }

    public String toString() {
        return this.tableName.getNameAsString();
    }

    static <R extends Serializable & Comparable<R>, T extends HBRecord<R>> Map<String, String> getCodecFlags(Class<T> clazz) {
        return new WrappedHBTable<R, T>(clazz).codecFlags;
    }
}

