/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper.codec;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.hbaseobjectmapper.codec.Codec;
import com.flipkart.hbaseobjectmapper.codec.exceptions.DeserializationException;
import com.flipkart.hbaseobjectmapper.codec.exceptions.SerializationException;
import com.flipkart.hbaseobjectmapper.exceptions.BadHBaseLibStateException;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;

public class BestSuitCodec
implements Codec {
    public static final String SERIALIZE_AS_STRING = "serializeAsString";
    private static final Map<Class, String> fromBytesMethodNames = ImmutableMap.builder().put(Boolean.class, (Object)"toBoolean").put(Short.class, (Object)"toShort").put(Integer.class, (Object)"toInt").put(Long.class, (Object)"toLong").put(Float.class, (Object)"toFloat").put(Double.class, (Object)"toDouble").put(String.class, (Object)"toString").put(BigDecimal.class, (Object)"toBigDecimal").build();
    private static final Map<Class, Class> nativeCounterParts = ImmutableMap.builder().put(Boolean.class, Boolean.TYPE).put(Short.class, Short.TYPE).put(Long.class, Long.TYPE).put(Integer.class, Integer.TYPE).put(Float.class, Float.TYPE).put(Double.class, Double.TYPE).build();
    private static final Map<Class, Method> fromBytesMethods;
    private static final Map<Class, Method> toBytesMethods;
    private static final Map<Class, Constructor> constructors;
    private final ObjectMapper objectMapper;

    public BestSuitCodec(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public BestSuitCodec() {
        this(BestSuitCodec.getObjectMapper());
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    @Override
    public byte[] serialize(Serializable object, Map<String, String> flags) throws SerializationException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (toBytesMethods.containsKey(clazz)) {
            boolean serializeAsString = BestSuitCodec.isSerializeAsStringTrue(flags);
            try {
                Method toBytesMethod = toBytesMethods.get(clazz);
                return serializeAsString ? Bytes.toBytes((String)String.valueOf(object)) : (byte[])toBytesMethod.invoke(null, object);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not serialize value of type %s using HBase's native methods", clazz.getName()), e);
            }
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object to JSON using Jackson", e);
        }
    }

    @Override
    public Serializable deserialize(byte[] bytes, Type type, Map<String, String> flags) throws DeserializationException {
        if (bytes == null) {
            return null;
        }
        if (type instanceof Class && fromBytesMethods.containsKey(type)) {
            boolean serializeAsString = BestSuitCodec.isSerializeAsStringTrue(flags);
            try {
                Serializable value;
                if (serializeAsString) {
                    Constructor constructor = constructors.get(type);
                    value = (Serializable)constructor.newInstance(Bytes.toString((byte[])bytes));
                } else {
                    Method method = fromBytesMethods.get(type);
                    value = (Serializable)method.invoke(null, new Object[]{bytes});
                }
                return value;
            }
            catch (Exception e) {
                throw new DeserializationException("Could not deserialize byte array into an object using HBase's native methods", e);
            }
        }
        JavaType javaType = null;
        try {
            javaType = this.objectMapper.constructType(type);
            return (Serializable)this.objectMapper.readValue(bytes, javaType);
        }
        catch (Exception e) {
            throw new DeserializationException(String.format("Could not deserialize JSON into an object of type %s using Jackson%n(Jackson resolved type = %s)", type, javaType), e);
        }
    }

    @Override
    public boolean canDeserialize(Type type) {
        JavaType javaType = this.objectMapper.constructType(type);
        return this.objectMapper.canDeserialize(javaType);
    }

    private static boolean isSerializeAsStringTrue(Map<String, String> flags) {
        return flags != null && flags.get(SERIALIZE_AS_STRING) != null && flags.get(SERIALIZE_AS_STRING).equalsIgnoreCase("true");
    }

    static {
        try {
            fromBytesMethods = new HashMap<Class, Method>(fromBytesMethodNames.size());
            toBytesMethods = new HashMap<Class, Method>(fromBytesMethodNames.size());
            constructors = new HashMap<Class, Constructor>(fromBytesMethodNames.size());
            for (Map.Entry<Class, String> e : fromBytesMethodNames.entrySet()) {
                Class clazz = e.getKey();
                String toDataTypeMethodName = e.getValue();
                Method fromBytesMethod = Bytes.class.getDeclaredMethod(toDataTypeMethodName, byte[].class);
                Method toBytesMethod = Bytes.class.getDeclaredMethod("toBytes", nativeCounterParts.containsKey(clazz) ? nativeCounterParts.get(clazz) : clazz);
                Constructor constructor = clazz.getConstructor(String.class);
                fromBytesMethods.put(clazz, fromBytesMethod);
                toBytesMethods.put(clazz, toBytesMethod);
                constructors.put(clazz, constructor);
            }
        }
        catch (Exception ex) {
            throw new BadHBaseLibStateException(ex);
        }
    }
}

