/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hbaseobjectmapper.codec;

import com.flipkart.hbaseobjectmapper.codec.Codec;
import com.flipkart.hbaseobjectmapper.codec.exceptions.DeserializationException;
import com.flipkart.hbaseobjectmapper.codec.exceptions.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;

public class JavaObjectStreamCodec
implements Codec {
    @Override
    public byte[] serialize(Serializable object, Map<String, String> flags) throws SerializationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object to byte stream", e);
        }
    }

    @Override
    public Serializable deserialize(byte[] bytes, Type type, Map<String, String> flags) throws DeserializationException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Serializable)ois.readObject();
        }
        catch (Exception e) {
            throw new DeserializationException("Could not deserialize byte array to object", e);
        }
    }

    @Override
    public boolean canDeserialize(Type type) {
        return true;
    }

    public static <T extends Serializable> T deepCopy(T object) {
        JavaObjectStreamCodec codec = new JavaObjectStreamCodec();
        try {
            byte[] bytes = codec.serialize(object, null);
            return (T)codec.deserialize(bytes, object.getClass(), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deep copy: " + object, e);
        }
    }
}

