/*
 * Decompiled with CFR 0.152.
 */
package org.javatuples;

import java.util.Collection;
import java.util.Iterator;
import org.javatuples.Tuple;
import org.javatuples.valueintf.IValueLabel;
import org.javatuples.valueintf.IValueValue;

public final class LabelValue<A, B>
extends Tuple
implements IValueLabel<A>,
IValueValue<B> {
    private static final long serialVersionUID = 5055574980300695706L;
    private static final int SIZE = 2;
    private final A label;
    private final B value;

    public static <A, B> LabelValue<A, B> with(A label, B value) {
        return new LabelValue<A, B>(label, value);
    }

    public static <X> LabelValue<X, X> fromArray(X[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        if (array.length != 2) {
            throw new IllegalArgumentException("Array must have exactly 2 elements in order to create a LabelValue. Size is " + array.length);
        }
        return new LabelValue<X, X>(array[0], array[1]);
    }

    public static <X> LabelValue<X, X> fromCollection(Collection<X> collection) {
        return LabelValue.fromIterable(collection);
    }

    public static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable) {
        return LabelValue.fromIterable(iterable, 0, true);
    }

    public static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable, int index) {
        return LabelValue.fromIterable(iterable, index, false);
    }

    private static <X> LabelValue<X, X> fromIterable(Iterable<X> iterable, int index, boolean exactSize) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable cannot be null");
        }
        boolean tooFewElements = false;
        Object element0 = null;
        Object element1 = null;
        Iterator<X> iter = iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (iter.hasNext()) {
                iter.next();
                continue;
            }
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element0 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element1 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (tooFewElements && exactSize) {
            throw new IllegalArgumentException("Not enough elements for creating a LabelValue (2 needed)");
        }
        if (iter.hasNext() && exactSize) {
            throw new IllegalArgumentException("Iterable must have exactly 2 available elements in order to create a LabelValue.");
        }
        return new LabelValue<Object, Object>(element0, element1);
    }

    public LabelValue(A label, B value) {
        super(label, value);
        this.label = label;
        this.value = value;
    }

    @Override
    public A getLabel() {
        return this.label;
    }

    @Override
    public B getValue() {
        return this.value;
    }

    public static int getSize() {
        return 2;
    }

    public <X> LabelValue<X, B> setLabel(X label) {
        return new LabelValue<X, B>(label, this.value);
    }

    public <Y> LabelValue<A, Y> setValue(Y value) {
        return new LabelValue<A, Y>(this.label, value);
    }
}

