/*
 * checksum-maven-plugin - http://checksum-maven-plugin.nicoulaj.net
 * Copyright © 2010-2017 checksum-maven-plugin contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nicoulaj.maven.plugins.checksum.artifacts;

import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

import java.io.File;
import java.io.IOException;

public class ArtifactAttacher implements ArtifactListener {
    private final MavenProject project;
    private final MavenProjectHelper projectHelper;

    public ArtifactAttacher(MavenProject project, MavenProjectHelper projectHelper) {
        this.project = project;
        this.projectHelper = projectHelper;
    }

    @Override
    public void artifactCreated(File artifact, String type) {

        if (type.startsWith(".")) {
            String originalFileExtension = FileUtils.extension(artifact.getAbsolutePath().replace(type,""));
            // Project helper expects a type without leading dot (e.g. turn ".md5" into "md5").
            type = type.substring(1);
            //System.out.println("sg");
            //System.out.println("type: "+type);
            //System.out.println("originalFileExtension: "+originalFileExtension);
            //System.out.println("artifact: "+artifact.getAbsolutePath());
            /*File modified = new File(artifact.getParentFile(), artifact.getName());
            try {
                FileUtils.copyFile(artifact, modified);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                throw new RuntimeException(e);
            }*/
            projectHelper.attachArtifact(project, originalFileExtension+"."+type, null, artifact);
        } else {
            throw new RuntimeException(type+" "+artifact.getAbsolutePath());
            //projectHelper.attachArtifact(project, type, null, artifact);
        }
    }
}
