/*-
 * ====================================================================
 * checksum-maven-plugin
 * ====================================================================
 * Copyright (C) 2010 - 2016 Julien Nicoulaud <julien.nicoulaud@gmail.com>
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */

package net.nicoulaj.maven.plugins.checksum.execution.target;

import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;

/**
 * Thrown when an error occurs while trying to write to an {@link ExecutionTarget}.
 *
 * @author <a href="mailto:julien.nicoulaud@gmail.com">Julien Nicoulaud</a>
 * @see ExecutionTarget#write(String, ChecksumFile, String)
 * @since 1.0
 */
public class ExecutionTargetWriteException
    extends Exception
{
    /**
     * Build a new instance of {@link ExecutionTargetWriteException}.
     *
     * @param message the message describing the error.
     */
    public ExecutionTargetWriteException( String message )
    {
        super( message );
    }
}
