/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.artifacts;

import java.io.File;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

public class ArtifactAttacher
implements ArtifactListener {
    private final MavenProject project;
    private final MavenProjectHelper projectHelper;

    public ArtifactAttacher(MavenProject project, MavenProjectHelper projectHelper) {
        this.project = project;
        this.projectHelper = projectHelper;
    }

    @Override
    public void artifactCreated(File artifact, String type) {
        if (!type.startsWith(".")) {
            throw new RuntimeException(type + " " + artifact.getAbsolutePath());
        }
        String originalFileExtension = FileUtils.extension((String)artifact.getAbsolutePath().replace(type, ""));
        type = type.substring(1);
        this.projectHelper.attachArtifact(this.project, originalFileExtension + "." + type, null, artifact);
    }
}

