/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.HeaderHelper;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.ssl.SslHandler;

public class SearchGuardSSLTransportService
extends TransportService {
    private final PrincipalExtractor principalExtractor;

    @Inject
    public SearchGuardSSLTransportService(Settings settings, Transport transport, ThreadPool threadPool, PrincipalExtractor principalExtractor) {
        super(settings, transport, threadPool);
        this.principalExtractor = principalExtractor;
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Callable<Request> requestFactory, String executor, TransportRequestHandler<Request> handler) {
        super.registerRequestHandler(action, requestFactory, executor, new Interceptor<Request>(handler, action));
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Callable<Request> requestFactory, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        super.registerRequestHandler(action, requestFactory, executor, forceExecution, canTripCircuitBreaker, new Interceptor<Request>(handler, action));
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Class<Request> request, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        super.registerRequestHandler(action, request, executor, forceExecution, canTripCircuitBreaker, new Interceptor<Request>(handler, action));
    }

    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] certs) throws Exception {
    }

    protected void messageReceivedDecorate(TransportRequest request, TransportRequestHandler handler, TransportChannel transportChannel, Task task) throws Exception {
        handler.messageReceived(request, transportChannel, task);
    }

    protected void errorThrown(Throwable t, TransportRequest request, String action) {
    }

    private class Interceptor<Request extends TransportRequest>
    extends TransportRequestHandler<Request> {
        private final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
        private final TransportRequestHandler<Request> handler;
        private final String action;

        public Interceptor(TransportRequestHandler<Request> handler, String acion) {
            this.handler = handler;
            this.action = acion;
        }

        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            this.messageReceived(request, channel, null);
        }

        public void messageReceived(Request request, TransportChannel transportChannel, Task task) throws Exception {
            HeaderHelper.checkSGHeader(request);
            NettyTransportChannel nettyChannel = null;
            if (transportChannel instanceof DelegatingTransportChannel) {
                TransportChannel delegatingTransportChannel = ((DelegatingTransportChannel)transportChannel).getChannel();
                if (delegatingTransportChannel instanceof NettyTransportChannel) {
                    nettyChannel = (NettyTransportChannel)delegatingTransportChannel;
                }
            } else if (transportChannel instanceof NettyTransportChannel) {
                nettyChannel = (NettyTransportChannel)transportChannel;
            }
            if (nettyChannel == null) {
                SearchGuardSSLTransportService.this.messageReceivedDecorate((TransportRequest)request, (TransportRequestHandler)this.handler, transportChannel, task);
                return;
            }
            try {
                Channel channel = nettyChannel.getChannel();
                SslHandler sslhandler = (SslHandler)channel.getPipeline().get("ssl_server");
                if (sslhandler == null) {
                    String msg = "No ssl handler found (SG 11)";
                    this.log.error("No ssl handler found (SG 11)", new Object[0]);
                    ElasticsearchException exception = new ElasticsearchException("No ssl handler found (SG 11)", new Object[0]);
                    nettyChannel.sendResponse((Throwable)exception);
                    throw exception;
                }
                Certificate[] certs = sslhandler.getEngine().getSession().getPeerCertificates();
                if (certs == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) {
                    String msg = "No X509 transport client certificates found (SG 12)";
                    this.log.error("No X509 transport client certificates found (SG 12)", new Object[0]);
                    ElasticsearchException exception = new ElasticsearchException("No X509 transport client certificates found (SG 12)", new Object[0]);
                    SearchGuardSSLTransportService.this.errorThrown((Throwable)exception, (TransportRequest)request, this.action);
                    nettyChannel.sendResponse((Throwable)exception);
                    throw exception;
                }
                X509Certificate[] x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                SearchGuardSSLTransportService.this.addAdditionalContextValues(this.action, (TransportRequest)request, x509Certs);
                String principal = SearchGuardSSLTransportService.this.principalExtractor.extractPrincipal(x509Certs[0], PrincipalExtractor.Type.TRANSPORT);
                request.putInContext((Object)"_sg_ssl_transport_principal", (Object)principal);
                request.putInContext((Object)"_sg_ssl_transport_peer_certificates", (Object)x509Certs);
                request.putInContext((Object)"_sg_ssl_transport_protocol", (Object)sslhandler.getEngine().getSession().getProtocol());
                request.putInContext((Object)"_sg_ssl_transport_cipher", (Object)sslhandler.getEngine().getSession().getCipherSuite());
                SearchGuardSSLTransportService.this.messageReceivedDecorate((TransportRequest)request, (TransportRequestHandler)this.handler, transportChannel, task);
            }
            catch (SSLPeerUnverifiedException e) {
                this.log.error("Can not verify SSL peer (SG 13) due to {}", (Throwable)e, new Object[]{e});
                SearchGuardSSLTransportService.this.errorThrown(e, (TransportRequest)request, this.action);
                ElasticsearchException exception = ExceptionsHelper.convertToElastic((Throwable)e);
                nettyChannel.sendResponse((Throwable)exception);
                throw exception;
            }
            catch (Exception e) {
                this.log.debug("Unexpected but unproblematic exception (SG 14) for '{}' due to {}", new Object[]{this.action, e.getMessage()});
                SearchGuardSSLTransportService.this.errorThrown(e, (TransportRequest)request, this.action);
                throw e;
            }
        }
    }
}

