/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.ExternalSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardSSLSettingsFilter;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public final class SearchGuardSSLModule
extends AbstractModule {
    private final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final SearchGuardKeyStore sgks;
    private final PrincipalExtractor principalExtractor;

    public SearchGuardSSLModule(Settings settings) {
        this.sgks = ExternalSearchGuardKeyStore.hasExternalSslContext(settings) ? new ExternalSearchGuardKeyStore(settings) : new DefaultSearchGuardKeyStore(settings);
        String principalExtractorClass = settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", new Object[]{principalExtractorClass});
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to {}", (Throwable)e, new Object[]{principalExtractorClass, e.toString()});
                throw new ElasticsearchException((Throwable)e);
            }
        }
    }

    protected void configure() {
        this.bind(SearchGuardSSLSettingsFilter.class).asEagerSingleton();
        this.bind(SearchGuardKeyStore.class).toInstance((Object)this.sgks);
        this.bind(PrincipalExtractor.class).toInstance((Object)this.principalExtractor);
    }
}

