/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class SSLCertificateHelper {
    private static final ESLogger log = Loggers.getLogger(SSLCertificateHelper.class);
    private static boolean stripRootFromChain = true;

    public static X509Certificate[] exportRootCertificates(KeyStore ks, String alias) throws KeyStoreException {
        SSLCertificateHelper.logKeyStore(ks);
        List<String> aliases = SSLCertificateHelper.toList(ks.aliases());
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        if (Strings.isNullOrEmpty((String)alias)) {
            if (log.isDebugEnabled()) {
                log.debug("No alias given, will trust all of the certificates in the store", new Object[0]);
            }
            for (String _alias : aliases) {
                if (!ks.isCertificateEntry(_alias)) continue;
                X509Certificate cert = (X509Certificate)ks.getCertificate(_alias);
                if (cert != null) {
                    trustedCerts.add(cert);
                    continue;
                }
                log.error("Alias {} does not exist", new Object[]{_alias});
            }
        } else if (ks.isCertificateEntry(alias)) {
            X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
            if (cert != null) {
                trustedCerts.add(cert);
            } else {
                log.error("Alias {} does not exist", new Object[]{alias});
            }
        } else {
            log.error("Alias {} does not contain hold a certificate entry", new Object[]{alias});
        }
        return trustedCerts.toArray(new X509Certificate[0]);
    }

    public static X509Certificate[] exportServerCertChain(KeyStore ks, String alias) throws KeyStoreException {
        Certificate[] certs;
        SSLCertificateHelper.logKeyStore(ks);
        List<String> aliases = SSLCertificateHelper.toList(ks.aliases());
        if (Strings.isNullOrEmpty((String)alias)) {
            if (aliases.isEmpty()) {
                log.error("Keystore does not contain any aliases", new Object[0]);
            } else {
                alias = aliases.get(0);
                log.info("No alias given, use the firs one: {}", new Object[]{alias});
            }
        }
        if ((certs = ks.getCertificateChain(alias)) != null && certs.length > 0) {
            X509Certificate[] x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
            X509Certificate lastCertificate = x509Certs[x509Certs.length - 1];
            if (lastCertificate.getBasicConstraints() > -1 && lastCertificate.getSubjectX500Principal().equals(lastCertificate.getIssuerX500Principal())) {
                log.warn("Certificate chain for alias {} contains a root certificate", new Object[]{alias});
                if (stripRootFromChain) {
                    x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length - 1, X509Certificate[].class);
                }
            }
            return x509Certs;
        }
        log.error("Alias {} does not exists or contain hold a certificate chain", new Object[]{alias});
        return new X509Certificate[0];
    }

    public static PrivateKey exportDecryptedKey(KeyStore ks, String alias, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        SSLCertificateHelper.logKeyStore(ks);
        List<String> aliases = SSLCertificateHelper.toList(ks.aliases());
        String evaluatedAlias = alias;
        if (alias == null && aliases.size() > 0) {
            evaluatedAlias = aliases.get(0);
        }
        if (evaluatedAlias == null) {
            throw new KeyStoreException("null alias, current aliases: " + aliases);
        }
        Key key = ks.getKey(evaluatedAlias, password == null || password.length == 0 ? null : password);
        if (key == null) {
            throw new KeyStoreException("no key alias named " + evaluatedAlias);
        }
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    private static void logKeyStore(KeyStore ks) {
        try {
            List<String> aliases = SSLCertificateHelper.toList(ks.aliases());
            if (log.isDebugEnabled()) {
                log.debug("Keystore has {} entries/aliases", new Object[]{ks.size()});
                for (String _alias : aliases) {
                    X509Certificate cert;
                    log.debug("Alias {}: is a certificate entry?{}/is a key entry?{}", new Object[]{_alias, ks.isCertificateEntry(_alias), ks.isKeyEntry(_alias)});
                    Certificate[] certs = ks.getCertificateChain(_alias);
                    if (certs != null) {
                        log.debug("Alias {}: chain len {}", new Object[]{_alias, certs.length});
                        for (int i = 0; i < certs.length; ++i) {
                            X509Certificate certificate = (X509Certificate)certs[i];
                            log.debug("cert {} of type {} -> {}", new Object[]{certificate.getSubjectX500Principal(), certificate.getBasicConstraints(), certificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())});
                        }
                    }
                    if ((cert = (X509Certificate)ks.getCertificate(_alias)) == null) continue;
                    log.debug("Alias {}: single cert {} of type {} -> {}", new Object[]{_alias, cert.getSubjectX500Principal(), cert.getBasicConstraints(), cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal())});
                }
            }
        }
        catch (Exception e) {
            log.error("Error logging keystore " + e + " {}", new Object[]{ExceptionsHelper.stackTrace((Throwable)e)});
        }
    }

    private static List<String> toList(Enumeration<String> enumeration) {
        ArrayList<String> aliases = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            aliases.add(enumeration.nextElement());
        }
        return Collections.unmodifiableList(aliases);
    }
}

