/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.rest;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import io.netty.handler.ssl.OpenSsl;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardSSLInfoAction
extends BaseRestHandler {
    private final SearchGuardKeyStore sgks;

    @Inject
    public SearchGuardSSLInfoAction(Settings settings, RestController controller, ThreadPool threadPool, SearchGuardKeyStore sgks) {
        super(settings);
        this.sgks = sgks;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/sslinfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BytesRestResponse response = null;
        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(request);
            X509Certificate[] certs = sslInfo.getX509Certs();
            builder.startObject();
            builder.field("principal", sslInfo.getPrincipal());
            builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
            builder.field("ssl_protocol", sslInfo.getProtocol());
            builder.field("ssl_cipher", sslInfo.getCipher());
            builder.field("ssl_openssl_available", OpenSsl.isAvailable());
            builder.field("ssl_openssl_version", OpenSsl.version());
            builder.field("ssl_openssl_version_string", OpenSsl.versionString());
            Throwable openSslUnavailCause = OpenSsl.unavailabilityCause();
            builder.field("ssl_openssl_non_available_cause", openSslUnavailCause == null ? "" : openSslUnavailCause.toString());
            builder.field("ssl_openssl_supports_key_manager_factory", OpenSsl.supportsKeyManagerFactory());
            builder.field("ssl_provider_http", (Object)this.sgks.sslHTTPProvider);
            builder.field("ssl_provider_transport_server", (Object)this.sgks.sslTransportServerProvider);
            builder.field("ssl_provider_transport_client", (Object)this.sgks.sslTransportClientProvider);
            builder.endObject();
            response = new BytesRestResponse(RestStatus.OK, builder);
        }
        catch (Exception e1) {
            this.logger.error("Error handle request " + e1, (Throwable)e1);
            builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
            builder.startObject();
            builder.field("error", e1.toString());
            builder.endObject();
            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
        }
        BytesRestResponse finalResponse = response;
        return channel -> channel.sendResponse((RestResponse)finalResponse);
    }
}

