/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.ExternalSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;

public final class SearchGuardSSLModule
extends AbstractModule {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final SearchGuardKeyStore sgks;
    private final PrincipalExtractor principalExtractor;

    public SearchGuardSSLModule(Settings settings, SearchGuardKeyStore sgks) {
        this.sgks = ExternalSearchGuardKeyStore.hasExternalSslContext(settings) ? new ExternalSearchGuardKeyStore(settings) : new DefaultSearchGuardKeyStore(settings);
        String principalExtractorClass = settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to {}", (Object)e, (Object)principalExtractorClass, (Object)e.toString());
                throw new ElasticsearchException((Throwable)e);
            }
        }
    }

    protected void configure() {
        this.bind(SearchGuardKeyStore.class).toInstance((Object)this.sgks);
        this.bind(PrincipalExtractor.class).toInstance((Object)this.principalExtractor);
    }
}

