/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;

public class SSLCertificateHelper {
    private static final Logger log = LogManager.getLogger(SSLCertificateHelper.class);

    public static X509Certificate[] exportCertificateChain(KeyStore ks, String alias) throws KeyStoreException {
        Enumeration<String> e = ks.aliases();
        ArrayList<String> aliases = new ArrayList<String>();
        while (e.hasMoreElements()) {
            aliases.add(e.nextElement());
        }
        if (log.isDebugEnabled()) {
            log.debug("Keystore has {} entries/aliases", (Object)ks.size());
            for (String string : aliases) {
                log.debug("Alias {}: is a certificate entry?{}/is a key entry?{}", (Object)string, (Object)ks.isCertificateEntry(string), (Object)ks.isKeyEntry(string));
            }
        }
        ArrayList<Certificate> trustedCerts = new ArrayList<Certificate>();
        if (Strings.isNullOrEmpty((String)alias)) {
            log.debug("No alias given, will trust all of the certificates in the store");
            for (String _alias : aliases) {
                Certificate[] certs = ks.getCertificateChain(_alias);
                if (certs != null && certs.length > 0) {
                    trustedCerts.addAll(Arrays.asList(certs));
                    continue;
                }
                Certificate cert = ks.getCertificate(_alias);
                if (cert == null) continue;
                trustedCerts.add(cert);
            }
        } else {
            Certificate[] certificateArray = ks.getCertificateChain(alias);
            if (certificateArray != null && certificateArray.length > 0) {
                trustedCerts.addAll(Arrays.asList(certificateArray));
            } else {
                Certificate cert = ks.getCertificate(alias);
                if (cert != null) {
                    trustedCerts.add(cert);
                }
            }
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(trustedCerts.size());
        for (Certificate c : trustedCerts) {
            if (c != null && c instanceof X509Certificate) {
                arrayList.add((X509Certificate)c);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("No X509 Certificate or null certificate: {}", (Object)c);
        }
        if (arrayList.isEmpty()) {
            throw new KeyStoreException("no certificate chain or certificate with alias: " + alias);
        }
        return trustedCerts.toArray(new X509Certificate[0]);
    }

    public static PrivateKey exportDecryptedKey(KeyStore ks, String alias, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Enumeration<String> e = ks.aliases();
        ArrayList<String> aliases = new ArrayList<String>();
        while (e.hasMoreElements()) {
            aliases.add(e.nextElement());
        }
        String evaluatedAlias = alias;
        if (alias == null && aliases.size() > 0) {
            evaluatedAlias = (String)aliases.get(0);
        }
        if (evaluatedAlias == null) {
            throw new KeyStoreException("null alias, current aliases: " + aliases);
        }
        Key key = ks.getKey(evaluatedAlias, password == null || password.length == 0 ? null : password);
        if (key == null) {
            throw new KeyStoreException("no key alias named " + evaluatedAlias);
        }
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }
}

