/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.Netty4Transport;

public class SearchGuardSSLNettyTransport
extends Netty4Transport {
    private final SearchGuardKeyStore sgks;

    public SearchGuardSSLNettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SearchGuardKeyStore sgks) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.sgks = sgks;
    }

    protected void onException(Channel channel, Exception e) throws IOException {
        if (this.lifecycle.started()) {
            Throwable cause = e.getCause();
            if (cause instanceof NotSslRecordException) {
                this.logger.warn("Someone ({}) speaks transport plaintext instead of ssl, will close the channel", (Object)channel.remoteAddress());
                this.disconnectFromNodeChannel(channel, e);
                return;
            }
            if (cause instanceof SSLException) {
                this.logger.error("SSL Problem " + cause.getMessage(), cause);
                this.disconnectFromNodeChannel(channel, e);
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                this.logger.error("Problem during handshake " + cause.getMessage());
                this.disconnectFromNodeChannel(channel, e);
                return;
            }
        }
        super.onException((Object)channel, e);
    }

    protected ChannelHandler getServerChannelInitializer(String name, Settings remoteAddress) {
        return new SSLServerChannelInitializer(name, remoteAddress);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new SSLClientChannelInitializer();
    }

    protected class SSLClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;

        public SSLClientChannelInitializer() {
            super((Netty4Transport)SearchGuardSSLNettyTransport.this);
            this.hostnameVerificationEnabled = SearchGuardSSLNettyTransport.this.settings.getAsBoolean("searchguard.ssl.transport.enforce_hostname_verification", Boolean.valueOf(true));
            this.hostnameVerificationResovleHostName = SearchGuardSSLNettyTransport.this.settings.getAsBoolean("searchguard.ssl.transport.resolve_hostname", Boolean.valueOf(true));
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            ch.pipeline().addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(SearchGuardSSLNettyTransport.this.sgks, this.hostnameVerificationEnabled, this.hostnameVerificationResovleHostName));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SearchGuardSSLNettyTransport.this.lifecycle.started()) {
                if (cause instanceof NotSslRecordException) {
                    SearchGuardSSLNettyTransport.this.logger.warn("Someone ({}) speaks transport plaintext instead of ssl, will close the channel", (Object)ctx.channel().remoteAddress());
                    ctx.channel().close();
                    return;
                }
                if (cause instanceof SSLException) {
                    SearchGuardSSLNettyTransport.this.logger.error("SSL Problem " + cause.getMessage(), cause);
                    ctx.channel().close();
                    return;
                }
                if (cause instanceof SSLHandshakeException) {
                    SearchGuardSSLNettyTransport.this.logger.error("Problem during handshake " + cause.getMessage());
                    ctx.channel().close();
                    return;
                }
            }
            super.exceptionCaught(ctx, cause);
        }
    }

    protected static class ClientSSLHandler
    extends ChannelOutboundHandlerAdapter {
        private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final SearchGuardKeyStore sgks;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;

        private ClientSSLHandler(SearchGuardKeyStore sgks, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName) {
            this.sgks = sgks;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine engine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    String hostname = null;
                    hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} ({}/{}) with hostnameVerificationResovleHostName: {}", (Object)hostname, (Object)inetSocketAddress.getHostName(), (Object)inetSocketAddress.getHostString(), (Object)this.hostnameVerificationResovleHostName);
                    }
                    engine = this.sgks.createClientTransportSSLEngine(hostname, inetSocketAddress.getPort());
                } else {
                    engine = this.sgks.createClientTransportSSLEngine(null, -1);
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
            SslHandler sslHandler = new SslHandler(engine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    protected class SSLServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        public SSLServerChannelInitializer(String name, Settings profileSettings) {
            super((Netty4Transport)SearchGuardSSLNettyTransport.this, name, profileSettings);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyTransport.this.sgks.createServerTransportSSLEngine());
            ch.pipeline().addFirst("ssl_server", (ChannelHandler)sslHandler);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SearchGuardSSLNettyTransport.this.lifecycle.started()) {
                if (cause instanceof NotSslRecordException) {
                    SearchGuardSSLNettyTransport.this.logger.warn("Someone ({}) speaks transport plaintext instead of ssl, will close the channel", (Object)ctx.channel().remoteAddress());
                    ctx.channel().close();
                    return;
                }
                if (cause instanceof SSLException) {
                    SearchGuardSSLNettyTransport.this.logger.error("SSL Problem " + cause.getMessage(), cause);
                    ctx.channel().close();
                    return;
                }
                if (cause instanceof SSLHandshakeException) {
                    SearchGuardSSLNettyTransport.this.logger.error("Problem during handshake " + cause.getMessage());
                    ctx.channel().close();
                    return;
                }
            }
            super.exceptionCaught(ctx, cause);
        }
    }
}

