/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util;

import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.rest.RestRequest;

public class SSLRequestHelper {
    public static SSLInfo getSSLInfo(RestRequest request, PrincipalExtractor principalExtractor) throws SSLPeerUnverifiedException {
        String principal;
        String cipher;
        String protocol;
        X509Certificate[] x509Certs;
        block8: {
            if (request == null || !(request instanceof Netty4HttpRequest)) {
                return null;
            }
            Netty4HttpRequest nettyHttpRequest = (Netty4HttpRequest)request;
            SslHandler sslhandler = (SslHandler)nettyHttpRequest.getChannel().pipeline().get("ssl_http");
            if (sslhandler == null) {
                return null;
            }
            SSLEngine engine = sslhandler.engine();
            SSLSession session = engine.getSession();
            x509Certs = null;
            protocol = session.getProtocol();
            cipher = session.getCipherSuite();
            principal = null;
            if (engine.getNeedClientAuth() || engine.getWantClientAuth()) {
                try {
                    Certificate[] certs = session.getPeerCertificates();
                    if (certs != null && certs.length > 0 && certs[0] instanceof X509Certificate) {
                        x509Certs = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                        principal = principalExtractor == null ? null : principalExtractor.extractPrincipal(x509Certs[0], PrincipalExtractor.Type.HTTP);
                    } else if (engine.getNeedClientAuth()) {
                        ElasticsearchException ex = new ElasticsearchException("No client certificates found but such are needed (SG 9).", new Object[0]);
                        throw ex;
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!engine.getNeedClientAuth()) break block8;
                    throw e;
                }
            }
        }
        return new SSLInfo(x509Certs, principal, protocol, cipher);
    }

    public static boolean containsBadHeader(ThreadContext context, String prefix) {
        if (context != null) {
            for (Map.Entry header : context.getHeaders().entrySet()) {
                if (header == null || header.getKey() == null || !((String)header.getKey()).trim().toLowerCase().startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static class SSLInfo {
        private final X509Certificate[] x509Certs;
        private final String principal;
        private final String protocol;
        private final String cipher;

        public SSLInfo(X509Certificate[] x509Certs, String principal, String protocol, String cipher) {
            this.x509Certs = x509Certs;
            this.principal = principal;
            this.protocol = protocol;
            this.cipher = cipher;
        }

        public X509Certificate[] getX509Certs() {
            return this.x509Certs == null ? null : (X509Certificate[])this.x509Certs.clone();
        }

        public String getPrincipal() {
            return this.principal;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getCipher() {
            return this.cipher;
        }

        public String toString() {
            return "SSLInfo [x509Certs=" + Arrays.toString(this.x509Certs) + ", principal=" + this.principal + ", protocol=" + this.protocol + ", cipher=" + this.cipher + "]";
        }
    }
}

