/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.ExternalSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import com.floragunn.searchguard.ssl.rest.SearchGuardSSLInfoAction;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLNettyTransport;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLTransportInterceptor;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.watcher.ResourceWatcherService;

public final class SearchGuardSSLPlugin
extends Plugin
implements ActionPlugin,
NetworkPlugin {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    static final String CLIENT_TYPE = "client.type";
    private final boolean client;
    private final boolean httpSSLEnabled;
    private final boolean transportSSLEnabled;
    private final Settings settings;
    private final SearchGuardKeyStore sgks;
    private PrincipalExtractor principalExtractor;

    public SearchGuardSSLPlugin(Settings settings) {
        String rejectClientInitiatedRenegotiation = System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation");
        if (!Boolean.parseBoolean(rejectClientInitiatedRenegotiation)) {
            this.log.info("Consider setting -Djdk.tls.rejectClientInitiatedRenegotiation=true to prevent DoS attacks through client side initiated TLS renegotiation.");
        } else {
            this.log.debug("Client side initiated TLS renegotiation disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation is true).");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE));
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true));
        if (!this.httpSSLEnabled && !this.transportSSLEnabled) {
            this.log.error("SSL not activated for http and/or transport.");
            System.out.println("SSL not activated for http and/or transport.");
        }
        this.sgks = ExternalSearchGuardKeyStore.hasExternalSslContext(settings) ? new ExternalSearchGuardKeyStore(settings) : new DefaultSearchGuardKeyStore(settings);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>(1);
        if (!this.client && this.httpSSLEnabled) {
            ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings);
            SearchGuardSSLNettyHttpServerTransport sgsnht = new SearchGuardSSLNettyHttpServerTransport(settings, networkService, bigArrays, threadPool, this.sgks, xContentRegistry, validatingDispatcher);
            validatingDispatcher.setAuditErrorHandler(sgsnht);
            httpTransports.put("com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport", () -> sgsnht);
        }
        return httpTransports;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client) {
            handlers.add((RestHandler)new SearchGuardSSLInfoAction(settings, restController, this.sgks, Objects.requireNonNull(this.principalExtractor)));
        }
        return handlers;
    }

    public List<TransportInterceptor> getTransportInterceptors(ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (this.transportSSLEnabled && !this.client) {
            interceptors.add(new SearchGuardSSLTransportInterceptor(this.settings, null, null));
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.transportSSLEnabled) {
            transports.put("com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport", () -> new SearchGuardSSLNettyTransport(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService, this.sgks));
        }
        return transports;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        ArrayList<Object> components = new ArrayList<Object>(1);
        String principalExtractorClass = this.settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to {}", (Object)e, (Object)principalExtractorClass, (Object)e.toString());
                throw new ElasticsearchException((Throwable)e);
            }
        }
        components.add(this.principalExtractor);
        return components;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.enable_openssl_if_available", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enable_openssl_if_available", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.enabled_ciphers", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.enabled_protocols", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.enabled_ciphers", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.enabled_protocols", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"searchguard.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"node.client", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"node.local", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        return settings;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        if (!this.client && this.httpSSLEnabled) {
            builder.put("http.type", "com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport");
        }
        if (this.transportSSLEnabled) {
            builder.put("transport.type", "com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport");
        }
        return builder.build();
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        settingsFilter.add("searchguard.*");
        return settingsFilter;
    }
}

