/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.http.netty.AuditErrorHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardSSLNettyHttpServerTransport
extends Netty4HttpServerTransport
implements AuditErrorHandler {
    private final SearchGuardKeyStore sgks;
    private final ThreadContext threadContext;

    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, (HttpServerTransport.Dispatcher)dispatcher);
        this.sgks = sgks;
        this.threadContext = threadPool.getThreadContext();
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.sgks);
    }

    @Override
    public final void logError(Throwable t, RestRequest request) {
        this.errorThrown(t, request);
    }

    protected void errorThrown(Throwable t, RestRequest request) {
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, SearchGuardKeyStore sgks) {
            super(transport, SearchGuardSSLNettyHttpServerTransport.this.detailedErrorsEnabled, SearchGuardSSLNettyHttpServerTransport.this.threadContext);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyHttpServerTransport.this.sgks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

