/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util;

import org.elasticsearch.ElasticsearchException;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        return ExceptionUtils.getRootCause(cause);
    }

    public static Throwable findMsg(Throwable e, String msg) {
        if (e == null) {
            return null;
        }
        if (e.getMessage() != null && e.getMessage().contains(msg)) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return null;
        }
        return ExceptionUtils.findMsg(cause, msg);
    }

    public static ElasticsearchException createBadHeaderException() {
        return new ElasticsearchException("bad header found. This means typically that one node try to connect to another with a non-node certificate (no OID or searchguard.nodes_dn incorrect configured) or that someoneis spoofing requests. See https://github.com/floragunncom/search-guard-docs/blob/master/tls_node_certificates.md", new Object[0]);
    }
}

