/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import sun.security.x509.X500Name;

public class DefaultPrincipalExtractor
implements PrincipalExtractor {
    private static final String EMAILADDRESS = "EMAILADDRESS";
    private static final String EMAILADDRESS_KEY = "EMAILADDRESS=";
    private static final String MAIL_OID = "1.2.840.113549.1.9.1";
    private static final int MAIL_OID_TOKEN_LEN = "1.2.840.113549.1.9.1".length() + 1;
    protected final Logger log = LogManager.getLogger(this.getClass());

    @Override
    public String extractPrincipal(X509Certificate x509Certificate, PrincipalExtractor.Type type) {
        if (x509Certificate == null) {
            return null;
        }
        final X500Principal principal = x509Certificate.getSubjectX500Principal();
        if (principal != null) {
            String retval = principal.getName();
            int indexMailStart = retval.indexOf("1.2.840.113549.1.9.1=");
            if (indexMailStart > -1) {
                String dnString;
                int nmStart;
                int mailTokenLen = 13;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                if ((nmStart = (dnString = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return X500Name.asX500Name(principal).toString();
                    }
                })).toUpperCase().indexOf(EMAILADDRESS_KEY)) == -1) {
                    this.log.error("Cannot find {} token in {}", (Object)EMAILADDRESS_KEY, (Object)dnString.toUpperCase());
                    return retval;
                }
                String oldMail = retval.substring(indexMailStart + MAIL_OID_TOKEN_LEN, retval.indexOf(44, indexMailStart + MAIL_OID_TOKEN_LEN));
                String newMail = dnString.substring(nmStart + mailTokenLen, dnString.indexOf(44, nmStart + mailTokenLen));
                retval = retval.replaceFirst(oldMail, newMail);
                retval = retval.replaceFirst(MAIL_OID, EMAILADDRESS);
            }
            return retval;
        }
        return null;
    }
}

