/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.rest;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import io.netty.handler.ssl.OpenSsl;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardSSLInfoAction
extends BaseRestHandler {
    private final SearchGuardKeyStore sgks;
    final PrincipalExtractor principalExtractor;
    private final Path configPath;

    public SearchGuardSSLInfoAction(Settings settings, Path configPath, RestController controller, SearchGuardKeyStore sgks, PrincipalExtractor principalExtractor) {
        super(settings);
        this.sgks = sgks;
        this.principalExtractor = principalExtractor;
        this.configPath = configPath;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/sslinfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final Boolean showDn;
            {
                this.showDn = request.paramAsBoolean("show_dn", Boolean.FALSE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(SearchGuardSSLInfoAction.this.settings, SearchGuardSSLInfoAction.this.configPath, request, SearchGuardSSLInfoAction.this.principalExtractor);
                    X509Certificate[] certs = sslInfo == null ? null : sslInfo.getX509Certs();
                    X509Certificate[] localCerts = sslInfo == null ? null : sslInfo.getLocalCertificates();
                    builder.startObject();
                    builder.field("principal", sslInfo == null ? null : sslInfo.getPrincipal());
                    builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
                    if (this.showDn == Boolean.TRUE) {
                        builder.field("peer_certificates_list", certs == null ? null : (Iterable)Arrays.stream(certs).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                        builder.field("local_certificates_list", localCerts == null ? null : (Iterable)Arrays.stream(localCerts).map(c -> c.getSubjectDN().getName()).collect(Collectors.toList()));
                    }
                    builder.field("ssl_protocol", sslInfo == null ? null : sslInfo.getProtocol());
                    builder.field("ssl_cipher", sslInfo == null ? null : sslInfo.getCipher());
                    builder.field("ssl_openssl_available", OpenSsl.isAvailable());
                    builder.field("ssl_openssl_version", OpenSsl.version());
                    builder.field("ssl_openssl_version_string", OpenSsl.versionString());
                    Throwable openSslUnavailCause = OpenSsl.unavailabilityCause();
                    builder.field("ssl_openssl_non_available_cause", openSslUnavailCause == null ? "" : openSslUnavailCause.toString());
                    builder.field("ssl_openssl_supports_key_manager_factory", OpenSsl.supportsKeyManagerFactory());
                    builder.field("ssl_openssl_supports_hostname_validation", OpenSsl.supportsHostnameValidation());
                    builder.field("ssl_provider_http", SearchGuardSSLInfoAction.this.sgks.getHTTPProviderName());
                    builder.field("ssl_provider_transport_server", SearchGuardSSLInfoAction.this.sgks.getTransportServerProviderName());
                    builder.field("ssl_provider_transport_client", SearchGuardSSLInfoAction.this.sgks.getTransportClientProviderName());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Search Guard SSL Info";
    }

    static /* synthetic */ Logger access$300(SearchGuardSSLInfoAction x0) {
        return x0.logger;
    }
}

