/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http.netty;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardSSLNettyHttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SearchGuardSSLNettyHttpServerTransport.class);
    private final SearchGuardKeyStore sgks;
    private final SslExceptionHandler errorHandler;

    public SearchGuardSSLNettyHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher, SslExceptionHandler errorHandler) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, (HttpServerTransport.Dispatcher)dispatcher);
        this.sgks = sgks;
        this.errorHandler = errorHandler;
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHttpChannelHandler(this, this.handlingSettings, this.sgks);
    }

    protected void onException(HttpChannel channel, Exception cause0) {
        if (this.lifecycle.started()) {
            Throwable cause = cause0;
            if (cause0 instanceof DecoderException && cause0 != null) {
                cause = cause0.getCause();
            }
            this.errorHandler.logError(cause, true);
            if (cause instanceof NotSslRecordException) {
                logger.warn("Someone ({}) speaks http plaintext instead of ssl, will close the channel", (Object)channel.getRemoteAddress());
                channel.close();
                return;
            }
            if (cause instanceof SSLException) {
                logger.error("SSL Problem " + cause.getMessage(), cause);
                channel.close();
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                logger.error("Problem during handshake " + cause.getMessage());
                channel.close();
                return;
            }
        }
        super.onException(channel, cause0);
    }

    protected class SSLHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SSLHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings, SearchGuardKeyStore sgks) {
            super(transport, handlingSettings);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SslHandler sslHandler = new SslHandler(SearchGuardSSLNettyHttpServerTransport.this.sgks.createHTTPSSLEngine());
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

