/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.template;

import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.ProcessListener;
import com.floreysoft.jmte.ScopedMap;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.template.AbstractTemplate;
import com.floreysoft.jmte.token.ElseToken;
import com.floreysoft.jmte.token.EndToken;
import com.floreysoft.jmte.token.ExpressionToken;
import com.floreysoft.jmte.token.ForEachToken;
import com.floreysoft.jmte.token.IfToken;
import com.floreysoft.jmte.token.InvalidToken;
import com.floreysoft.jmte.token.PlainTextToken;
import com.floreysoft.jmte.token.StringToken;
import com.floreysoft.jmte.token.Token;
import com.floreysoft.jmte.token.TokenStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InterpretedTemplate
extends AbstractTemplate {
    protected final TokenStream tokenStream;
    protected transient StringBuilder output;
    protected transient TemplateContext context;

    public InterpretedTemplate(String template, String sourceName, Engine engine) {
        this.template = template;
        this.engine = engine;
        this.sourceName = sourceName;
        this.tokenStream = new TokenStream(sourceName, template, engine.getExprStartToken(), engine.getExprEndToken());
        this.tokenStream.prefill();
    }

    @Override
    public synchronized Set<String> getUsedVariables() {
        if (this.usedVariables != null) {
            return this.usedVariables;
        }
        this.usedVariables = new TreeSet();
        Engine engine = new Engine();
        ScopedMap scopedMap = new ScopedMap(Collections.EMPTY_MAP);
        ProcessListener processListener = new ProcessListener(){

            @Override
            public void log(TemplateContext context, Token token, ProcessListener.Action action) {
                String variable;
                if (token instanceof ExpressionToken && !this.isLocal(variable = ((ExpressionToken)token).getExpression())) {
                    InterpretedTemplate.this.usedVariables.add(variable);
                }
            }

            private boolean isLocal(String variable) {
                for (Token token : InterpretedTemplate.this.context.scopes) {
                    String foreachVarName;
                    if (!(token instanceof ForEachToken) || !(foreachVarName = ((ForEachToken)token).getVarName()).equals(variable)) continue;
                    return true;
                }
                return false;
            }
        };
        Locale locale = Locale.getDefault();
        this.context = new TemplateContext(this.template, locale, this.sourceName, scopedMap, new DefaultModelAdaptor(), engine, engine.getErrorHandler(), processListener);
        this.transformPure(this.context);
        return this.usedVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String transform(Map<String, Object> model, Locale locale, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        try {
            String transformed;
            this.context = new TemplateContext(this.template, locale, this.sourceName, new ScopedMap(model), modelAdaptor, this.engine, this.engine.getErrorHandler(), processListener);
            String string = transformed = this.transformPure(this.context);
            return string;
        }
        finally {
            this.context = null;
            this.output = null;
        }
    }

    protected String transformPure(TemplateContext context) {
        this.tokenStream.reset();
        this.output = new StringBuilder((int)((double)context.template.length() * context.engine.getExpansionSizeFactor()));
        this.tokenStream.nextToken();
        while (this.tokenStream.currentToken() != null) {
            this.content(false);
        }
        return this.output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void foreach(boolean inheritedSkip) {
        ForEachToken feToken = (ForEachToken)this.tokenStream.currentToken();
        Iterable iterable = (Iterable)feToken.evaluate(this.context);
        feToken.setIterator(iterable.iterator());
        this.tokenStream.consume();
        this.context.model.enterScope();
        this.context.push(feToken);
        try {
            if (inheritedSkip || !feToken.iterator().hasNext()) {
                Token contentToken;
                while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                    this.content(true);
                }
                if (contentToken == null) {
                    this.engine.getErrorHandler().error("missing-end", feToken);
                } else {
                    this.tokenStream.consume();
                    this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
                }
            } else {
                while (feToken.iterator().hasNext()) {
                    Token contentToken;
                    this.context.model.put(feToken.getVarName(), feToken.advance());
                    this.addSpecialVariables(feToken, this.context.model);
                    this.tokenStream.rewind(feToken);
                    while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                        this.content(false);
                    }
                    if (contentToken == null) {
                        this.engine.getErrorHandler().error("missing-end", feToken);
                    } else {
                        this.tokenStream.consume();
                        this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
                    }
                    if (feToken.isLast()) continue;
                    this.output.append(feToken.getSeparator());
                }
            }
        }
        finally {
            this.context.model.exitScope();
            this.context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void condition(boolean inheritedSkip) {
        IfToken ifToken = (IfToken)this.tokenStream.currentToken();
        this.tokenStream.consume();
        this.context.push(ifToken);
        try {
            Token contentToken;
            boolean localSkip;
            if (inheritedSkip) {
                localSkip = true;
            } else {
                boolean bl = localSkip = (Boolean)ifToken.evaluate(this.context) == false;
            }
            while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken) && !(contentToken instanceof ElseToken)) {
                this.content(localSkip);
            }
            if (contentToken instanceof ElseToken) {
                this.tokenStream.consume();
                if (!inheritedSkip) {
                    localSkip = !localSkip;
                }
                this.context.notifyProcessListener(contentToken, inheritedSkip ? ProcessListener.Action.SKIP : ProcessListener.Action.EVAL);
                while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                    this.content(localSkip);
                }
            }
            if (contentToken == null) {
                this.engine.getErrorHandler().error("missing-end", ifToken);
            } else {
                this.tokenStream.consume();
                this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
            }
        }
        finally {
            this.context.pop();
        }
    }

    private void content(boolean skip) {
        Token token = this.tokenStream.currentToken();
        this.context.notifyProcessListener(token, skip ? ProcessListener.Action.SKIP : ProcessListener.Action.EVAL);
        if (token instanceof PlainTextToken) {
            this.tokenStream.consume();
            if (!skip) {
                this.output.append(token.getText());
            }
        } else if (token instanceof StringToken) {
            this.tokenStream.consume();
            if (!skip) {
                String expanded = (String)token.evaluate(this.context);
                this.output.append(expanded);
            }
        } else if (token instanceof ForEachToken) {
            this.foreach(skip);
        } else if (token instanceof IfToken) {
            this.condition(skip);
        } else if (token instanceof ElseToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("else-out-of-scope", token);
        } else if (token instanceof EndToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("unmatched-end", token);
        } else if (token instanceof InvalidToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("invalid-expression", token);
        } else {
            this.tokenStream.consume();
            String evaluated = (String)token.evaluate(this.context);
            this.output.append(evaluated);
        }
    }

    public String toString() {
        return this.template;
    }
}

