/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte;

import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.ModelBuilder;
import com.floreysoft.jmte.Processor;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.message.NoLogErrorHandler;
import com.floreysoft.jmte.token.InvalidToken;
import com.floreysoft.jmte.token.Token;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DefaultModelAdaptor
implements ModelAdaptor {
    protected Map<Class<?>, Map<String, Member>> cache = new HashMap();

    public Object getValue(Map<String, Object> model, String expression) {
        String[] split = expression.split("\\.");
        List<String> segments = Arrays.asList(split);
        NoLogErrorHandler errorHandler = new NoLogErrorHandler();
        InvalidToken token = new InvalidToken();
        Object value = this.traverse(segments, model, errorHandler, token);
        return value;
    }

    @Override
    public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
        Object value = this.traverse(segments, context.model, context.errorHandler, token);
        if (value instanceof Processor) {
            value = ((Processor)value).eval(context);
        } else if (value instanceof Callable) {
            try {
                value = ((Callable)value).call();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return value;
    }

    protected Object traverse(List<String> segments, Map<String, Object> model, ErrorHandler errorHandler, Token token) {
        if (segments.size() == 0) {
            return null;
        }
        String objectName = segments.get(0);
        Object value = model.get(objectName);
        value = this.traverse(value, segments, 1, errorHandler, token);
        return value;
    }

    protected Object traverse(Object o, List<String> attributeNames, int index, ErrorHandler errorHandler, Token token) {
        Object result;
        if (index >= attributeNames.size()) {
            result = o;
        } else {
            if (o == null) {
                return null;
            }
            String attributeName = attributeNames.get(index);
            Object nextStep = this.nextStep(o, attributeName, errorHandler, token);
            result = this.traverse(nextStep, attributeNames, index + 1, errorHandler, token);
        }
        return result;
    }

    protected Object nextStep(Object o, String attributeName, ErrorHandler errorHandler, Token token) {
        Object result;
        if (o instanceof String) {
            errorHandler.error("no-call-on-string", token, new ModelBuilder("receiver", (Object)o.toString()).build());
            return o;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            result = map.get(attributeName);
        } else {
            try {
                result = this.getPropertyValue(o, attributeName);
            }
            catch (Exception e) {
                errorHandler.error("property-access-error", token, new ModelBuilder("property", (Object)attributeName, "object", o, "exception", (Object)e).build());
                result = "";
            }
        }
        return result;
    }

    protected Object getPropertyValue(Object o, String propertyName) {
        try {
            Field field;
            Method[] declaredMethods;
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                if (propertyName.equals("key")) {
                    Object result = entry.getKey();
                    return result;
                }
                if (propertyName.equals("value")) {
                    Object result = entry.getValue();
                    return result;
                }
            }
            boolean valueSet = false;
            Object value = null;
            Member member = null;
            Class<?> clazz = o.getClass();
            Map<String, Member> members = this.cache.get(clazz);
            if (members == null) {
                members = new HashMap<String, Member>();
                this.cache.put(clazz, members);
            } else {
                member = members.get(propertyName);
                if (member != null) {
                    if (member.getClass() == Method.class) {
                        return ((Method)member).invoke(o, new Object[0]);
                    }
                    if (member.getClass() == Field.class) {
                        return ((Field)member).get(o);
                    }
                }
            }
            String suffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            for (Method method : declaredMethods = clazz.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals("get" + suffix) && !method.getName().equals("is" + suffix)) continue;
                value = method.invoke(o, (Object[])null);
                valueSet = true;
                member = method;
                break;
            }
            if (!valueSet && Modifier.isPublic((field = clazz.getField(propertyName)).getModifiers())) {
                value = field.get(o);
                member = field;
                valueSet = true;
            }
            if (valueSet) {
                members.put(propertyName, member);
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

