/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.token.AbstractToken;
import com.floreysoft.jmte.token.AnnotationToken;
import com.floreysoft.jmte.token.ElseToken;
import com.floreysoft.jmte.token.EndToken;
import com.floreysoft.jmte.token.ForEachToken;
import com.floreysoft.jmte.token.IfCmpRendererToken;
import com.floreysoft.jmte.token.IfCmpToken;
import com.floreysoft.jmte.token.IfToken;
import com.floreysoft.jmte.token.InvalidToken;
import com.floreysoft.jmte.token.StringToken;
import com.floreysoft.jmte.util.NestedParser;
import com.floreysoft.jmte.util.Util;
import java.util.List;

public class Lexer {
    public AbstractToken nextToken(char[] template, int start, int end) {
        String input = new String(template, start, end - start);
        if (input.startsWith("--")) {
            return null;
        }
        AbstractToken token = this.innerNextToken(input);
        token.setText(template, start, end);
        token.setLine(template, start, end);
        token.setColumn(template, start, end);
        return token;
    }

    private String unescapeAccess(List<? extends Object> arr, int index) {
        String val = NestedParser.access(arr, index);
        if (val != null && val.trim().length() > 0) {
            val = Util.NO_QUOTE_MINI_PARSER.unescape(val);
        }
        return val;
    }

    private AbstractToken innerNextToken(String untrimmedInput) {
        String objectExpression;
        String input = Util.trimFront(untrimmedInput);
        if (input.length() > 0 && input.charAt(0) == '@') {
            List<String> split = Util.RAW_MINI_PARSER.splitOnWhitespace(input.substring(1), 2);
            String receiver = NestedParser.access(split, 0);
            String arguments = NestedParser.access(split, 1);
            AnnotationToken annotationToken = new AnnotationToken(receiver, arguments);
            return annotationToken;
        }
        List<String> split = Util.RAW_MINI_PARSER.splitOnWhitespace(input);
        if (split.size() == 0) {
            return new StringToken();
        }
        if (split.size() >= 2) {
            String cmd = split.get(0);
            String objectExpression2 = split.get(1);
            if (cmd.equalsIgnoreCase("if")) {
                String complexVariable;
                int posLastRightBracket;
                String ifExpression;
                boolean negated;
                if (objectExpression2.startsWith("!")) {
                    negated = true;
                    ifExpression = objectExpression2.substring(1);
                } else {
                    negated = false;
                    ifExpression = objectExpression2;
                }
                if (!ifExpression.contains("=") && !ifExpression.contains(";")) {
                    return new IfToken(ifExpression, negated);
                }
                String completeIfExpression = ifExpression + input.substring(input.indexOf(ifExpression) + ifExpression.length());
                int posFirstSemi = completeIfExpression.indexOf(59);
                int posFirstEq = completeIfExpression.indexOf(61);
                int posLastEq = completeIfExpression.lastIndexOf(61);
                boolean hasCmp = posLastEq > (posLastRightBracket = completeIfExpression.lastIndexOf(41));
                String operand = null;
                if (hasCmp) {
                    operand = completeIfExpression.substring(posLastEq + 1);
                    if (operand.startsWith("'") || operand.startsWith("\"")) {
                        operand = operand.substring(1, operand.length() - 1);
                    }
                    complexVariable = completeIfExpression.substring(0, posLastEq);
                } else {
                    complexVariable = completeIfExpression;
                }
                if (posFirstSemi != -1 && posFirstEq != -1 && posFirstSemi < posFirstEq || posFirstSemi != -1 && posFirstEq == -1) {
                    String variable = complexVariable.substring(0, posFirstSemi);
                    String renderer = completeIfExpression.substring(posFirstSemi + 1);
                    List<String> scannedFormat = Util.MINI_PARSER.greedyScan(renderer, "(", ")");
                    String rendererName = NestedParser.access(scannedFormat, 0);
                    String parameters = NestedParser.access(scannedFormat, 1);
                    return new IfCmpRendererToken(variable, operand, negated, rendererName, parameters);
                }
                return new IfCmpToken(complexVariable, operand, negated);
            }
            if (cmd.equalsIgnoreCase("foreach")) {
                String separator;
                String varName = split.size() < 3 ? "_undefined" : split.get(2);
                int gapCount = 0;
                int separatorBegin = 0;
                while (separatorBegin < input.length()) {
                    char c = input.charAt(separatorBegin);
                    ++separatorBegin;
                    if (!Character.isWhitespace(c)) continue;
                    if (++gapCount == 3) break;
                    while (Character.isWhitespace(c = input.charAt(separatorBegin))) {
                        ++separatorBegin;
                    }
                }
                if ((separator = input.substring(separatorBegin)) != null) {
                    separator = Util.NO_QUOTE_MINI_PARSER.unescape(separator);
                }
                ForEachToken forEachToken = new ForEachToken(objectExpression2, varName, separator.length() != 0 ? separator : null);
                return forEachToken;
            }
        }
        if ((objectExpression = split.get(0)).equals("")) {
            return new StringToken();
        }
        String cmd = objectExpression;
        if (cmd.equalsIgnoreCase("else")) {
            return new ElseToken();
        }
        if (cmd.equalsIgnoreCase("end")) {
            return new EndToken();
        }
        String variableName = null;
        String defaultValue = null;
        String prefix = null;
        String suffix = null;
        String rendererName = null;
        String parameters = null;
        List<String> strings = Util.RAW_OUTPUT_MINI_PARSER.split(untrimmedInput, ';', 2);
        String complexVariable = strings.get(0);
        List<String> wrappedStrings = Util.RAW_OUTPUT_MINI_PARSER.split(complexVariable, ',', 3);
        prefix = wrappedStrings.size() == 3 ? this.unescapeAccess(wrappedStrings, 0) : null;
        suffix = wrappedStrings.size() == 3 ? this.unescapeAccess(wrappedStrings, 2) : null;
        String completeDefaultString = (wrappedStrings.size() == 3 ? this.unescapeAccess(wrappedStrings, 1) : complexVariable).trim();
        List<String> defaultStrings = Util.MINI_PARSER.greedyScan(completeDefaultString, "(", ")");
        variableName = this.unescapeAccess(defaultStrings, 0);
        defaultValue = this.unescapeAccess(defaultStrings, 1);
        String format = NestedParser.access(strings, 1);
        List<String> scannedFormat = Util.MINI_PARSER.greedyScan(format, "(", ")");
        rendererName = NestedParser.access(scannedFormat, 0);
        parameters = NestedParser.access(scannedFormat, 1);
        if (variableName.contains(" ")) {
            return new InvalidToken();
        }
        StringToken stringToken = new StringToken(untrimmedInput, variableName, defaultValue, prefix, suffix, rendererName, parameters);
        return stringToken;
    }
}

