/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.enhancedtabs;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

@JsModule(value="./fcEnhancedTabs/connector.js")
@CssImport.Container(value={@CssImport(value="./fcEnhancedTabs/fc-enhanced-tabs.css"), @CssImport(value="./fcEnhancedTabs/fc-enhanced-tabs-legacy.css"), @CssImport(value="./fcEnhancedTabs/vaadin-menu-bar-button-legacy.css", themeFor="vaadin-menu-bar-button")})
public class EnhancedTabs
extends Composite<MenuBar>
implements HasEnabled,
HasSize,
HasStyle {
    private transient Tab selectedTab;
    private boolean autoselect = true;
    private int selectedIndex = -1;
    private static final Method UI_navigate;

    public EnhancedTabs() {
        this.setSelectedIndex(-1);
        this.getElement().getThemeList().add((Object)"fc-enhanced-tabs");
        ((MenuBar)this.getContent()).setOpenOnHover(true);
    }

    public EnhancedTabs(Tab ... tabs) {
        this();
        this.add(tabs);
    }

    protected void onAttach(AttachEvent event) {
        event.getUI().getElement().executeJs("window.Vaadin.Flow.fcEnhancedTabsConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    public void setOpenOnHover(boolean openOnHover) {
        ((MenuBar)this.getContent()).setOpenOnHover(openOnHover);
    }

    public boolean isOpenOnHover() {
        return this.getElement().getProperty("openOnHover", false);
    }

    public EnhancedTabs(boolean autoselect, Tab ... tabs) {
        this();
        this.autoselect = autoselect;
        this.add(tabs);
    }

    public void add(Tab ... tabs) {
        Objects.requireNonNull(tabs, "Tabs should not be null");
        boolean wasEmpty = this.getComponentCount() == 0;
        for (Tab tab : tabs) {
            Objects.requireNonNull(tab, "Tab to add cannot be null");
            MenuItem item = ((MenuBar)this.getContent()).addItem((Component)tab);
            item.addClickListener((ComponentEventListener & Serializable)ev -> this.setSelectedTab(EnhancedTabs.getTab((MenuItem)ev.getSource()), ev.isFromClient()));
            tab.addAttachListener((ComponentEventListener & Serializable)ev -> tab.getElement().executeJs("this._item = {children:{}};", new Serializable[0]));
            tab.addAttachListener((ComponentEventListener & Serializable)ev -> tab.getElement().executeJs("this.addEventListener('click', ()=>{let overlay = this.closest('vaadin-menu-bar-overlay, vaadin-context-menu-overlay'); overlay && overlay.close();})", new Serializable[]{this}));
        }
        if (tabs.length == 0) {
            return;
        }
        if (wasEmpty && this.autoselect) {
            assert (this.getSelectedIndex() == -1);
            this.setSelectedIndex(0);
        } else {
            this.updateSelectedTab(false);
        }
    }

    private static void navigate(UI ui, Class<? extends Component> target) {
        try {
            UI_navigate.invoke((Object)ui, target);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public RouterLink addRouterLink(String text, Class<? extends Component> target) {
        RouterLink routerLink = new RouterLink(text, target);
        routerLink.getElement().executeJs("this.addEventListener('click', e => {\ne.preventDefault();\nthis.dispatchEvent(new CustomEvent('client-side-click'));\n});\n", new Serializable[0]);
        routerLink.getElement().addEventListener("client-side-click", (DomEventListener & Serializable)event -> EnhancedTabs.navigate(UI.getCurrent(), target));
        this.add(new Tab(new Component[]{routerLink}));
        return routerLink;
    }

    /*
     * Unable to fully structure code
     */
    public void remove(Tab ... tabs) {
        selectedIndex = this.getSelectedIndex();
        lowerIndices = (int)Stream.of(tabs).map((Function<Tab, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, indexOf(com.vaadin.flow.component.tabs.Tab ), (Lcom/vaadin/flow/component/tabs/Tab;)Ljava/lang/Integer;)((EnhancedTabs)this)).filter((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$remove$0(int java.lang.Integer ), (Ljava/lang/Integer;)Z)((int)selectedIndex)).count();
        selectedTab = this.getSelectedTab();
        if (selectedTab == null) ** GOTO lbl-1000
        if (Stream.of(tabs).anyMatch((Predicate<Tab>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/vaadin/flow/component/tabs/Tab;)Z)((Tab)selectedTab))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isSelectedTab = v0;
        this.doRemoveTabs(tabs);
        newSelectedIndex = this.getSelectedIndex() - lowerIndices;
        if (newSelectedIndex > 0 && newSelectedIndex >= this.getComponentCount()) {
            newSelectedIndex = this.getComponentCount() - 1;
        }
        if (this.getComponentCount() == 0 || isSelectedTab && !this.isAutoselect()) {
            newSelectedIndex = -1;
        }
        if (newSelectedIndex != this.getSelectedIndex()) {
            this.setSelectedIndex(newSelectedIndex);
        } else {
            this.updateSelectedTab(false);
        }
    }

    private void doRemoveTabs(Tab ... tabs) {
        ArrayList toRemove = new ArrayList(tabs.length);
        for (Tab tab : tabs) {
            Objects.requireNonNull(tab, "Tab to remove cannot be null");
            this.getMenuItem(tab).ifPresent(toRemove::add);
        }
        ((MenuBar)this.getContent()).remove(toRemove.toArray(new MenuItem[0]));
    }

    public void removeAll() {
        this.getElement().removeAllChildren();
        if (this.getSelectedIndex() > -1) {
            this.setSelectedIndex(-1);
        } else {
            this.updateSelectedTab(false);
        }
    }

    public void replace(Tab oldTab, Tab newTab) {
        if (oldTab != null || newTab != null) {
            if (oldTab == null) {
                this.add(newTab);
            } else if (newTab == null) {
                this.remove(oldTab);
            } else {
                this.doReplace(oldTab, newTab);
            }
        }
        this.updateSelectedTab(false);
    }

    private void doReplace(Tab oldTab, Tab newTab) {
        MenuItem oldItem = this.getMenuItem(oldTab).orElse(null);
        MenuItem newItem = this.getMenuItem(newTab).orElse(null);
        if (oldItem != null && newItem != null) {
            this.replaceTab(oldItem, newTab);
            this.replaceTab(newItem, oldTab);
        } else if (oldItem != null) {
            this.replaceTab(oldItem, newTab);
        } else {
            this.add(newTab);
        }
    }

    private void replaceTab(MenuItem item, Tab tab) {
        item.removeAll();
        item.add(new Component[]{tab});
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.addListener(SelectedChangeEvent.class, listener);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, false);
    }

    private void setSelectedIndex(int selectedIndex, boolean changedFromClient) {
        this.selectedIndex = selectedIndex;
        this.updateSelectedTab(changedFromClient);
    }

    public Tab getSelectedTab() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.getTabAt(selectedIndex);
    }

    public void setSelectedTab(Tab selectedTab) {
        this.setSelectedTab(selectedTab, false);
    }

    public void setSelectedTab(Tab selectedTab, boolean changedFromClient) {
        if (selectedTab == null) {
            this.setSelectedIndex(-1, changedFromClient);
            return;
        }
        int selectedIndex = this.indexOf(selectedTab);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Tab to select must be a child: " + selectedTab);
        }
        this.setSelectedIndex(selectedIndex, changedFromClient);
    }

    public void setAutoselect(boolean autoselect) {
        this.autoselect = autoselect;
    }

    public boolean isAutoselect() {
        return this.autoselect;
    }

    private void updateSelectedTab(boolean changedFromClient) {
        if (this.getSelectedIndex() < -1) {
            this.setSelectedIndex(-1);
            return;
        }
        Tab currentlySelected = this.getSelectedTab();
        Tab previousTab = this.selectedTab;
        if (Objects.equals(currentlySelected, this.selectedTab)) {
            return;
        }
        if (currentlySelected == null || currentlySelected.getElement().getNode().isEnabledSelf()) {
            this.selectedTab = currentlySelected;
            this.getTabs().forEach(tab -> tab.setSelected(false));
            if (this.selectedTab != null) {
                this.selectedTab.setSelected(true);
                this.getElement().executeJs("this.__detectOverflow()", new Serializable[0]);
            }
            this.fireEvent(new SelectedChangeEvent(this, previousTab, changedFromClient));
        } else {
            this.updateEnabled(currentlySelected);
            this.setSelectedTab(this.selectedTab);
        }
    }

    private void updateEnabled(Tab tab) {
        boolean enabled = tab.getElement().getNode().isEnabledSelf();
        Serializable rawValue = tab.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            tab.getElement().setProperty("disabled", enabled ? null : Boolean.TRUE.toString());
        } else {
            tab.setEnabled(enabled);
        }
    }

    public int indexOf(Tab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("The 'tab' parameter cannot be null");
        }
        Iterator it = ((Stream)this.getTabs().sequential()).iterator();
        int index = 0;
        while (it.hasNext()) {
            Component next = (Component)it.next();
            if (tab.equals(next)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getComponentCount() {
        return (int)this.getTabs().count();
    }

    public Tab getTabAt(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The 'index' argument should be greater than or equal to 0. It was: " + index);
        }
        return (Tab)((Stream)this.getTabs().sequential()).skip(index).findFirst().orElseThrow(() -> new IllegalArgumentException("The 'index' argument should not be greater than or equals to the number of children tabs. It was: " + index));
    }

    public int getTabCount() {
        return (int)this.getTabs().count();
    }

    public Stream<Tab> getTabs() {
        return ((MenuBar)this.getContent()).getItems().stream().map(EnhancedTabs::getTab).filter(Objects::nonNull);
    }

    private static Tab getTab(MenuItem item) {
        return item.getChildren().findFirst().filter(Tab.class::isInstance).orElse(null);
    }

    private Optional<MenuItem> getMenuItem(Tab tab) {
        Component item = tab.getParent().orElse(null);
        if (!(item instanceof MenuItem)) {
            return Optional.empty();
        }
        if (item.getParent().orElse(null) == this) {
            return Optional.of((MenuItem)item);
        }
        throw new IllegalArgumentException("The given tab (" + tab + ") is not a child of this tab");
    }

    private static /* synthetic */ boolean lambda$remove$0(int selectedIndex, Integer index) {
        return index >= 0 && index < selectedIndex;
    }

    static {
        try {
            UI_navigate = UI.class.getMethod("navigate", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError("UI.navigate(Class)");
        }
    }

    public static class SelectedChangeEvent
    extends ComponentEvent<EnhancedTabs> {
        private final Tab selectedTab;
        private final Tab previousTab;
        private final boolean initialSelection;

        public SelectedChangeEvent(EnhancedTabs source, Tab previousTab, boolean fromClient) {
            super((Component)source, fromClient);
            this.selectedTab = source.getSelectedTab();
            this.initialSelection = source.isAutoselect() && previousTab == null && !fromClient;
            this.previousTab = previousTab;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public Tab getPreviousTab() {
            return this.previousTab;
        }

        public boolean isInitialSelection() {
            return this.initialSelection;
        }
    }
}

