/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.testcontainers.impl;

import com.flowlogix.testcontainers.ContainerInterface;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class PayaraServerTestContainer
implements ContainerInterface {
    private GenericContainer<?> payara;

    @Override
    public ContainerInterface start(Consumer<GenericContainer<?>> preStart, Consumer<GenericContainer<?>> postStart) {
        if (this.payara == null && !Boolean.getBoolean("testcontainers.skip")) {
            Optional<String> imageName = Optional.ofNullable(System.getProperty("payara.imageName")).filter(Predicate.not(String::isBlank));
            double memory = Double.parseDouble(System.getProperty("payara.memory", "1.5"));
            this.payara = new GenericContainer(DockerImageName.parse((String)imageName.orElse("payara/server-full"))).withExposedPorts(new Integer[]{4848, 8080, 8181, 9009}).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf((long)(memory * 1024.0 * 1024.0 * 1024.0)))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Payara Server.*startup time.*\\n", (int)1));
            preStart.accept(this.payara);
            this.payara.start();
            System.out.printf("# Payara debugger location: %s:%d%n", this.payara.getHost(), this.payara.getMappedPort(9009));
            System.setProperty("adminHost", this.payara.getHost());
            System.setProperty("adminPort", Integer.toString(this.payara.getMappedPort(4848)));
            System.setProperty("httpPort", Integer.toString(this.payara.getMappedPort(8080)));
            System.setProperty("httpsPort", Integer.toString(this.payara.getMappedPort(8181)));
            if (System.getProperty("sslPort", "").isBlank()) {
                System.setProperty("sslPort", Integer.toString(this.payara.getMappedPort(8181)));
            }
            postStart.accept(this.payara);
        }
        return this;
    }

    @Override
    public ContainerInterface stop() {
        if (this.payara != null && this.payara.isRunning()) {
            this.payara.stop();
        }
        this.payara = null;
        return this;
    }
}

