/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.jeedao.primefaces;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.primefaces.model.SortMeta;

@FunctionalInterface
public interface Sorter<TT> {
    public void sort(SortData var1, CriteriaBuilder var2, Root<TT> var3);

    public static class MergedSortOrder {
        private final SortMeta requestedSortMeta;
        private final Order applicationSort;
        private final boolean highPriority;

        @Generated
        public SortMeta getRequestedSortMeta() {
            return this.requestedSortMeta;
        }

        @Generated
        public Order getApplicationSort() {
            return this.applicationSort;
        }

        @Generated
        public boolean isHighPriority() {
            return this.highPriority;
        }

        @ConstructorProperties(value={"requestedSortMeta", "applicationSort", "highPriority"})
        @Generated
        MergedSortOrder(SortMeta requestedSortMeta, Order applicationSort, boolean highPriority) {
            this.requestedSortMeta = requestedSortMeta;
            this.applicationSort = applicationSort;
            this.highPriority = highPriority;
        }
    }

    public static class SortData {
        private final Map<String, MergedSortOrder> sortOrder = new LinkedHashMap<String, MergedSortOrder>();

        public SortData(Map<String, SortMeta> sm) {
            sm.values().stream().sorted().forEach(value -> this.sortOrder.put(value.getField(), new MergedSortOrder((SortMeta)value, null, false)));
        }

        public void applicationSort(String fieldName, Function<Optional<SortMeta>, Order> fp) {
            this.applicationSort(fieldName, false, fp);
        }

        public void applicationSort(String fieldName, boolean highPriority, Function<Optional<SortMeta>, Order> fp) {
            this.getSortOrder().compute(fieldName, (key, value) -> new MergedSortOrder(null, Objects.requireNonNull((Order)fp.apply(Optional.ofNullable(value != null ? value.getRequestedSortMeta() : null)), "Sort Criteria cannot be null"), highPriority));
        }

        @Generated
        public Map<String, MergedSortOrder> getSortOrder() {
            return this.sortOrder;
        }
    }
}

