/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.jeedao.primefaces.internal;

import com.flowlogix.api.dao.JPAFinder;
import com.flowlogix.api.dao.JPAFinderHelper;
import com.flowlogix.jeedao.DaoHelper;
import com.flowlogix.jeedao.primefaces.Filter;
import com.flowlogix.jeedao.primefaces.JPALazyDataModel;
import com.flowlogix.jeedao.primefaces.Sorter;
import com.flowlogix.util.TypeConverter;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.beans.ConstructorProperties;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Lazy;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAModelImpl<TT>
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JPAModelImpl.class);
    private static final long serialVersionUID = 5L;
    private final transient Lazy.SerializableSupplier<EntityManager> entityManager;
    private final List<Class<? extends Annotation>> entityManagerQualifiers;
    @NonNull
    private final Class<TT> entityClass;
    private final Lazy<JPAFinderHelper<TT>> jpaFinder = new Lazy(this::createJPAFinder);
    private final transient Function<String, ?> converter;
    private final transient Function<TT, String> keyConverter;
    @NonNull
    private final transient Filter<TT> filter;
    @NonNull
    private final transient Sorter<TT> sorter;
    @NonNull
    private final transient UnaryOperator<TypedQuery<TT>> optimizer;
    private final boolean caseSensitiveFilter;
    private final JPALazyDataModel.FilterCaseConversion filterCaseConversion;
    private final boolean wildcardSupport;
    private final Lazy<Function<String, ?>> defaultConverter = new Lazy(this::createConverter);
    private final Lazy<Function<TT, String>> defaultKeyConverter = new Lazy(this::createKeyConverter);
    private BuilderInitializer<TT> x_do_not_use_in_builder;

    public static <TT> JPAModelImpl<TT> create(@NonNull BuilderInitializer<TT> initializer) {
        if (initializer == null) {
            throw new NullPointerException("initializer is marked non-null but is null");
        }
        JPAModelImplBuilder<TT> builderInstance = JPAModelImpl.builder();
        if (initializer.partialBuilder != null) {
            initializer.partialBuilder.accept(builderInstance);
        }
        return (JPAModelImpl)initializer.builder.apply(builderInstance);
    }

    public int count(Map<String, FilterMeta> filters) {
        return Math.toIntExact(((JPAFinderHelper)this.jpaFinder.get()).count(cqc -> cqc.query().where((Expression)this.getFilters(filters, cqc.builder(), cqc.root()))));
    }

    public List<TT> findRows(int first, int pageSize, Map<String, FilterMeta> filters, Map<String, SortMeta> sortMeta) {
        return ((TypedQuery)this.optimizer.apply(((JPAFinderHelper)this.jpaFinder.get()).findRange((long)Integer.max(first, 0), (long)Integer.max(first + pageSize, 1), qc -> this.addToCriteria((JPAFinder.QueryCriteria<TT>)qc, filters, sortMeta)))).getResultList();
    }

    public Supplier<EntityManager> getEntityManager() {
        return ((JPAFinderHelper)this.jpaFinder.get()).getEntityManager();
    }

    public <KK> Function<String, KK> getStringToKeyConverter() {
        return this.converter != null ? this.converter : (Function)this.defaultConverter.get();
    }

    public Function<TT, String> getKeyConverter() {
        return this.keyConverter != null ? this.keyConverter : (Function)this.defaultKeyConverter.get();
    }

    private JPAFinderHelper<TT> createJPAFinder() {
        if (this.entityManager != null) {
            return new DaoHelper(this.entityManager, this.entityClass);
        }
        return new DaoHelper(DaoHelper.findEntityManager(this.entityManagerQualifiers), this.entityClass);
    }

    private Function<String, ?> createConverter() {
        return keyValue -> TypeConverter.valueOf((String)keyValue, this.getPrimaryKeyClass());
    }

    private Function<TT, String> createKeyConverter() {
        return entry -> this.getPrimaryKey(Optional.of(entry)).toString();
    }

    private void addToCriteria(JPAFinder.QueryCriteria<TT> qc, Map<String, FilterMeta> filters, Map<String, SortMeta> sortMeta) {
        qc.query().where((Expression)this.getFilters(filters, qc.builder(), qc.root()));
        qc.query().orderBy(this.getSort(sortMeta, qc.builder(), qc.root()));
        qc.root().alias("result");
    }

    public Predicate getFilters(Map<String, FilterMeta> filters, CriteriaBuilder cb, Root<TT> root) {
        FilterDataMap predicates = new FilterDataMap();
        filters.values().forEach(filterMeta -> {
            if (filterMeta.isGlobalFilter()) {
                predicates.put(filterMeta.getField(), new Filter.FilterColumnData(filterMeta.getFilterValue(), null));
            } else if (filterMeta.getFilterValue() != null) {
                FilterMetaResult filterMetas = this.processFilterMeta(cb, root, filterMeta.getField(), (FilterMeta)filterMeta);
                predicates.put(filterMeta.getField(), new Filter.FilterColumnData(filterMetas.value(), filterMetas.cond()));
            }
        });
        this.filter.filter(predicates, cb, root);
        return cb.and((Predicate[])predicates.values().stream().map(Filter.FilterColumnData::getPredicate).filter(Objects::nonNull).toArray(Predicate[]::new));
    }

    public List<Order> getSort(Map<String, SortMeta> sortCriteria, CriteriaBuilder cb, Root<TT> root) {
        Sorter.SortData sortData = new Sorter.SortData(sortCriteria);
        this.sorter.sort(sortData, cb, root);
        return this.processSortOrder(sortData.getSortOrder(), cb, root);
    }

    public <YY> Expression<YY> resolveField(Root<TT> root, String fieldName) {
        Join join = null;
        while (fieldName.contains(".")) {
            String partial = fieldName.substring(0, fieldName.indexOf("."));
            fieldName = fieldName.substring(partial.length() + 1);
            if (join == null) {
                join = root.join(partial);
                continue;
            }
            join = join.join(partial);
        }
        return join == null ? root.get(fieldName) : join.get(fieldName);
    }

    private FilterMetaResult processFilterMeta(CriteriaBuilder cb, Root<TT> root, String key, FilterMeta filterMeta) {
        Predicate cond = null;
        Object value = Objects.requireNonNullElse(filterMeta.getFilterValue(), "");
        try {
            boolean compositeFilterType;
            Expression field = this.resolveField(root, key);
            Class fieldType = field.getJavaType();
            Class<?> filterType = value.getClass();
            boolean bl = compositeFilterType = filterType.isArray() || Collection.class.isAssignableFrom(filterType);
            if (fieldType == String.class) {
                value = value.toString();
                cond = this.predicateFromFilter(cb, field, filterMeta, value);
            } else if (fieldType.equals(filterType) || compositeFilterType) {
                cond = this.predicateFromFilterOrComparable(cb, field, filterMeta, value, fieldType, compositeFilterType);
            } else if ((value = this.convert(value, fieldType)) != null) {
                cond = this.predicateFromFilterOrComparable(cb, field, filterMeta, value, fieldType, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new FilterMetaResult(cond, value);
    }

    private Object convert(Object value, Class<?> fieldType) {
        Object convertedValue = null;
        TypeConverter.CheckedValue checkedConvertedValue = TypeConverter.checkAndConvert((String)value.toString(), fieldType);
        if (checkedConvertedValue.isValid()) {
            convertedValue = checkedConvertedValue.getValue();
        } else {
            try {
                Converter valueConverter = Faces.getApplication().createConverter(fieldType);
                if (valueConverter != null) {
                    convertedValue = valueConverter.getAsObject(Faces.getContext(), UIComponent.getCurrentComponent((FacesContext)Faces.getContext()), value.toString());
                }
            }
            catch (Exception e) {
                log.debug("unable to convert via Faces", (Throwable)e);
            }
        }
        return convertedValue;
    }

    private Predicate predicateFromFilterOrComparable(CriteriaBuilder cb, Expression<?> field, FilterMeta filterMeta, Object value, Class<?> fieldType, boolean compositeFilterType) {
        Predicate cond;
        if (compositeFilterType) {
            if (value.getClass().isArray()) {
                value = Arrays.asList((Object[])value);
            }
            List listValue = value;
            value = listValue.stream().map(raw -> fieldType.isAssignableFrom(raw.getClass()) ? raw : Optional.ofNullable(this.convert(raw, fieldType)).orElseThrow(() -> new IllegalArgumentException(String.format("Can't convert filter: %s to %s", raw, fieldType)))).toList();
        }
        if ((cond = this.predicateFromFilter(cb, field, filterMeta, value)) == null && Comparable.class.isAssignableFrom(fieldType)) {
            Comparable cv = null;
            if (value instanceof Comparable) {
                cv = (Comparable)((Object)value);
            }
            Expression<?> comparableField = field;
            cond = this.predicateFromFilterComparable(cb, comparableField, filterMeta, cv, value);
        }
        return cond;
    }

    Predicate predicateFromFilter(CriteriaBuilder cb, Expression<?> expression, FilterMeta filter, Object filterValue) {
        Lazy stringExpression = new Lazy((Lazy.SerializableSupplier & Serializable)() -> new ExpressionEvaluator(cb, expression, filterValue));
        Lazy filterValueAsCollection = new Lazy((Lazy.SerializableSupplier & Serializable)() -> (Collection)filterValue);
        switch (filter.getMatchMode()) {
            case STARTS_WITH: {
                return cb.like(((ExpressionEvaluator)stringExpression.get()).expression, ((ExpressionEvaluator)stringExpression.get()).value + "%");
            }
            case NOT_STARTS_WITH: {
                return cb.notLike(((ExpressionEvaluator)stringExpression.get()).expression, ((ExpressionEvaluator)stringExpression.get()).value + "%");
            }
            case ENDS_WITH: {
                return cb.like(((ExpressionEvaluator)stringExpression.get()).expression, "%" + ((ExpressionEvaluator)stringExpression.get()).value);
            }
            case NOT_ENDS_WITH: {
                return cb.notLike(((ExpressionEvaluator)stringExpression.get()).expression, "%" + ((ExpressionEvaluator)stringExpression.get()).value);
            }
            case CONTAINS: {
                return cb.like(((ExpressionEvaluator)stringExpression.get()).expression, "%" + ((ExpressionEvaluator)stringExpression.get()).value + "%");
            }
            case NOT_CONTAINS: {
                return cb.notLike(((ExpressionEvaluator)stringExpression.get()).expression, "%" + ((ExpressionEvaluator)stringExpression.get()).value + "%");
            }
            case EXACT: {
                if (this.wildcardSupport && ((ExpressionEvaluator)stringExpression.get()).hasWildcards) {
                    return cb.like(((ExpressionEvaluator)stringExpression.get()).expression, ((ExpressionEvaluator)stringExpression.get()).value);
                }
                return cb.equal(expression, filterValue);
            }
            case EQUALS: {
                return cb.equal(expression, filterValue);
            }
            case NOT_EXACT: 
            case NOT_EQUALS: {
                return cb.notEqual(expression, filterValue);
            }
            case IN: {
                return ((Collection)filterValueAsCollection.get()).size() == 1 ? cb.equal(expression, ((Collection)filterValueAsCollection.get()).iterator().next()) : expression.in((Collection)filterValueAsCollection.get());
            }
            case NOT_IN: {
                return ((Collection)filterValueAsCollection.get()).size() == 1 ? cb.notEqual(expression, ((Collection)filterValueAsCollection.get()).iterator().next()) : expression.in((Collection)filterValueAsCollection.get()).not();
            }
            case GLOBAL: {
                throw new UnsupportedOperationException("MatchMode.GLOBAL currently not supported!");
            }
        }
        return null;
    }

    <TC extends Comparable<? super TC>> Predicate predicateFromFilterComparable(CriteriaBuilder cb, Expression<TC> objectExpression, FilterMeta filter, TC filterValue, Object filterValueCollection) {
        Lazy filterValueAsCollection = new Lazy((Lazy.SerializableSupplier & Serializable)() -> (Collection)filterValueCollection);
        switch (filter.getMatchMode()) {
            case LESS_THAN: {
                return cb.lessThan(objectExpression, filterValue);
            }
            case LESS_THAN_EQUALS: {
                return cb.lessThanOrEqualTo(objectExpression, filterValue);
            }
            case GREATER_THAN: {
                return cb.greaterThan(objectExpression, filterValue);
            }
            case GREATER_THAN_EQUALS: {
                return cb.greaterThanOrEqualTo(objectExpression, filterValue);
            }
            case BETWEEN: {
                return this.between(cb, objectExpression, filterValueAsCollection);
            }
            case NOT_BETWEEN: {
                return this.between(cb, objectExpression, filterValueAsCollection).not();
            }
        }
        return null;
    }

    private <TC extends Comparable<? super TC>> Predicate between(CriteriaBuilder cb, Expression<TC> objectExpression, Lazy<Collection<TC>> filterValueAsCollection) {
        Iterator iterBetween = ((Collection)filterValueAsCollection.get()).iterator();
        return cb.and((Expression)cb.greaterThanOrEqualTo(objectExpression, (Comparable)iterBetween.next()), (Expression)cb.lessThanOrEqualTo(objectExpression, (Comparable)iterBetween.next()));
    }

    private List<Order> processSortOrder(Map<String, Sorter.MergedSortOrder> sortMeta, CriteriaBuilder cb, Root<TT> root) {
        ArrayDeque sortMetaOrdering = new ArrayDeque();
        sortMeta.values().forEach(order -> {
            if (order.getRequestedSortMeta() != null) {
                if (order.getRequestedSortMeta().getOrder() == SortOrder.ASCENDING) {
                    sortMetaOrdering.add(cb.asc(this.resolveField(root, order.getRequestedSortMeta().getField())));
                } else if (order.getRequestedSortMeta().getOrder() == SortOrder.DESCENDING) {
                    sortMetaOrdering.add(cb.desc(this.resolveField(root, order.getRequestedSortMeta().getField())));
                }
            } else if (order.getApplicationSort() != null) {
                if (order.isHighPriority()) {
                    sortMetaOrdering.addFirst(order.getApplicationSort());
                } else {
                    sortMetaOrdering.add(order.getApplicationSort());
                }
            } else {
                throw new IllegalStateException("Neither application sort request, nor UI sort request is available");
            }
        });
        return sortMetaOrdering.stream().toList();
    }

    private Object getPrimaryKey(Optional<TT> entry) {
        return ((EntityManager)((JPAFinderHelper)this.jpaFinder.get()).getEntityManager().get()).getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entry.orElse(ConstructorUtils.invokeConstructor(this.getEntityClass(), (Object[])new Object[0])));
    }

    private Class<?> getPrimaryKeyClass() {
        return this.getPrimaryKey(Optional.empty()).getClass();
    }

    Object readResolve() throws ObjectStreamException {
        JPAModelImpl<TT> corrected = JPAModelImpl.create(this.x_do_not_use_in_builder);
        corrected.x_do_not_use_in_builder = this.x_do_not_use_in_builder;
        return corrected;
    }

    @Generated
    private static <TT> List<Class<? extends Annotation>> $default$entityManagerQualifiers() {
        return List.of();
    }

    @Generated
    private static <TT> Filter<TT> $default$filter() {
        return (a, b, c) -> {};
    }

    @Generated
    private static <TT> Sorter<TT> $default$sorter() {
        return (a, b, c) -> {};
    }

    @Generated
    private static <TT> UnaryOperator<TypedQuery<TT>> $default$optimizer() {
        return a -> a;
    }

    @Generated
    private static <TT> boolean $default$caseSensitiveFilter() {
        return true;
    }

    @Generated
    private static <TT> JPALazyDataModel.FilterCaseConversion $default$filterCaseConversion() {
        return JPALazyDataModel.FilterCaseConversion.UPPER;
    }

    @Generated
    private static <TT> boolean $default$wildcardSupport() {
        return false;
    }

    @ConstructorProperties(value={"entityManager", "entityManagerQualifiers", "entityClass", "converter", "keyConverter", "filter", "sorter", "optimizer", "caseSensitiveFilter", "filterCaseConversion", "wildcardSupport", "x_do_not_use_in_builder"})
    @Generated
    JPAModelImpl(Lazy.SerializableSupplier<EntityManager> entityManager, List<Class<? extends Annotation>> entityManagerQualifiers, @NonNull Class<TT> entityClass, Function<String, ?> converter, Function<TT, String> keyConverter, @NonNull Filter<TT> filter, @NonNull Sorter<TT> sorter, @NonNull UnaryOperator<TypedQuery<TT>> optimizer, boolean caseSensitiveFilter, JPALazyDataModel.FilterCaseConversion filterCaseConversion, boolean wildcardSupport, BuilderInitializer<TT> x_do_not_use_in_builder) {
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (sorter == null) {
            throw new NullPointerException("sorter is marked non-null but is null");
        }
        if (optimizer == null) {
            throw new NullPointerException("optimizer is marked non-null but is null");
        }
        this.entityManager = entityManager;
        this.entityManagerQualifiers = entityManagerQualifiers;
        this.entityClass = entityClass;
        this.converter = converter;
        this.keyConverter = keyConverter;
        this.filter = filter;
        this.sorter = sorter;
        this.optimizer = optimizer;
        this.caseSensitiveFilter = caseSensitiveFilter;
        this.filterCaseConversion = filterCaseConversion;
        this.wildcardSupport = wildcardSupport;
        this.x_do_not_use_in_builder = x_do_not_use_in_builder;
    }

    @Generated
    public static <TT> JPAModelImplBuilder<TT> builder() {
        return new JPAModelImplBuilder();
    }

    @Generated
    public List<Class<? extends Annotation>> getEntityManagerQualifiers() {
        return this.entityManagerQualifiers;
    }

    @NonNull
    @Generated
    public Class<TT> getEntityClass() {
        return this.entityClass;
    }

    @NonNull
    @Generated
    public Filter<TT> getFilter() {
        return this.filter;
    }

    @NonNull
    @Generated
    public Sorter<TT> getSorter() {
        return this.sorter;
    }

    @NonNull
    @Generated
    public UnaryOperator<TypedQuery<TT>> getOptimizer() {
        return this.optimizer;
    }

    @Generated
    public boolean isCaseSensitiveFilter() {
        return this.caseSensitiveFilter;
    }

    @Generated
    public JPALazyDataModel.FilterCaseConversion getFilterCaseConversion() {
        return this.filterCaseConversion;
    }

    @Generated
    public boolean isWildcardSupport() {
        return this.wildcardSupport;
    }

    @Generated
    public void setX_do_not_use_in_builder(BuilderInitializer<TT> x_do_not_use_in_builder) {
        this.x_do_not_use_in_builder = x_do_not_use_in_builder;
    }

    public static class JPAModelImplBuilder<TT> {
        @Generated
        private Lazy.SerializableSupplier<EntityManager> entityManager;
        @Generated
        private boolean entityManagerQualifiers$set;
        @Generated
        private List<Class<? extends Annotation>> entityManagerQualifiers$value;
        @Generated
        private Class<TT> entityClass;
        @Generated
        private Function<String, ?> converter;
        @Generated
        private Function<TT, String> keyConverter;
        @Generated
        private boolean filter$set;
        @Generated
        private Filter<TT> filter$value;
        @Generated
        private boolean sorter$set;
        @Generated
        private Sorter<TT> sorter$value;
        @Generated
        private boolean optimizer$set;
        @Generated
        private UnaryOperator<TypedQuery<TT>> optimizer$value;
        @Generated
        private boolean caseSensitiveFilter$set;
        @Generated
        private boolean caseSensitiveFilter$value;
        @Generated
        private boolean filterCaseConversion$set;
        @Generated
        private JPALazyDataModel.FilterCaseConversion filterCaseConversion$value;
        @Generated
        private boolean wildcardSupport$set;
        @Generated
        private boolean wildcardSupport$value;
        @Generated
        private BuilderInitializer<TT> x_do_not_use_in_builder;

        @Generated
        JPAModelImplBuilder() {
        }

        @Generated
        public JPAModelImplBuilder<TT> entityManager(Lazy.SerializableSupplier<EntityManager> entityManager) {
            this.entityManager = entityManager;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> entityManagerQualifiers(List<Class<? extends Annotation>> entityManagerQualifiers) {
            this.entityManagerQualifiers$value = entityManagerQualifiers;
            this.entityManagerQualifiers$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> entityClass(@NonNull Class<TT> entityClass) {
            if (entityClass == null) {
                throw new NullPointerException("entityClass is marked non-null but is null");
            }
            this.entityClass = entityClass;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> converter(Function<String, ?> converter) {
            this.converter = converter;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> keyConverter(Function<TT, String> keyConverter) {
            this.keyConverter = keyConverter;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> filter(@NonNull Filter<TT> filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.filter$value = filter;
            this.filter$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> sorter(@NonNull Sorter<TT> sorter) {
            if (sorter == null) {
                throw new NullPointerException("sorter is marked non-null but is null");
            }
            this.sorter$value = sorter;
            this.sorter$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> optimizer(@NonNull UnaryOperator<TypedQuery<TT>> optimizer) {
            if (optimizer == null) {
                throw new NullPointerException("optimizer is marked non-null but is null");
            }
            this.optimizer$value = optimizer;
            this.optimizer$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> caseSensitiveFilter(boolean caseSensitiveFilter) {
            this.caseSensitiveFilter$value = caseSensitiveFilter;
            this.caseSensitiveFilter$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> filterCaseConversion(JPALazyDataModel.FilterCaseConversion filterCaseConversion) {
            this.filterCaseConversion$value = filterCaseConversion;
            this.filterCaseConversion$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> wildcardSupport(boolean wildcardSupport) {
            this.wildcardSupport$value = wildcardSupport;
            this.wildcardSupport$set = true;
            return this;
        }

        @Generated
        public JPAModelImplBuilder<TT> x_do_not_use_in_builder(BuilderInitializer<TT> x_do_not_use_in_builder) {
            this.x_do_not_use_in_builder = x_do_not_use_in_builder;
            return this;
        }

        @Generated
        public JPAModelImpl<TT> build() {
            List<Class<? extends Annotation>> entityManagerQualifiers$value = this.entityManagerQualifiers$value;
            if (!this.entityManagerQualifiers$set) {
                entityManagerQualifiers$value = JPAModelImpl.$default$entityManagerQualifiers();
            }
            Filter<TT> filter$value = this.filter$value;
            if (!this.filter$set) {
                filter$value = JPAModelImpl.$default$filter();
            }
            Sorter<TT> sorter$value = this.sorter$value;
            if (!this.sorter$set) {
                sorter$value = JPAModelImpl.$default$sorter();
            }
            UnaryOperator<TypedQuery<TT>> optimizer$value = this.optimizer$value;
            if (!this.optimizer$set) {
                optimizer$value = JPAModelImpl.$default$optimizer();
            }
            boolean caseSensitiveFilter$value = this.caseSensitiveFilter$value;
            if (!this.caseSensitiveFilter$set) {
                caseSensitiveFilter$value = JPAModelImpl.$default$caseSensitiveFilter();
            }
            JPALazyDataModel.FilterCaseConversion filterCaseConversion$value = this.filterCaseConversion$value;
            if (!this.filterCaseConversion$set) {
                filterCaseConversion$value = JPAModelImpl.$default$filterCaseConversion();
            }
            boolean wildcardSupport$value = this.wildcardSupport$value;
            if (!this.wildcardSupport$set) {
                wildcardSupport$value = JPAModelImpl.$default$wildcardSupport();
            }
            return new JPAModelImpl<TT>(this.entityManager, entityManagerQualifiers$value, this.entityClass, this.converter, this.keyConverter, filter$value, sorter$value, optimizer$value, caseSensitiveFilter$value, filterCaseConversion$value, wildcardSupport$value, this.x_do_not_use_in_builder);
        }

        @Generated
        public String toString() {
            return "JPAModelImpl.JPAModelImplBuilder(entityManager=" + String.valueOf(this.entityManager) + ", entityManagerQualifiers$value=" + String.valueOf(this.entityManagerQualifiers$value) + ", entityClass=" + String.valueOf(this.entityClass) + ", converter=" + String.valueOf(this.converter) + ", keyConverter=" + String.valueOf(this.keyConverter) + ", filter$value=" + String.valueOf(this.filter$value) + ", sorter$value=" + String.valueOf(this.sorter$value) + ", optimizer$value=" + String.valueOf(this.optimizer$value) + ", caseSensitiveFilter$value=" + this.caseSensitiveFilter$value + ", filterCaseConversion$value=" + String.valueOf((Object)this.filterCaseConversion$value) + ", wildcardSupport$value=" + this.wildcardSupport$value + ", x_do_not_use_in_builder=" + String.valueOf(this.x_do_not_use_in_builder) + ")";
        }
    }

    public record BuilderInitializer<TT>(@NonNull JPALazyDataModel.BuilderFunction<TT> builder, JPALazyDataModel.PartialBuilderConsumer<TT> partialBuilder) implements Serializable
    {
        @Generated
        public BuilderInitializer(@NonNull JPALazyDataModel.BuilderFunction<TT> builder, JPALazyDataModel.PartialBuilderConsumer<TT> partialBuilder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
        }
    }

    private static final class FilterDataMap
    extends HashMap<String, Filter.FilterColumnData>
    implements Filter.FilterData {
        private FilterDataMap() {
        }
    }

    private record FilterMetaResult(Predicate cond, Object value) {
    }

    private class ExpressionEvaluator {
        private final Expression<String> expression;
        private final String value;
        private final boolean hasWildcards;

        ExpressionEvaluator(CriteriaBuilder cb, Expression<?> expression, Object value) {
            WildcardValue wildcardValue = ExpressionEvaluator.replaceWildcards(JPAModelImpl.this.wildcardSupport, value.toString());
            this.hasWildcards = wildcardValue.hasWildcards;
            Expression stringExpression = expression.as(String.class);
            if (JPAModelImpl.this.caseSensitiveFilter) {
                this.expression = stringExpression;
                this.value = wildcardValue.value;
            } else {
                this.expression = switch (JPAModelImpl.this.filterCaseConversion) {
                    default -> throw new IncompatibleClassChangeError();
                    case JPALazyDataModel.FilterCaseConversion.LOWER -> cb.lower(stringExpression);
                    case JPALazyDataModel.FilterCaseConversion.UPPER -> cb.upper(stringExpression);
                };
                Locale locale = Faces.getLocale();
                this.value = switch (JPAModelImpl.this.filterCaseConversion) {
                    default -> throw new IncompatibleClassChangeError();
                    case JPALazyDataModel.FilterCaseConversion.LOWER -> wildcardValue.value.toLowerCase(locale);
                    case JPALazyDataModel.FilterCaseConversion.UPPER -> wildcardValue.value.toUpperCase(locale);
                };
            }
        }

        private static WildcardValue replaceWildcards(boolean wildcardSupport, String value) {
            return wildcardSupport ? new WildcardValue(value.contains("*") || value.contains("?"), value.replace("*", "%").replace("?", "_")) : new WildcardValue(false, value);
        }

        private record WildcardValue(boolean hasWildcards, String value) {
        }
    }
}

