/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.jeedao;

import com.flowlogix.jeedao.TypedNativeQuery;
import com.flowlogix.jeedao.querycriteria.CountQueryCriteria;
import com.flowlogix.jeedao.querycriteria.QueryCriteria;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import lombok.NonNull;

public class DaoHelper<TT, KT> {
    @NonNull
    private final Supplier<EntityManager> entityManagerSupplier;
    @NonNull
    private final Class<TT> entityClass;

    public List<TT> findAll() {
        return this.findAll(Parameters.builder().build());
    }

    public List<TT> findAll(Parameters<TT> parms) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        cq.select((Selection)root);
        parms.queryCriteria.accept(new QueryCriteria(this.getEntityManager().getCriteriaBuilder(), root, cq));
        TypedQuery tq = this.getEntityManager().createQuery(cq);
        parms.hints.accept(tq);
        return tq.getResultList();
    }

    public List<TT> findRange(int min, int max) {
        return this.findRange(min, max, Parameters.builder().build());
    }

    public List<TT> findRange(int min, int max, Parameters<TT> parms) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        cq.select((Selection)root);
        parms.queryCriteria.accept(new QueryCriteria(this.getEntityManager().getCriteriaBuilder(), root, cq));
        TypedQuery q = this.getEntityManager().createQuery(cq);
        q.setMaxResults(max - min);
        q.setFirstResult(min);
        parms.hints.accept(q);
        return q.getResultList();
    }

    public int count() {
        return this.count(Parameters.builder().build());
    }

    public int count(Parameters<TT> parms) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery(Long.class);
        Root rt = cq.from(this.entityClass);
        cq.select((Selection)this.getEntityManager().getCriteriaBuilder().count((Expression)rt));
        parms.countQueryCriteria.accept(new CountQueryCriteria(this.getEntityManager().getCriteriaBuilder(), rt, (CriteriaQuery<Long>)cq));
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return ((Long)q.getSingleResult()).intValue();
    }

    public EntityManager getEntityManager() {
        return this.entityManagerSupplier.get();
    }

    public QueryCriteria<TT> buildQueryCriteria() {
        return this.buildQueryCriteria(this.entityClass);
    }

    public <RR> QueryCriteria<RR> buildQueryCriteria(Class<RR> cls) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(cls);
        return new QueryCriteria(cb, cq.from(cls), cq);
    }

    public TypedNativeQuery createNativeQuery(String sql, Class<?> resultClass) {
        Query q = this.getEntityManager().createNativeQuery(sql, resultClass);
        return new TypedNativeQuery(q);
    }

    public TypedNativeQuery createNativeQuery(String sql, String resultMapping) {
        Query q = this.getEntityManager().createNativeQuery(sql, resultMapping);
        return new TypedNativeQuery(q);
    }

    @Generated
    protected DaoHelper(DaoHelperBuilder<TT, KT, ?, ?> b) {
        this.entityManagerSupplier = b.entityManagerSupplier;
        if (this.entityManagerSupplier == null) {
            throw new NullPointerException("entityManagerSupplier is marked non-null but is null");
        }
        this.entityClass = b.entityClass;
        if (this.entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
    }

    @Generated
    public static <TT, KT> DaoHelperBuilder<TT, KT, ?, ?> builder() {
        return new DaoHelperBuilderImpl();
    }

    @ConstructorProperties(value={"entityManagerSupplier", "entityClass"})
    @Generated
    public DaoHelper(@NonNull Supplier<EntityManager> entityManagerSupplier, @NonNull Class<TT> entityClass) {
        if (entityManagerSupplier == null) {
            throw new NullPointerException("entityManagerSupplier is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        this.entityManagerSupplier = entityManagerSupplier;
        this.entityClass = entityClass;
    }

    @NonNull
    @Generated
    public Class<TT> getEntityClass() {
        return this.entityClass;
    }

    public static class Parameters<TT> {
        private final Consumer<TypedQuery<TT>> hints;
        private final Consumer<QueryCriteria<TT>> queryCriteria;
        private final Consumer<CountQueryCriteria<TT>> countQueryCriteria;

        @Generated
        private static <TT> Consumer<TypedQuery<TT>> $default$hints() {
            return tq -> {};
        }

        @Generated
        private static <TT> Consumer<QueryCriteria<TT>> $default$queryCriteria() {
            return c -> {};
        }

        @Generated
        private static <TT> Consumer<CountQueryCriteria<TT>> $default$countQueryCriteria() {
            return c -> {};
        }

        @ConstructorProperties(value={"hints", "queryCriteria", "countQueryCriteria"})
        @Generated
        Parameters(Consumer<TypedQuery<TT>> hints, Consumer<QueryCriteria<TT>> queryCriteria, Consumer<CountQueryCriteria<TT>> countQueryCriteria) {
            this.hints = hints;
            this.queryCriteria = queryCriteria;
            this.countQueryCriteria = countQueryCriteria;
        }

        @Generated
        public static <TT> ParametersBuilder<TT> builder() {
            return new ParametersBuilder();
        }

        @Generated
        public static class ParametersBuilder<TT> {
            @Generated
            private boolean hints$set;
            @Generated
            private Consumer<TypedQuery<TT>> hints$value;
            @Generated
            private boolean queryCriteria$set;
            @Generated
            private Consumer<QueryCriteria<TT>> queryCriteria$value;
            @Generated
            private boolean countQueryCriteria$set;
            @Generated
            private Consumer<CountQueryCriteria<TT>> countQueryCriteria$value;

            @Generated
            ParametersBuilder() {
            }

            @Generated
            public ParametersBuilder<TT> hints(Consumer<TypedQuery<TT>> hints) {
                this.hints$value = hints;
                this.hints$set = true;
                return this;
            }

            @Generated
            public ParametersBuilder<TT> queryCriteria(Consumer<QueryCriteria<TT>> queryCriteria) {
                this.queryCriteria$value = queryCriteria;
                this.queryCriteria$set = true;
                return this;
            }

            @Generated
            public ParametersBuilder<TT> countQueryCriteria(Consumer<CountQueryCriteria<TT>> countQueryCriteria) {
                this.countQueryCriteria$value = countQueryCriteria;
                this.countQueryCriteria$set = true;
                return this;
            }

            @Generated
            public Parameters<TT> build() {
                Consumer<TypedQuery<TT>> hints$value = this.hints$value;
                if (!this.hints$set) {
                    hints$value = Parameters.$default$hints();
                }
                Consumer<QueryCriteria<TT>> queryCriteria$value = this.queryCriteria$value;
                if (!this.queryCriteria$set) {
                    queryCriteria$value = Parameters.$default$queryCriteria();
                }
                Consumer<CountQueryCriteria<TT>> countQueryCriteria$value = this.countQueryCriteria$value;
                if (!this.countQueryCriteria$set) {
                    countQueryCriteria$value = Parameters.$default$countQueryCriteria();
                }
                return new Parameters<TT>(hints$value, queryCriteria$value, countQueryCriteria$value);
            }

            @Generated
            public String toString() {
                return "DaoHelper.Parameters.ParametersBuilder(hints$value=" + String.valueOf(this.hints$value) + ", queryCriteria$value=" + String.valueOf(this.queryCriteria$value) + ", countQueryCriteria$value=" + String.valueOf(this.countQueryCriteria$value) + ")";
            }
        }
    }

    @Generated
    public static abstract class DaoHelperBuilder<TT, KT, C extends DaoHelper<TT, KT>, B extends DaoHelperBuilder<TT, KT, C, B>> {
        @Generated
        private Supplier<EntityManager> entityManagerSupplier;
        @Generated
        private Class<TT> entityClass;

        @Generated
        public B entityManagerSupplier(@NonNull Supplier<EntityManager> entityManagerSupplier) {
            if (entityManagerSupplier == null) {
                throw new NullPointerException("entityManagerSupplier is marked non-null but is null");
            }
            this.entityManagerSupplier = entityManagerSupplier;
            return this.self();
        }

        @Generated
        public B entityClass(@NonNull Class<TT> entityClass) {
            if (entityClass == null) {
                throw new NullPointerException("entityClass is marked non-null but is null");
            }
            this.entityClass = entityClass;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DaoHelper.DaoHelperBuilder(entityManagerSupplier=" + String.valueOf(this.entityManagerSupplier) + ", entityClass=" + String.valueOf(this.entityClass) + ")";
        }
    }

    @Generated
    private static final class DaoHelperBuilderImpl<TT, KT>
    extends DaoHelperBuilder<TT, KT, DaoHelper<TT, KT>, DaoHelperBuilderImpl<TT, KT>> {
        @Generated
        private DaoHelperBuilderImpl() {
        }

        @Override
        @Generated
        protected DaoHelperBuilderImpl<TT, KT> self() {
            return this;
        }

        @Override
        @Generated
        public DaoHelper<TT, KT> build() {
            return new DaoHelper(this);
        }
    }
}

