/*
 * Decompiled with CFR 0.152.
 */
package com.flowlogix.util;

import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeConverter.class);
    private static final MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final Map<Class<?>, MethodHandle> valueOfMethod = new ConcurrentHashMap();
    private static final Map<Class<?>, Function<String, Result>> info = Map.ofEntries(Map.entry(Double.class, value -> new Result(TypeConverter.processNumbers(value), Double.class)), Map.entry(Double.TYPE, value -> new Result(TypeConverter.processNumbers(value), Double.class)), Map.entry(Float.class, value -> new Result(TypeConverter.processNumbers(value), Float.class)), Map.entry(Float.TYPE, value -> new Result(TypeConverter.processNumbers(value), Float.class)), Map.entry(Integer.class, value -> new Result(TypeConverter.processNumbers(value), Integer.class)), Map.entry(Integer.TYPE, value -> new Result(TypeConverter.processNumbers(value), Integer.class)), Map.entry(Short.TYPE, value -> new Result(TypeConverter.processNumbers(value), Short.class)), Map.entry(Long.class, value -> new Result(TypeConverter.processNumbers(value), Long.class)), Map.entry(Long.TYPE, value -> new Result(TypeConverter.processNumbers(value), Long.class)), Map.entry(Boolean.class, value -> new Result((String)value, Boolean.TYPE, "parseBoolean", (Class<?>)Boolean.class)), Map.entry(Boolean.TYPE, value -> new Result((String)value, Boolean.TYPE, "parseBoolean", (Class<?>)Boolean.class)), Map.entry(BigInteger.class, value -> new Result(new BigInteger((String)value))), Map.entry(BigDecimal.class, value -> new Result(new BigDecimal((String)value))), Map.entry(LocalDate.class, value -> new Result((String)value, "parse", CharSequence.class, (Class<?>)LocalDate.class)), Map.entry(LocalTime.class, value -> new Result((String)value, "parse", CharSequence.class, (Class<?>)LocalTime.class)), Map.entry(LocalDateTime.class, value -> new Result((String)value, "parse", CharSequence.class, (Class<?>)LocalDateTime.class)));

    public static <TT> TT valueOf(@NonNull String strValue, @NonNull Class<TT> type) {
        if (strValue == null) {
            throw new NullPointerException("strValue is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type.equals(String.class)) {
            return (TT)strValue;
        }
        Result result = info.getOrDefault(type, value -> new Result((String)value, type)).apply(strValue);
        if (result.actualResult != null) {
            return (TT)result.actualResult;
        }
        return TypeConverter.callMethod(result.value, result.method, result.classToCall, result.resultType, result.stringArgType);
    }

    public static Object valueOf(@NonNull String strValue, @NonNull String type) throws IllegalArgumentException {
        if (strValue == null) {
            throw new NullPointerException("strValue is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String dataTypeString = type;
        if (type.equals(String.class.getName())) {
            dataTypeString = null;
        }
        String value = strValue;
        if (dataTypeString != null) {
            try {
                Class<?> dataObjectClass = Class.forName(dataTypeString);
                value = TypeConverter.valueOf(strValue, dataObjectClass);
            }
            catch (ClassNotFoundException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.append(e.toString() + " Value: " + strValue + ", Type: " + type + ", Stack Trace: ");
                e.printStackTrace(pw);
                pw.flush();
                log.warn(sw.toString());
            }
        }
        return value;
    }

    public static <TT> boolean checkType(@NonNull String value, @NonNull Class<TT> type) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return TypeConverter.checkAndConvert((String)value, type).valid;
    }

    public static <TT> CheckedValue<TT> checkAndConvert(@NonNull String value, @NonNull Class<TT> type) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            TT cv = TypeConverter.valueOf(value, type);
            if (value.equals(cv.toString())) {
                return new CheckedValue<TT>(true, cv);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new CheckedValue<Object>(false, null);
    }

    private static <TT> TT callMethod(String strValue, String methodName, Class<?> type, Class<?> resultType, Class<?> stringArgType) {
        MethodHandle method = valueOfMethod.computeIfAbsent(type, k -> (resultType.isEnum() ? lookup : publicLookup).findStatic(type, methodName, MethodType.methodType(resultType, stringArgType)));
        return (TT)method.invoke(strValue);
    }

    private static String processNumbers(String strValue) {
        switch (strValue) {
            case "nan": {
                strValue = "NaN";
                break;
            }
            case "inf": {
                strValue = "Infinity";
                break;
            }
            case "-inf": {
                strValue = "-Infinity";
                break;
            }
            case "": {
                strValue = "0";
            }
        }
        return strValue;
    }

    @Generated
    private TypeConverter() {
    }

    private static class Result {
        private final String value;
        private final Class<?> resultType;
        private final String method;
        private final Class<?> classToCall;
        private final Class<?> stringArgType;
        private final Object actualResult;

        Result(String value, Class<?> resultType) {
            this(value, resultType, "valueOf", resultType);
        }

        Result(String value, Class<?> resultType, String method, Class<?> classToCall) {
            this(value, resultType, method, classToCall, String.class, null);
        }

        Result(String value, String method, Class<?> stringArgType, Class<?> resultType) {
            this(value, resultType, method, resultType, stringArgType, null);
        }

        Result(Object actualResult) {
            this(null, null, null, null, null, actualResult);
        }

        Result(String value, Class<?> resultType, String method, Class<?> classToCall, Class<?> stringArgType, Object actualResult) {
            this.value = value;
            this.resultType = resultType;
            this.method = method;
            this.classToCall = classToCall;
            this.stringArgType = stringArgType;
            this.actualResult = actualResult;
        }
    }

    public static class CheckedValue<TT> {
        private final boolean valid;
        private final TT value;

        @ConstructorProperties(value={"valid", "value"})
        @Generated
        public CheckedValue(boolean valid, TT value) {
            this.valid = valid;
            this.value = value;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public TT getValue() {
            return this.value;
        }
    }
}

