/*
 * Decompiled with CFR 0.152.
 */
package com.fluenda.parcefone.parser;

import com.fluenda.parcefone.event.CEFHandlingException;
import com.fluenda.parcefone.event.CefRev23;
import com.fluenda.parcefone.event.CommonEvent;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEFParser {
    static final Logger logger = LoggerFactory.getLogger(CEFParser.class);
    static final Pattern extensionPattern = Pattern.compile("(?<!\\\\)" + Pattern.quote("="));
    Validator validator;

    public CEFParser() {
    }

    public CEFParser(Validator validator) {
        this.validator = validator;
    }

    public CommonEvent parse(byte[] cefByteArray) {
        String cefString = new String(cefByteArray, Charset.forName("UTF-8"));
        return this.parse(cefString, false);
    }

    public CommonEvent parse(byte[] cefByteArray, boolean validate) {
        String cefString = new String(cefByteArray, Charset.forName("UTF-8"));
        return this.parse(cefString, validate);
    }

    public CommonEvent parse(byte[] cefByteArray, boolean validate, Locale locale) {
        String cefString = new String(cefByteArray, Charset.forName("UTF-8"));
        return this.parse(cefString, validate, locale);
    }

    public CommonEvent parse(byte[] cefByteArray, boolean validate, boolean allowNulls, Locale locale) {
        String cefString = new String(cefByteArray, Charset.forName("UTF-8"));
        return this.parse(cefString, validate, allowNulls, locale);
    }

    public CommonEvent parse(String cefString) {
        return this.parse(cefString, false);
    }

    public CommonEvent parse(String cefString, boolean validate) {
        return this.parse(cefString, validate, Locale.ENGLISH);
    }

    public CommonEvent parse(String cefString, boolean validate, Locale locale) {
        return this.parse(cefString, validate, false, locale);
    }

    public CommonEvent parse(String cefString, boolean validate, boolean allowNulls, Locale locale) {
        int cefHeaderSize = 7;
        CefRev23 cefEvent = new CefRev23(locale);
        String[] extractedMessage = cefString.split("(?<!\\\\)" + Pattern.quote("|"), cefHeaderSize + 1);
        if (extractedMessage.length < cefHeaderSize) {
            if (logger.isDebugEnabled()) {
                logger.debug("CEF message failed validation");
            }
            return null;
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("version", Integer.valueOf(extractedMessage[0].substring(extractedMessage[0].length() - 1)));
        headers.put("deviceVendor", extractedMessage[1]);
        headers.put("deviceProduct", extractedMessage[2]);
        headers.put("deviceVersion", extractedMessage[3]);
        headers.put("deviceEventClassId", extractedMessage[4]);
        headers.put("name", extractedMessage[5]);
        headers.put("severity", extractedMessage[6]);
        HashMap<String, String> extensions = new HashMap<String, String>();
        String ext = extractedMessage[7];
        Matcher matcher = extensionPattern.matcher(ext);
        Matcher valueMatcher = extensionPattern.matcher(ext);
        int index = 0;
        while (matcher.find()) {
            String key = ext.substring(index, matcher.end() - 1).replace(" ", "");
            int valueStart = matcher.end();
            if (valueMatcher.find(valueStart)) {
                int nextMatch = valueMatcher.start();
                int lastSpace = ext.lastIndexOf(" ", nextMatch);
                String value = ext.substring(valueStart, lastSpace);
                extensions.put(key, value);
                index = lastSpace + 1;
                continue;
            }
            if (!valueMatcher.find(valueStart - 1)) continue;
            int valueEnd = ext.length();
            String value = ext.substring(valueStart, valueEnd);
            extensions.put(key, value);
            index = valueEnd;
        }
        try {
            ((CommonEvent)cefEvent).setHeader(headers);
            ((CommonEvent)cefEvent).setExtension(extensions, allowNulls);
        }
        catch (CEFHandlingException e) {
            logger.error(e.toString());
            return null;
        }
        if (validate) {
            Set validationResult;
            if (this.validator == null) {
                this.validator = Validation.buildDefaultValidatorFactory().getValidator();
            }
            if ((validationResult = this.validator.validate((Object)cefEvent, new Class[0])).size() > 0) {
                if (logger.isDebugEnabled()) {
                    for (ConstraintViolation v : validationResult) {
                        logger.debug("CEF message failed validation: " + v.getMessage());
                    }
                }
                return null;
            }
            return cefEvent;
        }
        return cefEvent;
    }
}

