/*
 * Decompiled with CFR 0.152.
 */
package com.fluenda.parcefone.event;

import com.fluenda.parcefone.event.CEFHandlingException;
import com.fluenda.parcefone.event.CommonEvent;
import com.fluenda.parcefone.event.MacAddress;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CefRev23
extends CommonEvent {
    private final java.util.regex.Pattern timeRegex = java.util.regex.Pattern.compile("(?<MONTH>\\S+(\\.)?)\\s(?<DAY>\\d{2})\\s(?:(?<YEAR>\\d{4})(?:\\s))?(?<HOUR>[012][0-9]):(?<MINUTE>[0-5][0-9]):(?<SECOND>[0-5][0-9])(?:\\.(?<MILLI>\\d{3}))?(?:\\s(?<TZ>\\w+))?");
    private final Class<?> objClass = this.getClass();
    private final Field[] fields = this.objClass.getDeclaredFields();
    private ArrayList<String> populatedExtensions = new ArrayList();
    private Map<String, Object> customExtensions = new HashMap<String, Object>();
    private int version;
    private String deviceVendor;
    private String deviceProduct;
    private String deviceVersion;
    private String deviceEventClassId;
    private String name;
    private String severity;
    @Size(max=63)
    private @Size(max=63) String act;
    @Size(max=31)
    private @Size(max=31) String app;
    private InetAddress c6a1;
    @Size(max=1023)
    private @Size(max=1023) String c6a1Label;
    private InetAddress c6a2;
    @Size(max=1023)
    private @Size(max=1023) String c6a2Label;
    private InetAddress c6a3;
    @Size(max=1023)
    private @Size(max=1023) String c6a3Label;
    private InetAddress c6a4;
    @Size(max=1023)
    private @Size(max=1023) String c6a4Label;
    private Float cfp1;
    @Size(max=1023)
    private @Size(max=1023) String cfp1Label;
    private Float cfp2;
    @Size(max=1023)
    private @Size(max=1023) String cfp2Label;
    private Float cfp3;
    @Size(max=1023)
    private @Size(max=1023) String cfp3Label;
    private Float cfp4;
    @Size(max=1023)
    private @Size(max=1023) String cfp4Label;
    private Long cn1;
    @Size(max=1023)
    private @Size(max=1023) String cn1Label;
    private Long cn2;
    @Size(max=1023)
    private @Size(max=1023) String cn2Label;
    private Long cn3;
    @Size(max=1023)
    private @Size(max=1023) String cn3Label;
    private Long cnt;
    @Size(max=4000)
    private @Size(max=4000) String cs1;
    @Size(max=1023)
    private @Size(max=1023) String cs1Label;
    @Size(max=4000)
    private @Size(max=4000) String cs2;
    @Size(max=1023)
    private @Size(max=1023) String cs2Label;
    @Size(max=4000)
    private @Size(max=4000) String cs3;
    @Size(max=1023)
    private @Size(max=1023) String cs3Label;
    @Size(max=4000)
    private @Size(max=4000) String cs4;
    @Size(max=1023)
    private @Size(max=1023) String cs4Label;
    @Size(max=4000)
    private @Size(max=4000) String cs5;
    @Size(max=1023)
    private @Size(max=1023) String cs5Label;
    @Size(max=4000)
    private @Size(max=4000) String cs6;
    @Size(max=1023)
    private @Size(max=1023) String cs6Label;
    @Size(max=255)
    private @Size(max=255) String destinationDnsDomain;
    @Size(max=1023)
    private @Size(max=1023) String destinationServiceName;
    private Inet4Address destinationTranslatedAddress;
    private Integer destinationTranslatedPort;
    private Date deviceCustomDate1;
    @Size(max=1023)
    private @Size(max=1023) String deviceCustomDate1Label;
    private Date deviceCustomDate2;
    @Size(max=1023)
    private @Size(max=1023) String deviceCustomDate2Label;
    @Min(value=0L)
    @Max(value=1L)
    private @Min(value=0L) @Max(value=1L) Integer deviceDirection;
    @Size(max=255)
    private @Size(max=255) String deviceDnsDomain;
    @Size(max=255)
    private @Size(max=255) String deviceExternalId;
    @Size(max=1023)
    private @Size(max=1023) String deviceFacility;
    @Size(max=128)
    private @Size(max=128) String deviceInboundInterface;
    @Size(max=255)
    private @Size(max=255) String deviceNtDomain;
    @Size(max=128)
    private @Size(max=128) String deviceOutboundInterface;
    @Size(max=128)
    private @Size(max=128) String devicePayloadId;
    @Size(max=1023)
    private @Size(max=1023) String deviceProcessName;
    private Inet4Address deviceTranslatedAddress;
    @Size(max=1023)
    private @Size(max=1023) String dhost;
    private MacAddress dmac;
    @Size(max=255)
    private @Size(max=255) String dntdom;
    private Integer dpid;
    @Size(max=1023)
    private @Size(max=1023) String dpriv;
    @Size(max=1023)
    private @Size(max=1023) String dproc;
    @Max(value=65535L)
    private @Max(value=65535L) Integer dpt;
    private Inet4Address dst;
    @Size(max=255)
    private @Size(max=255) String dtz;
    @Size(max=1023)
    private @Size(max=1023) String duid;
    @Size(max=1023)
    private @Size(max=1023) String duser;
    private Inet4Address dvc;
    @Size(max=100)
    private @Size(max=100) String dvchost;
    private MacAddress dvcmac;
    private Integer dvcpid;
    private Date end;
    @Size(max=40)
    private @Size(max=40) String externalId;
    private Date fileCreateTime;
    @Size(max=255)
    private @Size(max=255) String fileHash;
    @Size(max=1023)
    private @Size(max=1023) String field;
    private Date fileModificationTime;
    @Size(max=1023)
    private @Size(max=1023) String filePath;
    @Size(max=1023)
    private @Size(max=1023) String filePermission;
    @Size(max=1023)
    private @Size(max=1023) String fileType;
    private Date flexDate1;
    @Size(max=128)
    private @Size(max=128) String flexDate1Label;
    private Long flexNumber1;
    @Size(max=128)
    private @Size(max=128) String flexNumber1Label;
    private Long flexNumber2;
    @Size(max=128)
    private @Size(max=128) String flexNumber2Label;
    @Size(max=1023)
    private @Size(max=1023) String flexString1;
    @Size(max=128)
    private @Size(max=128) String flexString1Label;
    @Size(max=1023)
    private @Size(max=1023) String flexString2;
    @Size(max=128)
    private @Size(max=128) String flexString2Label;
    @Size(max=1023)
    private @Size(max=1023) String fname;
    private Integer fsize;
    private Integer in;
    @Size(max=1023)
    private @Size(max=1023) String msg;
    private Date oldFileCreateTime;
    @Size(max=255)
    private @Size(max=255) String oldFileHash;
    @Size(max=1023)
    private @Size(max=1023) String oldField;
    private Date oldFileModificationTime;
    @Size(max=1023)
    private @Size(max=1023) String oldFileName;
    @Size(max=1023)
    private @Size(max=1023) String oldFilePath;
    @Size(max=1023)
    private @Size(max=1023) String oldFilePermission;
    private Integer oldFileSize;
    @Size(max=1023)
    private @Size(max=1023) String oldFileType;
    private Integer out;
    @Size(max=63)
    private @Size(max=63) String outcome;
    @Pattern(regexp="tcp|udp", flags={Pattern.Flag.CASE_INSENSITIVE})
    @Size(max=31)
    private @Pattern(regexp="tcp|udp", flags={Pattern.Flag.CASE_INSENSITIVE}) @Size(max=31) String proto;
    @Size(max=1023)
    private @Size(max=1023) String reason;
    @Size(max=1023)
    private @Size(max=1023) String request;
    @Size(max=1023)
    private @Size(max=1023) String requestClientApplication;
    @Size(max=2048)
    private @Size(max=2048) String requestContext;
    @Size(max=1023)
    private @Size(max=1023) String requestCookies;
    @Size(max=1023)
    private @Size(max=1023) String requestMethod;
    private Date rt;
    @Size(max=1023)
    private @Size(max=1023) String shost;
    private MacAddress smac;
    @Size(max=255)
    private @Size(max=255) String sntdom;
    @Size(max=255)
    private @Size(max=255) String sourceDnsDomain;
    @Size(max=1023)
    private @Size(max=1023) String sourceServiceName;
    private Inet4Address sourceTranslatedAddress;
    private Integer sourceTranslatedPort;
    private Integer spid;
    @Size(max=1023)
    private @Size(max=1023) String spriv;
    @Size(max=1023)
    private @Size(max=1023) String sproc;
    @Max(value=65535L)
    private @Max(value=65535L) Integer spt;
    private Inet4Address src;
    private Date start;
    @Size(max=1023)
    private @Size(max=1023) String suid;
    @Size(max=1023)
    private @Size(max=1023) String suser;
    @Min(value=0L)
    @Max(value=3L)
    private @Min(value=0L) @Max(value=3L) Integer type;
    @Size(max=255)
    private @Size(max=255) String agentDnsDomain;
    @Size(max=255)
    private @Size(max=255) String agentNtDomain;
    private Inet4Address agentTranslatedAddress;
    @Size(max=200)
    private @Size(max=200) String agentTranslatedZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String agentTranslatedZoneURI;
    @Size(max=200)
    private @Size(max=200) String agentZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String agentZoneURI;
    private InetAddress agt;
    @Size(max=1023)
    private @Size(max=1023) String ahost;
    @Size(max=40)
    private @Size(max=40) String aid;
    private MacAddress amac;
    private Date art;
    @Size(max=63)
    private @Size(max=63) String at;
    @Size(max=255)
    private @Size(max=255) String atz;
    @Size(max=31)
    private @Size(max=31) String av;
    @Size(max=1023)
    private @Size(max=1023) String cat;
    @Size(max=200)
    private @Size(max=200) String customerExternalID;
    @Size(max=2048)
    private @Size(max=2048) String customerURI;
    @Size(max=200)
    private @Size(max=200) String destinationTranslatedZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String destinationTranslatedZoneURI;
    @Size(max=200)
    private @Size(max=200) String destinationZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String destinationZoneURI;
    @Size(max=200)
    private @Size(max=200) String deviceTranslatedZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String deviceTranslatedZoneURI;
    @Size(max=200)
    private @Size(max=200) String deviceZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String deviceZoneURI;
    private Double dlat;
    private Double dlong;
    private Long eventId;
    @Size(max=4000)
    private @Size(max=4000) String rawEvent;
    private Double slat;
    private Double slong;
    @Size(max=200)
    private @Size(max=200) String sourceTranslatedZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String sourceTranslatedZoneURI;
    @Size(max=200)
    private @Size(max=200) String sourceZoneExternalID;
    @Size(max=2048)
    private @Size(max=2048) String sourceZoneURI;
    private Locale dateLocale;

    public CefRev23(Locale locale) {
        this.dateLocale = locale;
    }

    public CefRev23() {
        this.dateLocale = Locale.ENGLISH;
    }

    @Override
    public void setHeader(Map<String, Object> headers) throws CEFHandlingException {
        for (String key : headers.keySet()) {
            try {
                Field field = this.objClass.getDeclaredField(key);
                Object value = headers.get(key);
                field.set(this, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new CEFHandlingException("Error writing values to headers", e);
            }
        }
    }

    @Override
    public Map<String, Object> getHeader() throws CEFHandlingException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        List<String> headersKeys = Arrays.asList("version", "deviceVendor", "deviceProduct", "deviceVersion", "deviceEventClassId", "name", "severity");
        for (Field f : this.fields) {
            if (!headersKeys.contains(f.getName())) continue;
            try {
                headers.put(f.getName(), f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new CEFHandlingException("Error harvesting headers, e");
            }
        }
        return headers;
    }

    @Override
    public void setExtension(Map<String, String> extensions) throws CEFHandlingException {
        this.setExtension(extensions, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setExtension(Map<String, String> extensions, boolean allowNulls) throws CEFHandlingException {
        for (String key : extensions.keySet()) {
            try {
                field = this.objClass.getDeclaredField(key);
                value = extensions.get(key);
                if (field.getType().equals(InetAddress.class) || field.getType().equals(Inet4Address.class) || field.getType().equals(Inet6Address.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        try {
                            inetAddress = InetAddress.getByName(value);
                            field.set(this, inetAddress);
                        }
                        catch (UnknownHostException e) {
                            throw new CEFHandlingException("Error setting value to field " + key, e);
                        }
                    }
                } else if (field.getType().equals(Date.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        try {
                            if (!value.toString().contains(":")) {
                                field.set(this, new Date(Long.valueOf(value)));
                            }
                            matcher = this.timeRegex.matcher(value);
                            if (!matcher.matches()) ** GOTO lbl67
                            year = matcher.group("YEAR") == null ? String.valueOf(Calendar.getInstance().get(1)) : matcher.group("YEAR");
                            milli = matcher.group("MILLI") == null ? "000" : matcher.group("MILLI");
                            regexDate = year + "-" + matcher.group("MONTH") + "-" + matcher.group("DAY") + " " + matcher.group("HOUR") + ":" + matcher.group("MINUTE") + ":" + matcher.group("SECOND") + "." + milli;
                            if (matcher.group("TZ") == null) {
                                field.set(this, this.dateFormat(false).parse(regexDate));
                            }
                            regexDate = regexDate + " " + matcher.group("TZ");
                            field.set(this, this.dateFormat(true).parse(regexDate));
                        }
                        catch (NumberFormatException | ParseException e) {
                            throw new CEFHandlingException("Error setting value to field " + key, e);
                        }
                    }
                } else if (field.getType().equals(MacAddress.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        field.set(this, new MacAddress(value));
                    }
                } else if (field.getType().equals(Integer.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        field.set(this, Integer.valueOf(value));
                    }
                } else if (field.getType().equals(Long.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        field.set(this, Long.valueOf(value));
                    }
                } else if (field.getType().equals(Double.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        field.set(this, Double.valueOf(value));
                    }
                } else if (field.getType().equals(Float.class)) {
                    if (allowNulls && (value == null || value.isEmpty())) {
                        field.set(this, null);
                    } else {
                        field.set(this, Float.valueOf(value));
                    }
                } else {
                    field.set(this, value);
                }
lbl67:
                // 18 sources

                this.populatedExtensions.add(key);
            }
            catch (NoSuchFieldException e) {
                this.customExtensions.put(key, extensions.get(key));
            }
            catch (IllegalAccessException e) {
                throw new CEFHandlingException("Error while setting CEF extension values", e);
            }
        }
    }

    @Override
    public Map<String, Object> getExtension(boolean populatedOnly) throws CEFHandlingException {
        return this.getExtension(populatedOnly, false);
    }

    @Override
    public Map<String, Object> getExtension(boolean populatedOnly, boolean includeCustomExtensions) throws CEFHandlingException {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        List<String> headersKeys = Arrays.asList("version", "deviceVendor", "deviceProduct", "deviceVersion", "deviceEventClassId", "name", "severity");
        for (Field f : this.fields) {
            if (headersKeys.contains(f.getName())) continue;
            try {
                Object value = f.get(this);
                if (!populatedOnly) {
                    extensions.put(f.getName(), value);
                    continue;
                }
                if (!populatedOnly || !this.populatedExtensions.contains(f.getName())) continue;
                extensions.put(f.getName(), value);
            }
            catch (IllegalAccessException e) {
                throw new CEFHandlingException("Error while harvesting keys", e);
            }
        }
        if (includeCustomExtensions) {
            extensions.putAll(this.customExtensions);
        }
        return extensions;
    }

    private SimpleDateFormat dateFormat(boolean containsTZ) {
        if (containsTZ) {
            return new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS zzz", this.dateLocale);
        }
        return new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS", this.dateLocale);
    }
}

