/*
 * Decompiled with CFR 0.152.
 */
package com.fluenda.parcefone.event;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacAddress
implements Comparable<MacAddress> {
    private static final int ADDRESS_LENGTH = 6;
    private static final byte MUTLTICAST_FLAG = 1;
    private static final byte LOCAL_FLAG = 2;
    private static final char STANDARD_SEPARATOR = ':';
    private static final Pattern ADDRESS_PATTERN;
    private final byte[] address;

    public MacAddress(String macAddress) {
        this.address = this.parseMacAddress(macAddress);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.address, 6);
    }

    public boolean isMulticast() {
        return (this.address[0] & 1) == 1;
    }

    public boolean isLocal() {
        return (this.address[0] & 2) == 2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.address.length; ++i) {
            if (i != 0) {
                builder.append(':');
            }
            builder.append(String.format("%02x", this.address[i]));
        }
        return builder.toString();
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof MacAddress) {
            MacAddress macAddress = (MacAddress)object;
            equals = Arrays.equals(this.address, macAddress.address);
        }
        return equals;
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }

    @Override
    public int compareTo(MacAddress macAddress) {
        int comparison = 0;
        for (int i = 0; i < 6 && (comparison = this.address[i] - macAddress.address[i]) == 0; ++i) {
        }
        return comparison;
    }

    private byte[] parseMacAddress(String macAddress) {
        Objects.requireNonNull(macAddress, "Address required");
        Matcher matcher = ADDRESS_PATTERN.matcher(macAddress);
        if (matcher.matches()) {
            byte[] parsedAddress = new byte[6];
            for (int group = 1; group <= 6; ++group) {
                String matchedGroup = matcher.group(group);
                int parsedGroup = Integer.parseInt(matchedGroup, 16);
                int index = group - 1;
                parsedAddress[index] = (byte)parsedGroup;
            }
            return parsedAddress;
        }
        throw new IllegalArgumentException(String.format("Address not valid [%s]", macAddress));
    }

    static {
        StringBuilder patternBuilder = new StringBuilder("^\\s*");
        for (int i = 1; i <= 6; ++i) {
            patternBuilder.append("([0-9a-fA-F]{2})");
            if (i == 6) continue;
            patternBuilder.append("(?:[\\s-:._]?)");
        }
        patternBuilder.append("\\s*$");
        ADDRESS_PATTERN = Pattern.compile(patternBuilder.toString());
    }
}

