/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.android.versionlint;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class FlurryVersionDetector
extends Detector
implements Detector.GradleScanner {
    private static final String ISSUE_ID = "FlurryVersionMismatch";
    private static final String BRIEF_DESCRIPTION = "Incompatible Flurry Versions";
    private static final String EXPLANATION = "All com.flurry.android libraries must use the exact same version specification(mixing versions can lead to runtime crash)";
    private static final String FLURRY_GROUP_ID = "com.flurry.android";
    private static final String SUGGESTION = "configurations.all {\n\tresolutionStrategy.eachDependency { detail ->\n\t\tif (detail.requested.group == \"com.flurry.android\") {\n\t\t\tdetail.useVersion \"$flurryVersion\"\n\t\t}\n\t}\n}";
    public static final Issue FLURRY_VERSION_MISMATCH = Issue.create((String)"FlurryVersionMismatch", (String)"Incompatible Flurry Versions", (String)"All com.flurry.android libraries must use the exact same version specification(mixing versions can lead to runtime crash)", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(FlurryVersionDetector.class, Scope.GRADLE_SCOPE));
    private List<String> flurryDependencies;
    private Set<String> flurryVersionSet;

    public boolean getCustomVisitor() {
        return true;
    }

    public void beforeCheckFile(Context context) {
        this.flurryDependencies = new ArrayList<String>();
        this.flurryVersionSet = new TreeSet<String>();
    }

    public void visitBuildScript(Context context) {
        Project project = context.getMainProject();
        this.checkProjectDependencies(project);
    }

    public void afterCheckFile(Context context) {
        if (this.flurryVersionSet.size() <= 1) {
            return;
        }
        context.report(FLURRY_VERSION_MISMATCH, this.getReportLocation(context), this.generateErrorMessage());
    }

    private void checkProjectDependencies(Project project) {
    }

    private Location getReportLocation(Context context) {
        Project project = context.getMainProject();
        return LintUtils.guessGradleLocation((LintClient)project.getClient(), (File)project.getDir(), (String)FLURRY_GROUP_ID);
    }

    private String generateErrorMessage() {
        return "Flurry version mismatched detected. Found versions: " + this.generateFlurryVersionString() + "\nFound dependencies: \n" + this.generateFlurryDependenciesList() + "\nConsider to use resolutionStrategy to avoid version mismatch: \n" + SUGGESTION;
    }

    private String generateFlurryVersionString() {
        StringBuilder sb = new StringBuilder();
        for (String version : this.flurryVersionSet) {
            sb.append(version).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    private String generateFlurryDependenciesList() {
        StringBuilder sb = new StringBuilder();
        for (String dependency : this.flurryDependencies) {
            sb.append(dependency).append("\n");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

