/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.TransferRequest;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Transfer {
    private String ERROR = "Error processing request, please check logs";

    public Response runTransaction(TransferRequest transferRequest) {
        return Optional.of(Utility.post(Properties.getProperty("TRANSFER_BASE"), transferRequest.toString(), ChargeTypes.TRANSFER, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runBulkTransaction(List<TransferRequest> transferRequest) {
        return Optional.of(Utility.post(Properties.getProperty("BULK_TRANSFER_ENDPOINT"), transferRequest.toString(), ChargeTypes.TRANSFER, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response retry(int id) {
        return Optional.of(Utility.post(Properties.getProperty("TRANSFER_BASE") + id + "/retries", null, ChargeTypes.TRANSFER, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response getFee(BigDecimal amount) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("amount", amount.toString()));
        return Optional.of(Utility.get(Properties.getProperty("TRANSFER_FEE_ENDPOINT"), ChargeTypes.TRANSFER, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response getTransferRate(BigDecimal amount, String destination_currency, String source_currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("amount", amount.toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("destination_currency", destination_currency));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("source_currency", source_currency));
        return Optional.of(Utility.get(Properties.getProperty("TRANSFER_FEE_ENDPOINT"), ChargeTypes.TRANSFER, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response getTransfer(int id) {
        return Optional.of(Utility.get(Properties.getProperty("TRANSFER_BASE") + "/" + id, ChargeTypes.TRANSFER, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse getAllTransfers(Optional<String> page, Optional<String> status) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        page.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", s)));
        status.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("status", s)));
        return Optional.of(Utility.get(Properties.getProperty("TRANSFER_BASE"), ChargeTypes.TRANSFER, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

