/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.RootNodeConfig;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import java.util.List;
import java.util.Map;

public class DataDrivenGenerationConfig {
    private String name;
    private String rootClass;
    private Map<String, Object> configMap;
    private List<Object> nodes;
    private boolean enableAudit;
    private boolean printEventToString = false;
    private EventLogControlEvent.LogLevel auditMethodTraceLogLevel = EventLogControlEvent.LogLevel.DEBUG;
    private FluxtionCompilerConfig compilerConfig;

    public RootNodeConfig getRootNodeConfig() {
        Class<?> rootClass1 = this.rootClass == null ? null : Class.forName(this.rootClass, true, this.compilerConfig.getClassLoader());
        return new RootNodeConfig(this.name, rootClass1, this.configMap, this.nodes);
    }

    public EventProcessorConfig getEventProcessorConfig() {
        EventProcessorConfig eventProcessorConfig = new EventProcessorConfig();
        eventProcessorConfig.setRootNodeConfig(this.getRootNodeConfig());
        if (this.enableAudit) {
            eventProcessorConfig.addEventAudit(this.auditMethodTraceLogLevel, this.printEventToString);
        }
        return eventProcessorConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getRootClass() {
        return this.rootClass;
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public List<Object> getNodes() {
        return this.nodes;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public boolean isPrintEventToString() {
        return this.printEventToString;
    }

    public EventLogControlEvent.LogLevel getAuditMethodTraceLogLevel() {
        return this.auditMethodTraceLogLevel;
    }

    public FluxtionCompilerConfig getCompilerConfig() {
        return this.compilerConfig;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRootClass(String rootClass) {
        this.rootClass = rootClass;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public void setNodes(List<Object> nodes) {
        this.nodes = nodes;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void setPrintEventToString(boolean printEventToString) {
        this.printEventToString = printEventToString;
    }

    public void setAuditMethodTraceLogLevel(EventLogControlEvent.LogLevel auditMethodTraceLogLevel) {
        this.auditMethodTraceLogLevel = auditMethodTraceLogLevel;
    }

    public void setCompilerConfig(FluxtionCompilerConfig compilerConfig) {
        this.compilerConfig = compilerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataDrivenGenerationConfig)) {
            return false;
        }
        DataDrivenGenerationConfig other = (DataDrivenGenerationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableAudit() != other.isEnableAudit()) {
            return false;
        }
        if (this.isPrintEventToString() != other.isPrintEventToString()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$rootClass = this.getRootClass();
        String other$rootClass = other.getRootClass();
        if (this$rootClass == null ? other$rootClass != null : !this$rootClass.equals(other$rootClass)) {
            return false;
        }
        Map<String, Object> this$configMap = this.getConfigMap();
        Map<String, Object> other$configMap = other.getConfigMap();
        if (this$configMap == null ? other$configMap != null : !((Object)this$configMap).equals(other$configMap)) {
            return false;
        }
        List<Object> this$nodes = this.getNodes();
        List<Object> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        EventLogControlEvent.LogLevel this$auditMethodTraceLogLevel = this.getAuditMethodTraceLogLevel();
        EventLogControlEvent.LogLevel other$auditMethodTraceLogLevel = other.getAuditMethodTraceLogLevel();
        if (this$auditMethodTraceLogLevel == null ? other$auditMethodTraceLogLevel != null : !this$auditMethodTraceLogLevel.equals(other$auditMethodTraceLogLevel)) {
            return false;
        }
        FluxtionCompilerConfig this$compilerConfig = this.getCompilerConfig();
        FluxtionCompilerConfig other$compilerConfig = other.getCompilerConfig();
        return !(this$compilerConfig == null ? other$compilerConfig != null : !this$compilerConfig.equals(other$compilerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataDrivenGenerationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableAudit() ? 79 : 97);
        result = result * 59 + (this.isPrintEventToString() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $rootClass = this.getRootClass();
        result = result * 59 + ($rootClass == null ? 43 : $rootClass.hashCode());
        Map<String, Object> $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : ((Object)$configMap).hashCode());
        List<Object> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        EventLogControlEvent.LogLevel $auditMethodTraceLogLevel = this.getAuditMethodTraceLogLevel();
        result = result * 59 + ($auditMethodTraceLogLevel == null ? 43 : $auditMethodTraceLogLevel.hashCode());
        FluxtionCompilerConfig $compilerConfig = this.getCompilerConfig();
        result = result * 59 + ($compilerConfig == null ? 43 : $compilerConfig.hashCode());
        return result;
    }

    public String toString() {
        return "DataDrivenGenerationConfig(name=" + this.getName() + ", rootClass=" + this.getRootClass() + ", configMap=" + this.getConfigMap() + ", nodes=" + this.getNodes() + ", enableAudit=" + this.isEnableAudit() + ", printEventToString=" + this.isPrintEventToString() + ", auditMethodTraceLogLevel=" + this.getAuditMethodTraceLogLevel() + ", compilerConfig=" + this.getCompilerConfig() + ")";
    }

    public DataDrivenGenerationConfig(String name, String rootClass, Map<String, Object> configMap, List<Object> nodes, boolean enableAudit, boolean printEventToString, EventLogControlEvent.LogLevel auditMethodTraceLogLevel, FluxtionCompilerConfig compilerConfig) {
        this.name = name;
        this.rootClass = rootClass;
        this.configMap = configMap;
        this.nodes = nodes;
        this.enableAudit = enableAudit;
        this.printEventToString = printEventToString;
        this.auditMethodTraceLogLevel = auditMethodTraceLogLevel;
        this.compilerConfig = compilerConfig;
    }

    public DataDrivenGenerationConfig() {
    }
}

